/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.maven.BootstrapWagonProvider;
import io.quarkus.bootstrap.resolver.maven.MavenModelBuilder;
import io.quarkus.bootstrap.resolver.maven.SettingsDecrypterImpl;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.util.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.building.ModelProblemCollectorRequest;
import org.apache.maven.model.path.DefaultPathTranslator;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.FileProfileActivator;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.jboss.logging.Logger;

@Deprecated
public class MavenRepoInitializer {
    private static final String DEFAULT_REMOTE_REPO_ID = "central";
    private static final String DEFAULT_REMOTE_REPO_URL = "https://repo.maven.apache.org/maven2";
    private static final String BASEDIR = "basedir";
    private static final String DOT_M2 = ".m2";
    private static final String MAVEN_DOT_HOME = "maven.home";
    private static final String MAVEN_HOME = "MAVEN_HOME";
    private static final String SETTINGS_XML = "settings.xml";
    private static final String userHome = PropertyUtils.getUserHome();
    private static final File userMavenConfigurationHome = new File(userHome, ".m2");
    private static final String envM2Home = System.getenv("MAVEN_HOME");
    private static final File USER_SETTINGS_FILE;
    private static final File GLOBAL_SETTINGS_FILE;
    private static final String ALTERNATE_USER_SETTINGS = "s";
    private static final String ALTERNATE_GLOBAL_SETTINGS = "gs";
    private static final String ALTERNATE_POM_FILE = "f";
    private static final String OFFLINE = "o";
    private static final String SUPRESS_SNAPSHOT_UPDATES = "nsu";
    private static final String UPDATE_SNAPSHOTS = "U";
    private static final String CHECKSUM_FAILURE_POLICY = "C";
    private static final String CHECKSUM_WARNING_POLICY = "c";
    private static final BootstrapMavenOptions mvnArgs;
    private static Settings settings;
    private static final Logger log;

    private static File resolveUserSettings(String settingsArg) {
        File userSettings = new File(settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        String base = System.getenv("MAVEN_PROJECTBASEDIR");
        if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
            return userSettings;
        }
        base = PropertyUtils.getProperty(BASEDIR);
        if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
            return userSettings;
        }
        userSettings = new File(userHome, settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        return null;
    }

    public static RepositorySystem getRepositorySystem() {
        return MavenRepoInitializer.getRepositorySystem(false, null);
    }

    public static BootstrapMavenOptions getBootstrapMavenOptions() {
        return mvnArgs;
    }

    public static RepositorySystem getRepositorySystem(boolean offline, WorkspaceModelResolver wsModelResolver) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        if (!offline) {
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
            locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new BootstrapWagonProvider()});
        }
        try {
            locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new MavenModelBuilder(wsModelResolver, mvnArgs, wsModelResolver == null ? Collections.emptyList() : MavenRepoInitializer.getActiveSettingsProfiles())});
        }
        catch (AppModelResolverException e) {
            throw new IllegalStateException("Failed to resolve active settings profiles", e);
        }
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                log.error((Object)("Failed to initialize " + impl.getName() + " as a service implementing " + type.getName()), exception);
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system) throws AppModelResolverException {
        return MavenRepoInitializer.newSession(system, MavenRepoInitializer.getSettings());
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system, Settings settings) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        List mirrors = settings.getMirrors();
        if (mirrors != null && !mirrors.isEmpty()) {
            DefaultMirrorSelector ms = new DefaultMirrorSelector();
            for (Mirror m : mirrors) {
                ms.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
            }
            session.setMirrorSelector((MirrorSelector)ms);
        }
        String localRepoPath = MavenRepoInitializer.getLocalRepo(settings);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, new LocalRepository(localRepoPath)));
        session.setOffline(settings.isOffline());
        if (!mvnArgs.isEmpty()) {
            if (!session.isOffline() && mvnArgs.hasOption(OFFLINE)) {
                session.setOffline(true);
            }
            if (mvnArgs.hasOption(SUPRESS_SNAPSHOT_UPDATES)) {
                session.setUpdatePolicy("never");
            } else if (mvnArgs.hasOption(UPDATE_SNAPSHOTS)) {
                session.setUpdatePolicy("always");
            }
            if (mvnArgs.hasOption(CHECKSUM_FAILURE_POLICY)) {
                session.setChecksumPolicy("fail");
            } else if (mvnArgs.hasOption(CHECKSUM_WARNING_POLICY)) {
                session.setChecksumPolicy("warn");
            }
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(settings.getProxies());
        decrypt.setServers(settings.getServers());
        SettingsDecryptionResult decrypted = new SettingsDecrypterImpl().decrypt((SettingsDecryptionRequest)decrypt);
        if (!decrypted.getProblems().isEmpty() && log.isDebugEnabled()) {
            for (SettingsProblem p : decrypted.getProblems()) {
                log.debug((Object)p.getMessage(), (Throwable)p.getException());
            }
        }
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (org.apache.maven.settings.Proxy p : decrypted.getProxies()) {
            proxySelector.add(MavenRepoInitializer.toAetherProxy(p), p.getNonProxyHosts());
        }
        session.setProxySelector((ProxySelector)proxySelector);
        LinkedHashMap<Object, Object> configProps = new LinkedHashMap<Object, Object>();
        configProps.put("aether.connector.userAgent", MavenRepoInitializer.getUserAgent());
        configProps.put("aether.interactive", settings.isInteractiveMode());
        configProps.putAll(System.getProperties());
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                configProps.put("aether.connector.wagon.config." + server.getId(), config);
            }
            configProps.put("aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            configProps.put("aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector((AuthenticationSelector)authSelector);
        session.setConfigProperties(configProps);
        return session;
    }

    public static List<RemoteRepository> getRemoteRepos(RepositorySystem repoSystem, RepositorySystemSession repoSession) throws AppModelResolverException {
        return Collections.unmodifiableList(MavenRepoInitializer.getRemoteRepos(MavenRepoInitializer.getSettings(), repoSystem, repoSession));
    }

    public static List<RemoteRepository> getRemoteRepos(Settings settings) throws AppModelResolverException {
        RepositorySystem system = MavenRepoInitializer.getRepositorySystem();
        return MavenRepoInitializer.getRemoteRepos(settings, system, (RepositorySystemSession)MavenRepoInitializer.newSession(system, settings));
    }

    public static List<RemoteRepository> getRemoteRepos(Settings settings, RepositorySystem repoSystem, RepositorySystemSession repoSession) throws AppModelResolverException {
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
        int profilesTotal = settings.getProfiles().size();
        if (profilesTotal > 0) {
            for (org.apache.maven.model.Profile modelProfile : MavenRepoInitializer.getActiveSettingsProfiles(settings)) {
                MavenRepoInitializer.addProfileRepos(modelProfile, remotes);
            }
        }
        if (remotes.isEmpty() || !MavenRepoInitializer.includesDefaultRepo(remotes)) {
            remotes.add(new RemoteRepository.Builder(DEFAULT_REMOTE_REPO_ID, "default", DEFAULT_REMOTE_REPO_URL).setReleasePolicy(new RepositoryPolicy(true, "daily", "warn")).setSnapshotPolicy(new RepositoryPolicy(false, "daily", "warn")).build());
        }
        return repoSystem.newResolutionRepositories(repoSession, remotes);
    }

    public static List<org.apache.maven.model.Profile> getActiveSettingsProfiles() throws AppModelResolverException {
        return MavenRepoInitializer.getActiveSettingsProfiles(MavenRepoInitializer.getSettings());
    }

    public static List<org.apache.maven.model.Profile> getActiveSettingsProfiles(Settings settings) throws AppModelResolverException {
        int profilesTotal = settings.getProfiles().size();
        if (profilesTotal == 0) {
            return Collections.emptyList();
        }
        ArrayList<org.apache.maven.model.Profile> modelProfiles = new ArrayList<org.apache.maven.model.Profile>(profilesTotal);
        for (Profile profile : settings.getProfiles()) {
            modelProfiles.add(SettingsUtils.convertFromSettingsProfile((Profile)profile));
        }
        List activeProfiles = mvnArgs.getActiveProfileIds();
        List<String> inactiveProfiles = mvnArgs.getInactiveProfileIds();
        Path currentPom = MavenRepoInitializer.getCurrentProjectPomOrNull();
        DefaultProfileActivationContext context = new DefaultProfileActivationContext().setActiveProfileIds(activeProfiles).setInactiveProfileIds(inactiveProfiles).setSystemProperties(System.getProperties()).setProjectDirectory(currentPom == null ? MavenRepoInitializer.getCurrentDir().toFile() : currentPom.getParent().toFile());
        DefaultProfileSelector profileSelector = new DefaultProfileSelector().addProfileActivator((ProfileActivator)new PropertyProfileActivator()).addProfileActivator((ProfileActivator)new JdkVersionProfileActivator()).addProfileActivator((ProfileActivator)new OperatingSystemProfileActivator()).addProfileActivator((ProfileActivator)new FileProfileActivator().setPathTranslator((PathTranslator)new DefaultPathTranslator()));
        modelProfiles = profileSelector.getActiveProfiles(modelProfiles, (ProfileActivationContext)context, new ModelProblemCollector(){

            public void add(ModelProblemCollectorRequest req) {
                log.error((Object)("Failed to activate a Maven profile: " + req.getMessage()));
            }
        });
        activeProfiles = settings.getActiveProfiles();
        if (!activeProfiles.isEmpty()) {
            for (String profileName : activeProfiles) {
                Profile profile = MavenRepoInitializer.getProfile(profileName, settings);
                if (profile == null) continue;
                modelProfiles.add(SettingsUtils.convertFromSettingsProfile((Profile)profile));
            }
        }
        return modelProfiles;
    }

    static Path getCurrentProjectPomOrNull() {
        Path pom;
        String pomName = mvnArgs.getOptionValue(ALTERNATE_POM_FILE);
        if (pomName == null) {
            pomName = "pom.xml";
        }
        if (!(pom = Paths.get(pomName, new String[0])).isAbsolute()) {
            pom = MavenRepoInitializer.getCurrentDir().resolve(pom);
        }
        if (Files.isDirectory(pom, new LinkOption[0])) {
            pom = pom.resolve("pom.xml");
        }
        return Files.exists(pom, new LinkOption[0]) ? pom : null;
    }

    private static Path getCurrentDir() {
        String basedirProp = PropertyUtils.getProperty(BASEDIR);
        return basedirProp == null ? Paths.get("", new String[0]).normalize().toAbsolutePath() : Paths.get(basedirProp, new String[0]);
    }

    private static Proxy toAetherProxy(org.apache.maven.settings.Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        Authentication auth = null;
        if (proxy.getUsername() != null) {
            auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
    }

    private static Profile getProfile(String name, Settings settings) throws AppModelResolverException {
        Profile profile = (Profile)settings.getProfilesAsMap().get(name);
        if (profile == null) {
            MavenRepoInitializer.unrecognizedProfile(name, true);
        }
        return profile;
    }

    private static void unrecognizedProfile(String name, boolean activate) {
        StringBuilder buf = new StringBuilder();
        buf.append("The requested Maven profile \"").append(name).append("\" could not be ");
        if (!activate) {
            buf.append("de");
        }
        buf.append("activated because it does not exist.");
        log.warn((Object)buf.toString());
    }

    private static void addProfileRepos(org.apache.maven.model.Profile profile, List<RemoteRepository> all) {
        List repositories = profile.getRepositories();
        for (Repository repo : repositories) {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            org.apache.maven.model.RepositoryPolicy policy = repo.getReleases();
            if (policy != null) {
                repoBuilder.setReleasePolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            if ((policy = repo.getSnapshots()) != null) {
                repoBuilder.setSnapshotPolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            all.add(repoBuilder.build());
        }
    }

    public static Settings getSettings() throws AppModelResolverException {
        Settings effectiveSettings;
        if (settings != null) {
            return settings;
        }
        try {
            SettingsBuildingResult result = new DefaultSettingsBuilderFactory().newInstance().build((SettingsBuildingRequest)new DefaultSettingsBuildingRequest().setSystemProperties(System.getProperties()).setUserSettingsFile(USER_SETTINGS_FILE).setGlobalSettingsFile(GLOBAL_SETTINGS_FILE));
            List problems = result.getProblems();
            if (!problems.isEmpty()) {
                for (SettingsProblem problem : problems) {
                    switch (problem.getSeverity()) {
                        case ERROR: 
                        case FATAL: {
                            throw new AppModelResolverException("Settings problem encountered at " + problem.getLocation(), problem.getException());
                        }
                    }
                    log.warn((Object)("Settings problem encountered at " + problem.getLocation()), (Throwable)problem.getException());
                }
            }
            effectiveSettings = result.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new AppModelResolverException("Failed to initialize Maven repository settings", e);
        }
        settings = effectiveSettings;
        return settings;
    }

    public static String getLocalRepo(Settings settings) {
        String localRepo = System.getenv("QUARKUS_LOCAL_REPO");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = PropertyUtils.getProperty("maven.repo.local");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = settings.getLocalRepository();
        return localRepo == null ? MavenRepoInitializer.getDefaultLocalRepo() : localRepo;
    }

    private static String getDefaultLocalRepo() {
        return new File(userMavenConfigurationHome, "repository").getAbsolutePath();
    }

    private static boolean includesDefaultRepo(List<RemoteRepository> repositories) {
        for (ArtifactRepository artifactRepository : repositories) {
            if (!artifactRepository.getId().equals(DEFAULT_REMOTE_REPO_ID)) continue;
            return true;
        }
        return false;
    }

    private static RepositoryPolicy toAetherRepoPolicy(org.apache.maven.model.RepositoryPolicy modelPolicy) {
        return new RepositoryPolicy(modelPolicy.isEnabled(), MavenRepoInitializer.isEmpty(modelPolicy.getUpdatePolicy()) ? "daily" : modelPolicy.getUpdatePolicy(), MavenRepoInitializer.isEmpty(modelPolicy.getChecksumPolicy()) ? "warn" : modelPolicy.getChecksumPolicy());
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static String getUserAgent() {
        return "Apache-Maven/" + MavenRepoInitializer.getMavenVersion() + " (Java " + PropertyUtils.getProperty("java.version") + "; " + PropertyUtils.getProperty("os.name") + " " + PropertyUtils.getProperty("os.version") + ")";
    }

    private static String getMavenVersion() {
        Properties props = new Properties();
        try (InputStream is = MavenRepoInitializer.class.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to read Maven version", (Throwable)e);
        }
        return props.getProperty("version", "unknown-version");
    }

    static {
        mvnArgs = BootstrapMavenOptions.newInstance();
        String userSettings = mvnArgs.getOptionValue(ALTERNATE_USER_SETTINGS);
        String globalSettings = mvnArgs.getOptionValue(ALTERNATE_GLOBAL_SETTINGS);
        File f = userSettings != null ? MavenRepoInitializer.resolveUserSettings(userSettings) : new File(userMavenConfigurationHome, SETTINGS_XML);
        File file = USER_SETTINGS_FILE = f != null && f.exists() ? f : null;
        f = globalSettings != null ? MavenRepoInitializer.resolveUserSettings(globalSettings) : new File(PropertyUtils.getProperty(MAVEN_DOT_HOME, envM2Home != null ? envM2Home : ""), "conf/settings.xml");
        GLOBAL_SETTINGS_FILE = f != null && f.exists() ? f : null;
        log = Logger.getLogger(MavenRepoInitializer.class);
    }
}

