/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.smallrye.common.io.jar.JarEntries;
import io.smallrye.common.io.jar.JarFiles;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public class JarClassPathElement
implements ClassPathElement {
    private static final int JAVA_VERSION;
    private static final Logger log;
    public static final String META_INF_VERSIONS = "META-INF/versions/";
    private final File file;
    private final URL jarPath;
    private final Path root;
    private final Lock readLock;
    private final Lock writeLock;
    private final JarFile jarFile;
    private volatile boolean closed;

    public JarClassPathElement(Path root) {
        try {
            this.jarPath = root.toUri().toURL();
            this.root = root;
            this.file = root.toFile();
            this.jarFile = JarFiles.create((File)this.file);
            ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
            this.readLock = readWriteLock.readLock();
            this.writeLock = readWriteLock.writeLock();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while reading file as JAR: " + root, e);
        }
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public synchronized ClassPathResource getResource(final String name) {
        return this.withJarFile(new Function<JarFile, ClassPathResource>(){

            @Override
            public ClassPathResource apply(JarFile jarFile) {
                final JarEntry res = jarFile.getJarEntry(name);
                if (res != null) {
                    return new ClassPathResource(){

                        @Override
                        public ClassPathElement getContainingElement() {
                            return JarClassPathElement.this;
                        }

                        @Override
                        public String getPath() {
                            return name;
                        }

                        @Override
                        public URL getUrl() {
                            try {
                                String realName = JarEntries.getRealName((JarEntry)res);
                                if (realName.endsWith("/")) {
                                    realName = realName.substring(0, realName.length() - 1);
                                }
                                String urlFile = JarClassPathElement.this.jarPath.getProtocol() + ":" + JarClassPathElement.this.jarPath.getPath() + "!/" + realName;
                                return new URL("jar", null, urlFile);
                            }
                            catch (MalformedURLException e) {
                                throw new UncheckedIOException(e);
                            }
                        }

                        @Override
                        public byte[] getData() {
                            return (byte[])JarClassPathElement.this.withJarFile(new Function<JarFile, byte[]>(){

                                @Override
                                public byte[] apply(JarFile jarFile) {
                                    try {
                                        try {
                                            return JarClassPathElement.readStreamContents(jarFile.getInputStream(res));
                                        }
                                        catch (InterruptedIOException e) {
                                            byte[] bytes = JarClassPathElement.readStreamContents(jarFile.getInputStream(res));
                                            Thread.currentThread().interrupt();
                                            return bytes;
                                        }
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException("Unable to read " + name, e);
                                    }
                                }
                            });
                        }

                        @Override
                        public boolean isDirectory() {
                            return res.getName().endsWith("/");
                        }
                    };
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private <T> T withJarFile(Function<JarFile, T> func) {
        this.readLock.lock();
        if (this.closed) {
            JarFile jarFile = JarFiles.create((File)this.file);
            Throwable throwable = null;
            T t = func.apply(jarFile);
            return t;
            {
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile != null) {
                        if (throwable != null) {
                            try {
                                jarFile.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            jarFile.close();
                        }
                    }
                }
                {
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        T t = func.apply(this.jarFile);
        return t;
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public synchronized Set<String> getProvidedResources() {
        return this.withJarFile(new Function<JarFile, Set<String>>(){

            @Override
            public Set<String> apply(JarFile jarFile) {
                HashSet<String> paths = new HashSet<String>();
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().endsWith("/")) {
                        paths.add(entry.getName().substring(0, entry.getName().length() - 1));
                        continue;
                    }
                    paths.add(entry.getName());
                }
                if (JarFiles.isMultiRelease((JarFile)jarFile)) {
                    HashSet<String> copy = new HashSet<String>(paths);
                    for (String i : copy) {
                        String part;
                        int slash;
                        if (!i.startsWith(JarClassPathElement.META_INF_VERSIONS) || (slash = (part = i.substring(JarClassPathElement.META_INF_VERSIONS.length())).indexOf("/")) == -1) continue;
                        try {
                            int ver = Integer.parseInt(part.substring(0, slash));
                            if (ver > JAVA_VERSION) continue;
                            paths.add(part.substring(slash + 1));
                        }
                        catch (NumberFormatException e) {
                            log.debug((Object)"Failed to parse META-INF/versions entry", (Throwable)e);
                        }
                    }
                }
                return paths;
            }
        });
    }

    @Override
    public ProtectionDomain getProtectionDomain(ClassLoader classLoader) {
        URL url;
        try {
            url = this.jarPath.toURI().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Unable to create protection domain for " + this.jarPath, e);
        }
        CodeSource codesource = new CodeSource(url, (Certificate[])null);
        return new ProtectionDomain(codesource, null, classLoader, null);
    }

    @Override
    public Manifest getManifest() {
        return this.withJarFile(new Function<JarFile, Manifest>(){

            @Override
            public Manifest apply(JarFile jarFile) {
                try {
                    return jarFile.getManifest();
                }
                catch (IOException e) {
                    log.warnf("Failed to parse manifest for %s", (Object)JarClassPathElement.this.jarPath);
                    return null;
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.writeLock.lock();
        try {
            this.jarFile.close();
            this.closed = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] readStreamContents(InputStream inputStream) throws IOException {
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int r;
                byte[] buf = new byte[10000];
                while ((r = inputStream.read(buf)) > 0) {
                    out.write(buf, 0, r);
                }
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    public String toString() {
        return this.file.getName() + ": " + this.jarPath;
    }

    static {
        int version = 8;
        try {
            Method versionMethod = Runtime.class.getMethod("version", new Class[0]);
            Object v = versionMethod.invoke(null, new Object[0]);
            List list = (List)v.getClass().getMethod("version", new Class[0]).invoke(v, new Object[0]);
            version = (Integer)list.get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JAVA_VERSION = version;
        log = Logger.getLogger(JarClassPathElement.class);
    }
}

