/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.paths;

import io.quarkus.paths.ArchivePathTree;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.Manifest;

class SharedArchivePathTree
extends ArchivePathTree {
    private static final Map<Path, SharedArchivePathTree> CACHE = new ConcurrentHashMap<Path, SharedArchivePathTree>();
    private final AtomicInteger openCount = new AtomicInteger();
    private volatile SharedOpenArchivePathTree lastOpen;

    static ArchivePathTree forPath(Path path) {
        return CACHE.computeIfAbsent(path, SharedArchivePathTree::new);
    }

    static void removeFromCache(Path path) {
        CACHE.remove(path);
    }

    SharedArchivePathTree(Path archive) {
        super(archive);
    }

    @Override
    public OpenPathTree open() {
        SharedOpenArchivePathTree lastOpen = this.lastOpen;
        if (lastOpen != null && lastOpen.acquire()) {
            return new CallerOpenPathTree(lastOpen);
        }
        try {
            this.lastOpen = new SharedOpenArchivePathTree(this.openFs());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new CallerOpenPathTree(this.lastOpen);
    }

    private class SharedOpenArchivePathTree
    extends ArchivePathTree.OpenArchivePathTree {
        private final AtomicInteger users;

        protected SharedOpenArchivePathTree(FileSystem fs) {
            super(fs);
            this.users = new AtomicInteger(1);
            SharedArchivePathTree.this.openCount.incrementAndGet();
        }

        private boolean acquire() {
            boolean result;
            this.readLock().lock();
            boolean bl = result = SharedArchivePathTree.this.lastOpen == this && this.isOpen();
            if (result) {
                this.users.incrementAndGet();
            }
            this.readLock().unlock();
            return result;
        }

        @Override
        public void close() throws IOException {
            this.writeLock().lock();
            boolean close = this.users.decrementAndGet() == 0;
            try {
                if (close) {
                    if (SharedArchivePathTree.this.lastOpen == this) {
                        SharedArchivePathTree.this.lastOpen = null;
                    }
                    if (SharedArchivePathTree.this.openCount.decrementAndGet() == 0) {
                        SharedArchivePathTree.removeFromCache(SharedArchivePathTree.this.archive);
                    }
                    super.close();
                }
            }
            finally {
                this.writeLock().unlock();
            }
        }
    }

    private static class CallerOpenPathTree
    implements OpenPathTree {
        private final SharedOpenArchivePathTree delegate;
        private volatile boolean closed;

        private CallerOpenPathTree(SharedOpenArchivePathTree delegate) {
            this.delegate = delegate;
        }

        @Override
        public PathTree getOriginalTree() {
            return this.delegate.getOriginalTree();
        }

        @Override
        public boolean isOpen() {
            return !this.closed && this.delegate.isOpen();
        }

        @Override
        public Path getPath(String relativePath) {
            return this.delegate.getPath(relativePath);
        }

        @Override
        public Collection<Path> getRoots() {
            return this.delegate.getRoots();
        }

        @Override
        public Manifest getManifest() {
            return this.delegate.getManifest();
        }

        @Override
        public void walk(PathVisitor visitor) {
            this.delegate.walk(visitor);
        }

        @Override
        public <T> T apply(String relativePath, Function<PathVisit, T> func) {
            return this.delegate.apply(relativePath, func);
        }

        @Override
        public void accept(String relativePath, Consumer<PathVisit> consumer) {
            this.delegate.accept(relativePath, consumer);
        }

        @Override
        public boolean contains(String relativePath) {
            return this.delegate.contains(relativePath);
        }

        @Override
        public OpenPathTree open() {
            return this.delegate.open();
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.delegate.writeLock().lock();
            try {
                if (!this.closed) {
                    this.closed = true;
                    this.delegate.close();
                }
            }
            finally {
                this.delegate.writeLock().unlock();
            }
        }
    }
}

