/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import java.io.Serializable;

public class AppArtifactKey
implements ArtifactKey,
Serializable {
    private static final long serialVersionUID = -6758193261385541101L;
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;

    public static AppArtifactKey fromString(String str) {
        return new AppArtifactKey(GACT.split(str, new String[4], str.length()));
    }

    public AppArtifactKey(String[] parts) {
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts.length == 2 || parts[2] == null ? "" : parts[2];
        this.type = parts.length <= 3 || parts[3] == null ? "jar" : parts[3];
    }

    public AppArtifactKey(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    public AppArtifactKey(String groupId, String artifactId, String classifier) {
        this(groupId, artifactId, classifier, null);
    }

    public AppArtifactKey(String groupId, String artifactId, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactKey)) {
            return false;
        }
        ArtifactKey other = (ArtifactKey)obj;
        if (this.artifactId == null ? other.getArtifactId() != null : !this.artifactId.equals(other.getArtifactId())) {
            return false;
        }
        if (this.classifier == null ? other.getClassifier() != null : !this.classifier.equals(other.getClassifier())) {
            return false;
        }
        if (this.groupId == null ? other.getGroupId() != null : !this.groupId.equals(other.getGroupId())) {
            return false;
        }
        if (this.type == null) {
            return other.getType() == null;
        }
        return this.type.equals(other.getType());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        } else if (this.type != null) {
            buf.append(':');
        }
        if (this.type != null) {
            buf.append(':').append(this.type);
        }
        return buf.toString();
    }

    @Override
    public String toGacString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        }
        return buf.toString();
    }
}

