/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.bootstrap.model.PlatformStreamInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PlatformInfo
implements Serializable {
    private final String key;
    private final List<PlatformStreamInfo> streams = new ArrayList<PlatformStreamInfo>(1);

    public PlatformInfo(String key) {
        this.key = key;
    }

    public String getPlatformKey() {
        return this.key;
    }

    boolean isAligned(Collection<AppArtifactCoords> importedBoms) {
        if (this.streams.isEmpty()) {
            return true;
        }
        if (this.streams.size() > 1) {
            return false;
        }
        return this.streams.get(0).isAligned(importedBoms);
    }

    List<List<String>> getPossibleAlignments(Collection<AppArtifactCoords> importedPlatformBoms) {
        if (this.streams.size() > 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("Imported BOMs ");
            Iterator<AppArtifactCoords> it = importedPlatformBoms.iterator();
            if (it.hasNext()) {
                buf.append(it.next());
                while (it.hasNext()) {
                    buf.append(", ").append(it.next());
                }
            }
            buf.append(" belong to different platform streams ").append(this.streams.get(0));
            for (int i = 1; i < this.streams.size(); ++i) {
                buf.append(", ").append(this.streams.get(i));
            }
            throw new RuntimeException(buf.append(" while only one stream per platform is allowed.").toString());
        }
        return this.streams.get(0).getPossibleAlignemnts(importedPlatformBoms);
    }

    PlatformStreamInfo getOrCreateStream(String stream) {
        PlatformStreamInfo s = this.getStream(stream);
        if (s == null) {
            s = new PlatformStreamInfo(stream);
            this.streams.add(s);
        }
        return s;
    }

    Collection<PlatformStreamInfo> getStreams() {
        return this.streams;
    }

    PlatformStreamInfo getStream(String stream) {
        for (PlatformStreamInfo s : this.streams) {
            if (!s.getId().equals(stream)) continue;
            return s;
        }
        return null;
    }
}

