/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.AppDependency;
import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface AppModelResolver {
    public void relink(AppArtifact var1, Path var2) throws AppModelResolverException;

    public Path resolve(AppArtifact var1) throws AppModelResolverException;

    default public List<AppDependency> resolveUserDependencies(AppArtifact artifact) throws AppModelResolverException {
        return this.resolveUserDependencies(artifact, Collections.emptyList());
    }

    public List<AppDependency> resolveUserDependencies(AppArtifact var1, List<AppDependency> var2) throws AppModelResolverException;

    public AppModel resolveModel(AppArtifact var1) throws AppModelResolverException;

    public AppModel resolveModel(AppArtifact var1, List<AppDependency> var2) throws AppModelResolverException;

    public AppModel resolveManagedModel(AppArtifact var1, List<AppDependency> var2, AppArtifact var3, Set<AppArtifactKey> var4) throws AppModelResolverException;

    public List<String> listLaterVersions(AppArtifact var1, String var2, boolean var3) throws AppModelResolverException;

    public String getNextVersion(AppArtifact var1, String var2, boolean var3, String var4, boolean var5) throws AppModelResolverException;

    public String getLatestVersion(AppArtifact var1, String var2, boolean var3) throws AppModelResolverException;

    public String getLatestVersionFromRange(AppArtifact var1, String var2) throws AppModelResolverException;
}

