/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.azure.functions.resteasy.deployment;

import io.quarkus.azure.functions.deployment.AzureFunctionBuildItem;
import io.quarkus.azure.functions.resteasy.runtime.Function;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;

public class AzureFunctionsHttpProcessor {
    private static final Logger log = Logger.getLogger(AzureFunctionsHttpProcessor.class);

    @BuildStep
    public RequireVirtualHttpBuildItem requestVirtualHttp(LaunchModeBuildItem launchMode) {
        return launchMode.getLaunchMode() == LaunchMode.NORMAL ? RequireVirtualHttpBuildItem.MARKER : null;
    }

    @BuildStep
    public void registerFunction(BuildProducer<AzureFunctionBuildItem> producer) {
        Method functionMethod = null;
        for (Method method : Function.class.getMethods()) {
            if (!method.getName().equals("run")) continue;
            functionMethod = method;
            break;
        }
        producer.produce((BuildItem)new AzureFunctionBuildItem("QuarkusHttp", Function.class, functionMethod));
    }
}

