/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.avro.deployment;

import io.quarkus.avro.deployment.AvroCodeGenProviderBase;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.avro.Conversions;
import org.apache.avro.Schema;
import org.apache.avro.compiler.specific.SpecificCompiler;

public class AvroSchemaCodeGenProvider
extends AvroCodeGenProviderBase
implements CodeGenProvider {
    Schema.Parser schemaParser;

    public String providerId() {
        return "avsc";
    }

    public String[] inputExtensions() {
        return new String[]{"avsc"};
    }

    @Override
    void init() {
        this.schemaParser = new Schema.Parser();
    }

    @Override
    void compileSingleFile(Path filePath, Path outputDirectory, AvroCodeGenProviderBase.AvroOptions options) throws CodeGenException {
        Schema schema;
        File file = filePath.toFile();
        try {
            schema = options.imports == null || options.imports.length == 0 ? new Schema.Parser().parse(file) : this.schemaParser.parse(file);
        }
        catch (IOException e) {
            throw new CodeGenException("", (Throwable)e);
        }
        SpecificCompiler compiler = new SpecificCompiler(schema);
        compiler.setTemplateDir("/org/apache/avro/compiler/specific/templates/java/classic/");
        compiler.setStringType(options.stringType);
        compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.PRIVATE);
        compiler.setCreateOptionalGetters(options.createOptionalGetters);
        compiler.setGettersReturnOptional(options.gettersReturnOptional);
        compiler.setOptionalGettersForNullableFieldsOnly(options.optionalGettersForNullableFieldsOnly);
        compiler.setCreateSetters(options.createSetters);
        compiler.setEnableDecimalLogicalType(options.enableDecimalLogicalType);
        compiler.setOutputCharacterEncoding("UTF-8");
        compiler.addCustomConversion(Conversions.UUIDConversion.class);
        for (String customConversion : options.customConversions) {
            try {
                Class<?> conversionClass = Class.forName(customConversion);
                if (conversionClass.isInstance(Conversions.UUIDConversion.class)) continue;
                compiler.addCustomConversion(conversionClass);
            }
            catch (ClassNotFoundException e) {
                throw new CodeGenException("Unable to find the following conversion class: " + customConversion, (Throwable)e);
            }
        }
        try {
            compiler.compileToDestination(file, outputDirectory.toFile());
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to copy compiled files to output directory " + String.valueOf(outputDirectory.toAbsolutePath()), (Throwable)e);
        }
    }
}

