/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.avro.deployment;

import io.quarkus.avro.deployment.AvroCodeGenProviderBase;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.avro.Protocol;
import org.apache.avro.compiler.specific.SpecificCompiler;

public class AvroProtocolCodeGenProvider
extends AvroCodeGenProviderBase
implements CodeGenProvider {
    public String providerId() {
        return "avpr";
    }

    public String[] inputExtensions() {
        return new String[]{"avpr"};
    }

    @Override
    void init() {
    }

    @Override
    void compileSingleFile(Path filePath, Path outputDirectory, AvroCodeGenProviderBase.AvroOptions options) throws CodeGenException {
        try {
            Protocol protocol = Protocol.parse((File)filePath.toFile());
            SpecificCompiler compiler = new SpecificCompiler(protocol);
            compiler.setTemplateDir("/org/apache/avro/compiler/specific/templates/java/classic/");
            compiler.setStringType(options.stringType);
            compiler.setFieldVisibility(SpecificCompiler.FieldVisibility.PRIVATE);
            compiler.setCreateOptionalGetters(options.createOptionalGetters);
            compiler.setGettersReturnOptional(options.gettersReturnOptional);
            compiler.setOptionalGettersForNullableFieldsOnly(options.optionalGettersForNullableFieldsOnly);
            compiler.setCreateSetters(options.createSetters);
            compiler.setEnableDecimalLogicalType(options.enableDecimalLogicalType);
            compiler.setOutputCharacterEncoding("UTF-8");
            compiler.compileToDestination(filePath.toFile(), outputDirectory.toFile());
        }
        catch (IOException e) {
            throw new CodeGenException("Failed to compile avro protocole file: " + filePath.toString() + " to Java", (Throwable)e);
        }
    }
}

