/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.runtime.dev.ui;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.runtime.dev.EventInfo;
import io.quarkus.arc.runtime.dev.EventsMonitor;
import io.quarkus.arc.runtime.dev.InvocationInfo;
import io.quarkus.arc.runtime.dev.console.Invocation;
import io.quarkus.arc.runtime.dev.console.InvocationsMonitor;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

public class ArcJsonRPCService {
    @Inject
    Instance<EventsMonitor> eventsMonitor;
    @Inject
    Instance<InvocationsMonitor> invocationsMonitor;

    public Multi<EventInfo> streamEvents() {
        return this.eventsMonitor.isResolvable() ? ((EventsMonitor)this.eventsMonitor.get()).streamEvents() : Multi.createFrom().empty();
    }

    public Multi<Boolean> streamSkipContextEvents() {
        return this.eventsMonitor.isResolvable() ? ((EventsMonitor)this.eventsMonitor.get()).streamSkipContextEvents() : Multi.createFrom().empty();
    }

    @NonBlocking
    public List<EventInfo> getLastEvents() {
        if (this.eventsMonitor.isResolvable()) {
            return ((EventsMonitor)this.eventsMonitor.get()).getLastEvents();
        }
        return List.of();
    }

    @NonBlocking
    public List<EventInfo> clearLastEvents() {
        if (this.eventsMonitor.isResolvable()) {
            ((EventsMonitor)this.eventsMonitor.get()).clear();
            return this.getLastEvents();
        }
        return List.of();
    }

    @NonBlocking
    public List<EventInfo> toggleSkipContextEvents() {
        if (this.eventsMonitor.isResolvable()) {
            ((EventsMonitor)this.eventsMonitor.get()).toggleSkipContextEvents();
            return this.getLastEvents();
        }
        return List.of();
    }

    @NonBlocking
    public List<InvocationInfo> getLastInvocations() {
        if (this.invocationsMonitor.isResolvable()) {
            List<Invocation> lastInvocations = ((InvocationsMonitor)this.invocationsMonitor.get()).getLastInvocations();
            return this.toInvocationInfos(lastInvocations);
        }
        return List.of();
    }

    @NonBlocking
    public List<InvocationInfo> clearLastInvocations() {
        if (this.invocationsMonitor.isResolvable()) {
            ((InvocationsMonitor)this.invocationsMonitor.get()).clear();
            return this.getLastInvocations();
        }
        return List.of();
    }

    private List<InvocationInfo> toInvocationInfos(List<Invocation> invocations) {
        ArrayList<InvocationInfo> infos = new ArrayList<InvocationInfo>();
        for (Invocation invocation : invocations) {
            infos.add(this.toInvocationInfo(invocation));
        }
        return infos;
    }

    private InvocationInfo toInvocationInfo(Invocation invocation) {
        InvocationInfo info = new InvocationInfo();
        info.setStartTime(this.timeString(LocalDateTime.ofInstant(Instant.ofEpochMilli(invocation.getStart()), ZoneId.systemDefault())));
        info.setMethodName(invocation.getDeclaringClassName() + "#" + invocation.getMethod().getName());
        info.setDuration(invocation.getDurationMillis());
        info.setKind(invocation.getKind().toString());
        info.setChildren(this.toInvocationInfos(invocation.getChildren()));
        info.setQuarkusBean(invocation.isQuarkusBean());
        return info;
    }

    private String timeString(LocalDateTime time) {
        String timestamp = time.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace("T", " ");
        int lastIndexOfDot = timestamp.lastIndexOf(".");
        return lastIndexOfDot > 0 ? timestamp.substring(0, lastIndexOfDot) : timestamp;
    }

    public List<String> getInactiveBeans() {
        ArrayList<String> result = new ArrayList<String>();
        for (Bean bean : Arc.container().beanManager().getBeans(Object.class, new Annotation[]{Any.Literal.INSTANCE})) {
            InjectableBean injectableBean = (InjectableBean)bean;
            if (injectableBean.isActive()) continue;
            result.add(injectableBean.getIdentifier());
        }
        return result;
    }
}

