/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics.dto.segment;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.quarkus.analytics.dto.segment.TrackEventType;
import io.quarkus.analytics.dto.segment.TrackProperties;
import java.io.Serializable;
import java.time.Instant;
import java.util.Map;

public class Track
implements Serializable {
    private String userId;
    private TrackEventType event;
    private TrackProperties properties;
    private Map<String, Object> context;
    private Instant timestamp;

    public Track() {
    }

    public Track(String userId, TrackEventType event, TrackProperties properties, Map<String, Object> context, Instant timestamp) {
        this.userId = userId;
        this.event = event;
        this.properties = properties;
        this.context = context;
        this.timestamp = timestamp;
    }

    public static TrackBuilder builder() {
        return new TrackBuilder();
    }

    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public TrackEventType getEvent() {
        return this.event;
    }

    public void setEvent(TrackEventType event) {
        this.event = event;
    }

    public TrackProperties getProperties() {
        return this.properties;
    }

    public void setProperties(TrackProperties properties) {
        this.properties = properties;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public Instant getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public static class TrackBuilder {
        private String userId;
        private TrackEventType event;
        private TrackProperties properties;
        private Map<String, Object> context;
        private Instant timestamp;

        TrackBuilder() {
        }

        public TrackBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public TrackBuilder event(TrackEventType event) {
            this.event = event;
            return this;
        }

        public TrackBuilder properties(TrackProperties properties) {
            this.properties = properties;
            return this;
        }

        public TrackBuilder context(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public TrackBuilder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Track build() {
            return new Track(this.userId, this.event, this.properties, this.context, this.timestamp);
        }

        public String toString() {
            return "Track.TrackBuilder(userId=" + this.userId + ", event=" + String.valueOf((Object)this.event) + ", properties=" + String.valueOf(this.properties) + ", context=" + String.valueOf(this.context) + ", timestamp=" + String.valueOf(this.timestamp) + ")";
        }
    }

    public static class EventPropertyNames {
        public static final String BUILD_DIAGNOSTICS = "build_diagnostics";
        public static final String APP_EXTENSIONS = "app_extensions";
    }
}

