/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import io.quarkus.amazon.lambda.http.DefaultLambdaAuthenticationRequest;
import io.quarkus.amazon.lambda.http.LambdaAuthenticationRequest;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.vertx.http.runtime.QuarkusHttpHeaders;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.quarkus.vertx.http.runtime.security.HttpSecurityUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@ApplicationScoped
public class LambdaHttpAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    Instance<IdentityProvider<LambdaAuthenticationRequest>> identityProviders;
    boolean useDefault;
    static final Set<Class<? extends AuthenticationRequest>> credentialTypes = new HashSet<Class<? extends AuthenticationRequest>>();

    @PostConstruct
    public void initialize() {
        this.useDefault = !this.identityProviders.iterator().hasNext();
    }

    public Uni<SecurityIdentity> authenticate(RoutingContext routingContext, IdentityProviderManager identityProviderManager) {
        APIGatewayV2HTTPEvent event;
        Map contextObjects;
        MultiMap qheaders = routingContext.request().headers();
        if (qheaders instanceof QuarkusHttpHeaders && (contextObjects = ((QuarkusHttpHeaders)qheaders).getContextObjects()).containsKey(APIGatewayV2HTTPEvent.class) && this.isAuthenticatable(event = (APIGatewayV2HTTPEvent)contextObjects.get(APIGatewayV2HTTPEvent.class))) {
            if (this.useDefault) {
                return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new DefaultLambdaAuthenticationRequest(event), (RoutingContext)routingContext));
            }
            return identityProviderManager.authenticate(HttpSecurityUtils.setRoutingContextAttribute((AuthenticationRequest)new LambdaAuthenticationRequest(event), (RoutingContext)routingContext));
        }
        return Uni.createFrom().optional(Optional.empty());
    }

    private boolean isAuthenticatable(APIGatewayV2HTTPEvent event) {
        Map<String, String> systemEnvironment = System.getenv();
        boolean isSamLocal = Boolean.parseBoolean(systemEnvironment.get("AWS_SAM_LOCAL"));
        String forcedUserName = systemEnvironment.get("QUARKUS_AWS_LAMBDA_FORCE_USER_NAME");
        return isSamLocal && forcedUserName != null || event.getRequestContext() != null && event.getRequestContext().getAuthorizer() != null;
    }

    public Uni<Boolean> sendChallenge(RoutingContext context) {
        return Uni.createFrom().item((Object)false);
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return Uni.createFrom().nullItem();
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return credentialTypes;
    }

    public Uni<HttpCredentialTransport> getCredentialTransport(RoutingContext context) {
        return Uni.createFrom().nullItem();
    }

    static {
        credentialTypes.add(LambdaAuthenticationRequest.class);
        credentialTypes.add(DefaultLambdaAuthenticationRequest.class);
    }
}

