/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import com.amazonaws.services.lambda.runtime.RequestHandler;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class RequestHandlerJandexUtil {
    private static final DotName REQUEST_HANDLER = DotName.createSimple(RequestHandler.class);
    private static final DotName OBJECT = DotName.createSimple((String)"java.lang.Object");
    private static final DotName COLLECTION = DotName.createSimple(Collection.class);

    private RequestHandlerJandexUtil() {
    }

    public static RequestHandlerJandexDefinition discoverHandlerMethod(String handlerClassName, IndexView index) {
        ClassInfo handlerClass = index.getClassByName(handlerClassName);
        if (handlerClass == null) {
            throw new IllegalArgumentException("RequestHandler class not found in the index: " + handlerClassName);
        }
        MethodInfo concreteHandleRequestMethod = RequestHandlerJandexUtil.findConcreteHandleRequestMethod(handlerClass, index);
        if (concreteHandleRequestMethod == null) {
            throw new IllegalStateException("Unable to find a concrete handleRequest method on handler class " + String.valueOf(handlerClass.name()));
        }
        HashMap<String, Type> typeMap = new HashMap<String, Type>();
        InputOutputTypes inputOutputTypes = RequestHandlerJandexUtil.resolveInputOutputTypes(handlerClass.name(), index, typeMap);
        if (RequestHandlerJandexUtil.isUnresolved(inputOutputTypes)) {
            throw new IllegalStateException("Unable to resolve input and output types for handler class " + String.valueOf(handlerClass.name()));
        }
        return new RequestHandlerJandexDefinition(handlerClass, concreteHandleRequestMethod, inputOutputTypes);
    }

    private static MethodInfo findConcreteHandleRequestMethod(ClassInfo handlerClass, IndexView index) {
        Type superType;
        ClassInfo currentClass = handlerClass;
        while (currentClass != null && !OBJECT.equals((Object)currentClass.name())) {
            for (MethodInfo method : currentClass.methods()) {
                if (!RequestHandlerJandexUtil.isHandleRequestMethod(method) || method.isSynthetic() || method.isAbstract()) continue;
                return method;
            }
            superType = currentClass.superClassType();
            if (superType != null) {
                currentClass = index.getClassByName(superType.name());
                continue;
            }
            currentClass = null;
        }
        currentClass = handlerClass;
        while (currentClass != null && !OBJECT.equals((Object)currentClass.name())) {
            for (Type ifaceType : currentClass.interfaceTypes()) {
                MethodInfo defaultMethod = RequestHandlerJandexUtil.findDefaultInterfaceMethod(ifaceType.name(), index);
                if (defaultMethod == null) continue;
                return defaultMethod;
            }
            superType = currentClass.superClassType();
            if (superType != null) {
                currentClass = index.getClassByName(superType.name());
                continue;
            }
            currentClass = null;
        }
        return null;
    }

    private static MethodInfo findDefaultInterfaceMethod(DotName ifaceName, IndexView index) {
        ClassInfo iface = index.getClassByName(ifaceName);
        if (iface == null) {
            return null;
        }
        for (MethodInfo method : iface.methods()) {
            if (!RequestHandlerJandexUtil.isHandleRequestMethod(method) || !method.isDefault()) continue;
            return method;
        }
        for (Type parentIfaceType : iface.interfaceTypes()) {
            MethodInfo defaultMethod = RequestHandlerJandexUtil.findDefaultInterfaceMethod(parentIfaceType.name(), index);
            if (defaultMethod == null) continue;
            return defaultMethod;
        }
        return null;
    }

    private static boolean isHandleRequestMethod(MethodInfo method) {
        return method.name().equals("handleRequest") && method.parametersCount() == 2;
    }

    private static boolean isCollectionType(DotName typeName, IndexView index) {
        if (COLLECTION.equals((Object)typeName)) {
            return true;
        }
        ClassInfo classInfo = index.getClassByName(typeName);
        if (classInfo == null) {
            return false;
        }
        for (Type interfaceType : classInfo.interfaceTypes()) {
            if (!RequestHandlerJandexUtil.isCollectionType(interfaceType.name(), index)) continue;
            return true;
        }
        Type superType = classInfo.superClassType();
        return superType != null && RequestHandlerJandexUtil.isCollectionType(superType.name(), index);
    }

    private static boolean isUnresolved(InputOutputTypes types) {
        return types == null || types == InputOutputTypes.UNRESOLVED;
    }

    private static InputOutputTypes resolveInputOutputTypes(DotName className, IndexView index, Map<String, Type> typeMap) {
        InputOutputTypes result;
        ClassInfo classInfo = index.getClassByName(className);
        if (classInfo == null) {
            return null;
        }
        for (Type interfaceType : classInfo.interfaceTypes()) {
            InputOutputTypes result2 = RequestHandlerJandexUtil.resolveInputOutputTypesFromType(interfaceType, index, typeMap);
            if (result2 == null) continue;
            return result2;
        }
        Type superType = classInfo.superClassType();
        if (superType != null && (result = RequestHandlerJandexUtil.resolveInputOutputTypesFromType(superType, index, typeMap)) != null) {
            return result;
        }
        return null;
    }

    private static InputOutputTypes resolveInputOutputTypesFromType(Type currentType, IndexView index, Map<String, Type> typeMap) {
        if (currentType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType pt = currentType.asParameterizedType();
            DotName rawName = pt.name();
            if (REQUEST_HANDLER.equals((Object)rawName)) {
                List args = pt.arguments();
                Type inputType = RequestHandlerJandexUtil.resolveTypeArgument((Type)args.get(0), typeMap);
                Type outputType = RequestHandlerJandexUtil.resolveTypeArgument((Type)args.get(1), typeMap);
                boolean isCollection = false;
                Type elementType = null;
                Type rawInputType = (Type)args.get(0);
                if (rawInputType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                    ParameterizedType inputPt = rawInputType.asParameterizedType();
                    if (RequestHandlerJandexUtil.isCollectionType(inputPt.name(), index)) {
                        isCollection = true;
                        if (!inputPt.arguments().isEmpty()) {
                            elementType = RequestHandlerJandexUtil.resolveTypeArgument((Type)inputPt.arguments().get(0), typeMap);
                        }
                    }
                } else if (rawInputType.kind() == Type.Kind.CLASS && RequestHandlerJandexUtil.isCollectionType(rawInputType.name(), index)) {
                    isCollection = true;
                    elementType = Type.create((DotName)OBJECT, (Type.Kind)Type.Kind.CLASS);
                }
                return new InputOutputTypes(inputType, isCollection, elementType, outputType);
            }
            ClassInfo rawClass = index.getClassByName(rawName);
            if (rawClass != null) {
                List vars = rawClass.typeParameters();
                List args = pt.arguments();
                HashMap<String, Type> newTypeMap = new HashMap<String, Type>(typeMap);
                for (int i = 0; i < vars.size() && i < args.size(); ++i) {
                    newTypeMap.put(((TypeVariable)vars.get(i)).identifier(), (Type)args.get(i));
                }
                InputOutputTypes result = RequestHandlerJandexUtil.resolveInputOutputTypes(rawName, index, newTypeMap);
                if (result != null) {
                    return result;
                }
            }
        } else if (currentType.kind() == Type.Kind.CLASS) {
            DotName className = currentType.name();
            if (REQUEST_HANDLER.equals((Object)className)) {
                return InputOutputTypes.UNRESOLVED;
            }
            return RequestHandlerJandexUtil.resolveInputOutputTypes(className, index, typeMap);
        }
        return null;
    }

    private static Type resolveTypeArgument(Type type, Map<String, Type> typeMap) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            TypeVariable tv = type.asTypeVariable();
            Type resolved = typeMap.get(tv.identifier());
            if (resolved != null) {
                return RequestHandlerJandexUtil.resolveTypeArgument(resolved, typeMap);
            }
            return RequestHandlerJandexUtil.getTypeFromBounds(tv);
        }
        return type;
    }

    private static Type getTypeFromBounds(TypeVariable tv) {
        List bounds = tv.bounds();
        if (!bounds.isEmpty()) {
            Type firstBound = (Type)bounds.get(0);
            if (firstBound.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                return Type.create((DotName)firstBound.name(), (Type.Kind)Type.Kind.CLASS);
            }
            return firstBound;
        }
        return Type.create((DotName)OBJECT, (Type.Kind)Type.Kind.CLASS);
    }

    public record InputOutputTypes(Type inputType, boolean isCollection, Type elementType, Type outputType) {
        private static final InputOutputTypes UNRESOLVED = new InputOutputTypes(Type.create((DotName)OBJECT, (Type.Kind)Type.Kind.CLASS), false, null, Type.create((DotName)OBJECT, (Type.Kind)Type.Kind.CLASS));
    }

    public record RequestHandlerJandexDefinition(ClassInfo handlerClass, MethodInfo method, InputOutputTypes inputOutputTypes) {
    }
}

