/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.amazon.lambda.deployment.LambdaObjectMapperInitializedBuildItem;
import io.quarkus.amazon.lambda.runtime.AmazonLambdaMapperRecorder;
import io.quarkus.amazon.lambda.runtime.FunctionError;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SnapStartDefaultValueBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.deployment.pkg.steps.NativeSourcesBuild;
import io.quarkus.jackson.runtime.ObjectMapperProducer;
import io.quarkus.runtime.LaunchMode;

public final class AmazonLambdaCommonProcessor {
    @BuildStep
    public SnapStartDefaultValueBuildItem enableSnapStartByDefault() {
        return new SnapStartDefaultValueBuildItem(true);
    }

    @BuildStep(onlyIf={NativeSourcesBuild.class})
    void failForNativeSources(BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        throw new IllegalArgumentException("The Amazon Lambda extensions are incompatible with the 'native-sources' package type.");
    }

    @BuildStep
    void tmpdirs(BuildProducer<SystemPropertyBuildItem> systemProperty, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (mode.isDevOrTest()) {
            return;
        }
        systemProperty.produce((BuildItem)new SystemPropertyBuildItem("java.io.tmpdir", "/tmp"));
        systemProperty.produce((BuildItem)new SystemPropertyBuildItem("vertx.cacheDirBase", "/tmp/vertx"));
    }

    @BuildStep
    public void markObjectMapper(BuildProducer<UnremovableBeanBuildItem> unremovable) {
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(ObjectMapper.class.getName())));
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(ObjectMapperProducer.class.getName())));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public LambdaObjectMapperInitializedBuildItem initObjectMapper(BeanContainerBuildItem beanContainer, AmazonLambdaMapperRecorder recorder) {
        recorder.initObjectMapper();
        return new LambdaObjectMapperInitializedBuildItem();
    }

    @BuildStep(onlyIf={NativeBuild.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void initContextReaders(AmazonLambdaMapperRecorder recorder, LambdaObjectMapperInitializedBuildItem dependency) {
        recorder.initContextReaders();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void initContextReaders(AmazonLambdaMapperRecorder recorder, LambdaObjectMapperInitializedBuildItem dependency, LaunchModeBuildItem launchModeBuildItem) {
        LaunchMode mode = launchModeBuildItem.getLaunchMode();
        if (mode.isDevOrTest()) {
            recorder.initContextReaders();
        }
    }

    @BuildStep(onlyIf={NativeBuild.class})
    public void registerForSerialization(BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{FunctionError.class.getName()}).build());
    }
}

