/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.tasks.EffectiveConfig;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import io.smallrye.config.SmallRyeConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class QuarkusShowEffectiveConfig
extends QuarkusBuildTask {
    private final Property<Boolean> saveConfigProperties = this.getProject().getObjects().property(Boolean.class).convention((Object)Boolean.FALSE);

    @Inject
    public QuarkusShowEffectiveConfig() {
        super("Collect dependencies for the Quarkus application, prefer the 'quarkusBuild' task");
    }

    @Option(option="save-config-properties", description="Save the effective Quarkus configuration properties to a file.")
    @Internal
    public Property<Boolean> getSaveConfigProperties() {
        return this.saveConfigProperties;
    }

    @TaskAction
    public void dumpEffectiveConfiguration() {
        block11: {
            try {
                EffectiveConfig effectiveConfig = this.extension().buildEffectiveConfiguration(this.extension().getApplicationModel().getAppArtifact());
                SmallRyeConfig config = effectiveConfig.getConfig();
                ArrayList sourceNames = new ArrayList();
                config.getConfigSources().forEach(configSource -> sourceNames.add(configSource.getName()));
                HashMap<String, String> values = new HashMap<String, String>();
                for (String key : config.getMapKeys("quarkus").values()) {
                    values.put(key, config.getConfigValue(key).getValue());
                }
                String quarkusConfig = values.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).sorted().collect(Collectors.joining("\n    ", "\n    ", "\n"));
                this.getLogger().lifecycle("Effective Quarkus configuration options: {}", new Object[]{quarkusConfig});
                String finalName = this.extension().finalName();
                String packageType = config.getOptionalValue("quarkus.package.type", String.class).orElse("fast-jar");
                File fastJar = this.fastJar();
                this.getLogger().lifecycle("Quarkus package type:          {}\nFinal name:                    {}\nOutput directory:              {}\nFast jar directory (if built): {}\nRunner jar (if built):         {}\nNative runner (if built):      {}\napplication.(properties|yaml|yml) sources: {}", new Object[]{packageType, finalName, this.outputDirectory(), fastJar, this.runnerJar(), this.nativeRunner(), sourceNames.stream().collect(Collectors.joining("\n        ", "\n        ", "\n"))});
                if (!((Boolean)this.getSaveConfigProperties().get()).booleanValue()) break block11;
                Properties props = new Properties();
                props.putAll(effectiveConfig.getValues());
                Path file = this.buildDir.toPath().resolve(finalName + ".quarkus-build.properties");
                try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
                    props.store(writer, String.format("Quarkus build properties with package type %s", packageType));
                }
                catch (IOException e2) {
                    throw new GradleException("Failed to write Quarkus build configuration settings", (Throwable)e2);
                }
                this.getLogger().lifecycle("\nWrote configuration settings to {}", new Object[]{file});
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw new GradleException("WTF", (Throwable)e3);
            }
        }
    }
}

