/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.dsl.Manifest;
import io.quarkus.gradle.tasks.EffectiveConfig;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.smallrye.config.SmallRyeConfig;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class BaseConfig {
    private final Manifest manifest = new Manifest();
    private final PackageConfig packageConfig = new PackageConfig();
    private final Map<String, String> values;

    BaseConfig(EffectiveConfig config) {
        ConfigInstantiator.handleObject((Object)this.packageConfig, (SmallRyeConfig)config.getConfig());
        this.manifest.attributes(this.packageConfig.manifest.attributes);
        this.packageConfig.manifest.manifestSections.forEach((section, attribs) -> this.manifest.attributes((Map<String, String>)attribs, (String)section));
        this.values = config.getValues();
    }

    PackageConfig packageConfig() {
        return this.packageConfig;
    }

    PackageConfig.BuiltInType packageType() {
        return PackageConfig.BuiltInType.fromString((String)this.packageConfig.type);
    }

    Manifest manifest() {
        return this.manifest;
    }

    Map<String, String> cachingRelevantProperties(List<String> propertyPatterns) {
        List patterns = propertyPatterns.stream().map(s -> "^(" + s + ")$").map(Pattern::compile).collect(Collectors.toList());
        Predicate<Map.Entry> keyPredicate = e -> patterns.stream().anyMatch(p -> p.matcher((CharSequence)e.getKey()).matches());
        return this.values.entrySet().stream().filter(keyPredicate).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

