/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.extension.SourceSetExtension;
import io.quarkus.gradle.tasks.Deploy;
import io.quarkus.gradle.tasks.ImageBuild;
import io.quarkus.gradle.tasks.ImagePush;
import io.quarkus.gradle.tasks.QuarkusAddExtension;
import io.quarkus.gradle.tasks.QuarkusBuild;
import io.quarkus.gradle.tasks.QuarkusBuildCacheableAppParts;
import io.quarkus.gradle.tasks.QuarkusBuildDependencies;
import io.quarkus.gradle.tasks.QuarkusDev;
import io.quarkus.gradle.tasks.QuarkusGenerateCode;
import io.quarkus.gradle.tasks.QuarkusGoOffline;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusInfo;
import io.quarkus.gradle.tasks.QuarkusListCategories;
import io.quarkus.gradle.tasks.QuarkusListExtensions;
import io.quarkus.gradle.tasks.QuarkusListPlatforms;
import io.quarkus.gradle.tasks.QuarkusRemoteDev;
import io.quarkus.gradle.tasks.QuarkusRemoveExtension;
import io.quarkus.gradle.tasks.QuarkusRun;
import io.quarkus.gradle.tasks.QuarkusShowEffectiveConfig;
import io.quarkus.gradle.tasks.QuarkusTest;
import io.quarkus.gradle.tasks.QuarkusTestConfig;
import io.quarkus.gradle.tasks.QuarkusUpdate;
import io.quarkus.gradle.tooling.GradleApplicationModelBuilder;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.gradle.tooling.dependency.ProjectExtensionDependency;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.util.GradleVersion;

public class QuarkusPlugin
implements Plugin<Project> {
    public static final String ID = "io.quarkus";
    public static final String DEFAULT_OUTPUT_DIRECTORY = "quarkus-app";
    public static final String QUARKUS_PACKAGE_TYPE = "quarkus.package.type";
    public static final String EXTENSION_NAME = "quarkus";
    public static final String LIST_EXTENSIONS_TASK_NAME = "listExtensions";
    public static final String LIST_CATEGORIES_TASK_NAME = "listCategories";
    public static final String LIST_PLATFORMS_TASK_NAME = "listPlatforms";
    public static final String ADD_EXTENSION_TASK_NAME = "addExtension";
    public static final String REMOVE_EXTENSION_TASK_NAME = "removeExtension";
    public static final String QUARKUS_GENERATE_CODE_TASK_NAME = "quarkusGenerateCode";
    public static final String QUARKUS_GENERATE_CODE_DEV_TASK_NAME = "quarkusGenerateCodeDev";
    public static final String QUARKUS_GENERATE_CODE_TESTS_TASK_NAME = "quarkusGenerateCodeTests";
    public static final String QUARKUS_BUILD_DEP_TASK_NAME = "quarkusDependenciesBuild";
    public static final String QUARKUS_BUILD_APP_PARTS_TASK_NAME = "quarkusAppPartsBuild";
    public static final String QUARKUS_SHOW_EFFECTIVE_CONFIG_TASK_NAME = "quarkusShowEffectiveConfig";
    public static final String QUARKUS_BUILD_TASK_NAME = "quarkusBuild";
    public static final String QUARKUS_DEV_TASK_NAME = "quarkusDev";
    public static final String QUARKUS_RUN_TASK_NAME = "quarkusRun";
    public static final String QUARKUS_REMOTE_DEV_TASK_NAME = "quarkusRemoteDev";
    public static final String QUARKUS_TEST_TASK_NAME = "quarkusTest";
    public static final String QUARKUS_GO_OFFLINE_TASK_NAME = "quarkusGoOffline";
    public static final String QUARKUS_INFO_TASK_NAME = "quarkusInfo";
    public static final String QUARKUS_UPDATE_TASK_NAME = "quarkusUpdate";
    public static final String IMAGE_BUILD_TASK_NAME = "imageBuild";
    public static final String IMAGE_PUSH_TASK_NAME = "imagePush";
    public static final String DEPLOY_TASK_NAME = "deploy";
    @Deprecated
    public static final String BUILD_NATIVE_TASK_NAME = "buildNative";
    @Deprecated
    public static final String TEST_NATIVE_TASK_NAME = "testNative";
    @Deprecated
    public static final String QUARKUS_TEST_CONFIG_TASK_NAME = "quarkusTestConfig";
    public static final String NATIVE_TEST_SOURCE_SET_NAME = "native-test";
    public static final String NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "nativeTestImplementation";
    public static final String NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "nativeTestRuntimeOnly";
    public static final String INTEGRATION_TEST_TASK_NAME = "quarkusIntTest";
    public static final String INTEGRATION_TEST_SOURCE_SET_NAME = "integrationTest";
    public static final String INTEGRATION_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "integrationTestImplementation";
    public static final String INTEGRATION_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "integrationTestRuntimeOnly";
    private final ToolingModelBuilderRegistry registry;

    @Inject
    public QuarkusPlugin(ToolingModelBuilderRegistry registry) {
        this.registry = registry;
    }

    public void apply(Project project) {
        this.verifyGradleVersion();
        project.getPluginManager().apply(JavaPlugin.class);
        this.registerModel();
        QuarkusPluginExtension quarkusExt = (QuarkusPluginExtension)project.getExtensions().create(EXTENSION_NAME, QuarkusPluginExtension.class, new Object[]{project});
        this.createSourceSets(project);
        this.createConfigurations(project);
        this.registerTasks(project, quarkusExt);
    }

    private void registerTasks(Project project, final QuarkusPluginExtension quarkusExt) {
        TaskContainer tasks = project.getTasks();
        String devRuntimeConfigName = ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT);
        Configuration devRuntimeDependencies = (Configuration)project.getConfigurations().maybeCreate(devRuntimeConfigName);
        tasks.register(LIST_EXTENSIONS_TASK_NAME, QuarkusListExtensions.class);
        tasks.register(LIST_CATEGORIES_TASK_NAME, QuarkusListCategories.class);
        tasks.register(LIST_PLATFORMS_TASK_NAME, QuarkusListPlatforms.class);
        tasks.register(ADD_EXTENSION_TASK_NAME, QuarkusAddExtension.class);
        tasks.register(REMOVE_EXTENSION_TASK_NAME, QuarkusRemoveExtension.class);
        tasks.register(QUARKUS_INFO_TASK_NAME, QuarkusInfo.class);
        tasks.register(QUARKUS_UPDATE_TASK_NAME, QuarkusUpdate.class);
        tasks.register(QUARKUS_GO_OFFLINE_TASK_NAME, QuarkusGoOffline.class, task -> {
            task.setCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.NORMAL)));
            task.setTestCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.TEST)));
            task.setQuarkusDevClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT)));
        });
        TaskProvider quarkusGenerateCode = tasks.register(QUARKUS_GENERATE_CODE_TASK_NAME, QuarkusGenerateCode.class, new Object[]{LaunchMode.NORMAL, "main"});
        quarkusGenerateCode.configure(task -> QuarkusPlugin.configureGenerateCodeTask(task, "quarkus-generated-sources"));
        TaskProvider quarkusGenerateCodeDev = tasks.register(QUARKUS_GENERATE_CODE_DEV_TASK_NAME, QuarkusGenerateCode.class, new Object[]{LaunchMode.DEVELOPMENT, "main"});
        quarkusGenerateCodeDev.configure(task -> {
            task.dependsOn(new Object[]{quarkusGenerateCode});
            QuarkusPlugin.configureGenerateCodeTask(task, "quarkus-generated-sources");
        });
        TaskProvider quarkusGenerateCodeTests = tasks.register(QUARKUS_GENERATE_CODE_TESTS_TASK_NAME, QuarkusGenerateCode.class, new Object[]{LaunchMode.TEST, "test"});
        quarkusGenerateCodeTests.configure(task -> {
            task.dependsOn(new Object[]{"compileQuarkusTestGeneratedSourcesJava"});
            QuarkusPlugin.configureGenerateCodeTask(task, "quarkus-test-generated-sources");
        });
        tasks.register(QUARKUS_SHOW_EFFECTIVE_CONFIG_TASK_NAME, QuarkusShowEffectiveConfig.class, task -> task.setDescription("Show effective Quarkus build configuration."));
        TaskProvider quarkusBuildDependencies = tasks.register(QUARKUS_BUILD_DEP_TASK_NAME, QuarkusBuildDependencies.class, task -> task.getOutputs().doNotCacheIf("Dependencies are never cached", t -> true));
        final Property<Boolean> cacheLargeArtifacts = quarkusExt.getCacheLargeArtifacts();
        TaskProvider quarkusBuildCacheableAppParts = tasks.register(QUARKUS_BUILD_APP_PARTS_TASK_NAME, QuarkusBuildCacheableAppParts.class, task -> {
            task.dependsOn(new Object[]{quarkusGenerateCode});
            task.getOutputs().doNotCacheIf("Not adding uber-jars, native binaries and mutable-jar package type to Gradle build cache by default. To allow caching of uber-jars, native binaries and mutable-jar package type, set 'cacheUberAndNativeRunners' in the 'quarkus' Gradle extension to 'true'.", (Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task t) {
                    QuarkusBuildCacheableAppParts q = (QuarkusBuildCacheableAppParts)t;
                    return !q.isCachedByDefault() && (Boolean)cacheLargeArtifacts.get() == false;
                }
            });
        });
        TaskProvider quarkusBuild = tasks.register(QUARKUS_BUILD_TASK_NAME, QuarkusBuild.class, build -> {
            build.dependsOn(new Object[]{quarkusBuildDependencies, quarkusBuildCacheableAppParts});
            build.getOutputs().doNotCacheIf("Only collects and combines the outputs of quarkusAppPartsBuild and quarkusDependenciesBuild, see 'cacheLargeArtifacts' in the 'quarkus' Gradle extension for details.", (Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task t) {
                    return (Boolean)cacheLargeArtifacts.get() == false;
                }
            });
        });
        tasks.register(IMAGE_BUILD_TASK_NAME, ImageBuild.class, task -> task.finalizedBy(new Object[]{quarkusBuild}));
        tasks.register(IMAGE_PUSH_TASK_NAME, ImagePush.class, task -> task.finalizedBy(new Object[]{quarkusBuild}));
        tasks.register(DEPLOY_TASK_NAME, Deploy.class, task -> task.finalizedBy(new Object[]{quarkusBuild}));
        TaskProvider quarkusDev = tasks.register(QUARKUS_DEV_TASK_NAME, QuarkusDev.class, new Object[]{devRuntimeDependencies, quarkusExt});
        TaskProvider quarkusRun = tasks.register(QUARKUS_RUN_TASK_NAME, QuarkusRun.class, build -> build.dependsOn(new Object[]{quarkusBuild}));
        TaskProvider quarkusRemoteDev = tasks.register(QUARKUS_REMOTE_DEV_TASK_NAME, QuarkusRemoteDev.class, new Object[]{devRuntimeDependencies, quarkusExt});
        TaskProvider quarkusTest = tasks.register(QUARKUS_TEST_TASK_NAME, QuarkusTest.class, new Object[]{devRuntimeDependencies, quarkusExt});
        tasks.register(QUARKUS_TEST_CONFIG_TASK_NAME, QuarkusTestConfig.class);
        tasks.register(BUILD_NATIVE_TASK_NAME, DefaultTask.class, task -> {
            task.finalizedBy(new Object[]{quarkusBuild});
            task.doFirst(t -> t.getLogger().warn("The 'buildNative' task has been deprecated in favor of 'build -Dquarkus.package.type=native'"));
        });
        this.configureBuildNativeTask(project);
        project.getPlugins().withType(BasePlugin.class, basePlugin -> tasks.named("assemble", task -> task.dependsOn(new Object[]{quarkusBuild})));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            project.afterEvaluate(this::afterEvaluate);
            tasks.named("compileJava", JavaCompile.class, compileJava -> {
                compileJava.mustRunAfter(new Object[]{quarkusGenerateCode});
                compileJava.mustRunAfter(new Object[]{quarkusGenerateCodeDev});
            });
            tasks.named("compileTestJava", JavaCompile.class, compileTestJava -> {
                compileTestJava.dependsOn(new Object[]{quarkusGenerateCode});
                compileTestJava.dependsOn(new Object[]{quarkusGenerateCodeTests});
                if (project.getGradle().getStartParameter().getTaskNames().contains(QUARKUS_DEV_TASK_NAME)) {
                    compileTestJava.getOptions().setFailOnError(false);
                }
            });
            TaskProvider classesTask = tasks.named("classes");
            TaskProvider resourcesTask = tasks.named("processResources");
            TaskProvider testClassesTask = tasks.named("testClasses");
            TaskProvider testResourcesTask = tasks.named("processTestResources");
            quarkusGenerateCode.configure(task -> {
                Configuration config = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.NORMAL));
                task.dependsOn(new Object[]{resourcesTask, config});
                task.setCompileClasspath(config);
            });
            quarkusGenerateCodeDev.configure(task -> {
                Configuration config = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT));
                task.dependsOn(new Object[]{resourcesTask, config});
                task.setCompileClasspath(config);
            });
            quarkusGenerateCodeTests.configure(task -> {
                Configuration config = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.TEST));
                task.dependsOn(new Object[]{resourcesTask, config});
                task.setCompileClasspath(config);
            });
            quarkusDev.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask, testClassesTask, testResourcesTask, quarkusGenerateCodeDev, quarkusGenerateCodeTests}));
            quarkusRemoteDev.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask}));
            quarkusTest.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask, testClassesTask, testResourcesTask, quarkusGenerateCode, quarkusGenerateCodeTests}));
            quarkusBuildCacheableAppParts.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask, tasks.named("jar")}));
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
            mainSourceSet.getJava().srcDirs(new Object[]{quarkusGenerateCode, quarkusGenerateCodeDev});
            testSourceSet.getJava().srcDirs(new Object[]{quarkusGenerateCodeTests});
            quarkusGenerateCode.configure(task -> task.setSourcesDirectories(this.getSourcesParents(mainSourceSet)));
            quarkusGenerateCodeDev.configure(task -> task.setSourcesDirectories(this.getSourcesParents(mainSourceSet)));
            quarkusGenerateCodeTests.configure(task -> task.setSourcesDirectories(this.getSourcesParents(testSourceSet)));
            SourceSet intTestSourceSet = (SourceSet)sourceSets.getByName(INTEGRATION_TEST_SOURCE_SET_NAME);
            intTestSourceSet.setCompileClasspath(intTestSourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            intTestSourceSet.setRuntimeClasspath(intTestSourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            TaskProvider testTask = tasks.named("test", Test.class);
            FileCollection intTestSourceOutputClasses = intTestSourceSet.getOutput().getClassesDirs();
            FileCollection intTestClasspath = intTestSourceSet.getRuntimeClasspath();
            tasks.register(INTEGRATION_TEST_TASK_NAME, Test.class, intTestTask -> {
                intTestTask.setGroup("verification");
                intTestTask.setDescription("Runs Quarkus integration tests");
                intTestTask.dependsOn(new Object[]{quarkusBuild, testTask});
                intTestTask.setClasspath(intTestClasspath);
                intTestTask.setTestClassesDirs(intTestSourceOutputClasses);
            });
            SourceSet nativeTestSourceSet = (SourceSet)sourceSets.getByName(NATIVE_TEST_SOURCE_SET_NAME);
            nativeTestSourceSet.setCompileClasspath(nativeTestSourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)intTestSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            nativeTestSourceSet.setRuntimeClasspath(nativeTestSourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)intTestSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            ConfigurableFileCollection nativeTestClassesDirs = project.files(new Object[]{nativeTestSourceSet.getOutput().getClassesDirs(), intTestSourceOutputClasses});
            FileCollection nativeTestClasspath = nativeTestSourceSet.getRuntimeClasspath();
            tasks.register(TEST_NATIVE_TASK_NAME, Test.class, arg_0 -> QuarkusPlugin.lambda$registerTasks$30(quarkusBuild, testTask, nativeTestClasspath, (FileCollection)nativeTestClassesDirs, arg_0));
            tasks.withType(Test.class).configureEach(t -> {
                t.notCompatibleWithConfigurationCache("The quarkus-plugin isn't compatible with the configuration cache");
                t.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        quarkusExt.beforeTest((Test)task);
                    }
                });
                t.useJUnitPlatform();
            });
            quarkusBuildCacheableAppParts.configure(task -> task.shouldRunAfter(new Object[]{tasks.withType(Test.class)}));
            SourceSet generatedSourceSet = (SourceSet)sourceSets.getByName("quarkus-generated-sources");
            SourceSet generatedTestSourceSet = (SourceSet)sourceSets.getByName("quarkus-test-generated-sources");
            for (String provider : QuarkusGenerateCode.CODE_GENERATION_PROVIDER) {
                mainSourceSet.getJava().srcDir((Object)new File(((Directory)generatedSourceSet.getJava().getClassesDirectory().get()).getAsFile(), provider));
                testSourceSet.getJava().srcDir((Object)new File(((Directory)generatedTestSourceSet.getJava().getClassesDirectory().get()).getAsFile(), provider));
            }
        });
        project.getPlugins().withId("org.jetbrains.kotlin.jvm", plugin -> {
            quarkusDev.configure(task -> task.shouldPropagateJavaCompilerArgs(false));
            tasks.named("compileKotlin", task -> {
                task.mustRunAfter(new Object[]{quarkusGenerateCode});
                task.mustRunAfter(new Object[]{quarkusGenerateCodeDev});
            });
            tasks.named("compileTestKotlin", task -> task.dependsOn(new Object[]{quarkusGenerateCodeTests}));
        });
    }

    private static void configureGenerateCodeTask(QuarkusGenerateCode task, String generateSourcesDir) {
        SourceSet generatedSources = QuarkusGradleUtils.getSourceSet(task.getProject(), generateSourcesDir);
        Set sourceSetOutput = generatedSources.getOutput().filter(f -> f.getName().equals(generateSourcesDir)).getFiles();
        if (sourceSetOutput.isEmpty()) {
            throw new GradleException("Failed to configure " + task.getPath() + ": sourceSet " + generateSourcesDir + " has no output");
        }
        task.getGeneratedOutputDirectory().set(((Directory)generatedSources.getJava().getClassesDirectory().get()).getAsFile());
    }

    private void createSourceSets(Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        sourceSets.create(INTEGRATION_TEST_SOURCE_SET_NAME);
        sourceSets.create(NATIVE_TEST_SOURCE_SET_NAME);
        sourceSets.create("quarkus-generated-sources");
        sourceSets.create("quarkus-test-generated-sources");
    }

    private void createConfigurations(Project project) {
        ConfigurationContainer configContainer = project.getConfigurations();
        configContainer.getByName(NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testImplementation")});
        configContainer.getByName(NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testRuntimeOnly")});
        ((Configuration)configContainer.maybeCreate(INTEGRATION_TEST_IMPLEMENTATION_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testImplementation")});
        ((Configuration)configContainer.maybeCreate(INTEGRATION_TEST_RUNTIME_ONLY_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testRuntimeOnly")});
        ApplicationDeploymentClasspathBuilder.initConfigurations((Project)project);
        for (LaunchMode launchMode : LaunchMode.values()) {
            new ApplicationDeploymentClasspathBuilder(project, launchMode);
        }
    }

    private Set<Path> getSourcesParents(SourceSet mainSourceSet) {
        Set srcDirs = mainSourceSet.getJava().getSrcDirs();
        return srcDirs.stream().map(File::toPath).map(Path::getParent).collect(Collectors.toSet());
    }

    private void registerModel() {
        this.registry.register((ToolingModelBuilder)new GradleApplicationModelBuilder());
    }

    private void verifyGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) < 0) {
            throw new GradleException("Quarkus plugin requires Gradle 6.1 or later. Current version is: " + GradleVersion.current());
        }
    }

    private void configureBuildNativeTask(Project project) {
        project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(project.getPath() + BUILD_NATIVE_TASK_NAME) || taskGraph.hasTask(project.getPath() + TEST_NATIVE_TASK_NAME)) {
                project.getLogger().warn("The Quarkus tasks {} and {} are deprecated and subject to removal. Please migrate your build to use 'test -Dquarkus.package.type=native' and 'quarkusBuild -Dquarkus.package.type=native'.", (Object)TEST_NATIVE_TASK_NAME, (Object)BUILD_NATIVE_TASK_NAME);
                project.getExtensions().getExtraProperties().set(QUARKUS_PACKAGE_TYPE, (Object)"native");
            }
        });
    }

    private void afterEvaluate(Project project) {
        this.visitProjectDependencies(project, project, new HashSet<String>());
        ConfigurationContainer configurations = project.getConfigurations();
        SourceSetExtension sourceSetExtension = ((QuarkusPluginExtension)project.getExtensions().getByType(QuarkusPluginExtension.class)).sourceSetExtension();
        if (sourceSetExtension.extraNativeTest() != null) {
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet nativeTestSourceSets = (SourceSet)sourceSets.getByName(NATIVE_TEST_SOURCE_SET_NAME);
            nativeTestSourceSets.setCompileClasspath(nativeTestSourceSets.getCompileClasspath().plus((FileCollection)((SourceSet)sourceSets.getByName(INTEGRATION_TEST_SOURCE_SET_NAME)).getOutput()).plus((FileCollection)sourceSetExtension.extraNativeTest().getOutput()));
            nativeTestSourceSets.setRuntimeClasspath(nativeTestSourceSets.getRuntimeClasspath().plus((FileCollection)((SourceSet)sourceSets.getByName(INTEGRATION_TEST_SOURCE_SET_NAME)).getOutput()).plus((FileCollection)sourceSetExtension.extraNativeTest().getOutput()));
            configurations.getByName(NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME).extendsFrom(new Configuration[]{(Configuration)configurations.findByName(sourceSetExtension.extraNativeTest().getImplementationConfigurationName())});
            configurations.getByName(NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME).extendsFrom(new Configuration[]{(Configuration)configurations.findByName(sourceSetExtension.extraNativeTest().getRuntimeOnlyConfigurationName())});
        }
    }

    private void visitProjectDep(Project project, Project dep, Set<String> visited) {
        if (dep.getState().getExecuted()) {
            this.setupQuarkusBuildTaskDeps(project, dep, visited);
        } else {
            dep.afterEvaluate(p -> this.setupQuarkusBuildTaskDeps(project, (Project)p, visited));
        }
    }

    private void setupQuarkusBuildTaskDeps(Project project, Project dep, Set<String> visited) {
        if (!visited.add(dep.getGroup() + ":" + dep.getName())) {
            return;
        }
        project.getLogger().debug("Configuring {} task dependencies on {} tasks", (Object)project, (Object)dep);
        this.getLazyTask(project, QUARKUS_BUILD_TASK_NAME).flatMap(quarkusBuild -> this.getLazyTask(dep, "jar")).ifPresent(jarTask -> {
            for (String taskName : new String[]{QUARKUS_GENERATE_CODE_TASK_NAME, QUARKUS_GENERATE_CODE_DEV_TASK_NAME, QUARKUS_GENERATE_CODE_TESTS_TASK_NAME}) {
                this.getLazyTask(project, taskName).ifPresent(quarkusTask -> quarkusTask.configure(t -> t.dependsOn(new Object[]{jarTask})));
            }
        });
        this.getLazyTask(project, QUARKUS_DEV_TASK_NAME).ifPresent(quarkusDev -> {
            for (String taskName : new String[]{"processResources", "jandex", "processJandexIndex"}) {
                this.getLazyTask(dep, taskName).ifPresent(t -> quarkusDev.configure(qd -> qd.dependsOn(new Object[]{t})));
            }
        });
        this.visitProjectDependencies(project, dep, visited);
    }

    protected void visitProjectDependencies(Project project, Project dep, Set<String> visited) {
        Configuration compileConfig = (Configuration)dep.getConfigurations().findByName("compileClasspath");
        if (compileConfig != null) {
            Configuration compilePlusRuntimeConfig = dep.getConfigurations().detachedConfiguration(new Dependency[0]).extendsFrom(new Configuration[]{compileConfig});
            Configuration runtimeOnlyConfig = (Configuration)dep.getConfigurations().findByName("runtimeOnly");
            if (runtimeOnlyConfig != null) {
                compilePlusRuntimeConfig.extendsFrom(new Configuration[]{runtimeOnlyConfig});
            }
            compilePlusRuntimeConfig.getIncoming().getDependencies().forEach(d -> {
                Project depProject = null;
                if (d instanceof ProjectDependency) {
                    depProject = ((ProjectDependency)d).getDependencyProject();
                } else if (d instanceof ExternalModuleDependency) {
                    depProject = ToolingUtils.findIncludedProject((Project)project, (ExternalModuleDependency)((ExternalModuleDependency)d));
                }
                if (depProject == null) {
                    return;
                }
                if (depProject.getState().getExecuted()) {
                    this.visitLocalProject(project, depProject, visited);
                } else {
                    depProject.afterEvaluate(p -> this.visitLocalProject(project, (Project)p, visited));
                }
            });
        }
    }

    private void visitLocalProject(Project project, Project localProject, Set<String> visited) {
        this.visitProjectDep(project, localProject, visited);
        ExtensionDependency extensionDependency = DependencyUtils.getExtensionInfoOrNull((Project)project, (Project)localProject);
        if (extensionDependency instanceof ProjectExtensionDependency) {
            this.visitProjectDep(project, (Project)((ProjectExtensionDependency)extensionDependency).getDeploymentModule(), visited);
        }
    }

    private Optional<TaskProvider<Task>> getLazyTask(Project project, String name) {
        try {
            return Optional.of(project.getTasks().named(name));
        }
        catch (UnknownTaskException e) {
            return Optional.empty();
        }
    }

    private static /* synthetic */ void lambda$registerTasks$30(TaskProvider quarkusBuild, TaskProvider testTask, FileCollection nativeTestClasspath, FileCollection nativeTestClassesDirs, Test testNative) {
        testNative.setDescription("Runs native image tests");
        testNative.setGroup("verification");
        testNative.dependsOn(new Object[]{quarkusBuild, testTask});
        testNative.setClasspath(nativeTestClasspath);
        testNative.setTestClassesDirs(nativeTestClassesDirs);
    }
}

