/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.workspace.descriptors;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.LazySourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.gradle.workspace.descriptors.DefaultProjectDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;

public class ProjectDescriptorBuilder {
    private final WorkspaceModule.Mutable moduleBuilder;

    public static Provider<DefaultProjectDescriptor> buildForApp(Project project) {
        ProjectDescriptorBuilder builder = new ProjectDescriptorBuilder(project);
        project.afterEvaluate(evaluated -> {
            SourceSetContainer srcSets = (SourceSetContainer)evaluated.getExtensions().getByType(SourceSetContainer.class);
            evaluated.getTasks().withType(Jar.class).configureEach(jarTask -> {
                String classifier = (String)jarTask.getArchiveClassifier().get();
                ArrayList<File> classesDirs = new ArrayList<File>(2);
                ArrayList<File> resourcesOutputDirs = new ArrayList<File>(2);
                ProjectDescriptorBuilder.collectSourceSetOutput((DefaultCopySpec)jarTask.getRootSpec(), classesDirs, resourcesOutputDirs);
                ArrayList<LazySourceDir> sourceDirs = new ArrayList<LazySourceDir>(2);
                ArrayList<LazySourceDir> resourceDirs = new ArrayList<LazySourceDir>(2);
                for (SourceSet srcSet : srcSets) {
                    for (File classesDir : srcSet.getOutput().getClassesDirs().getFiles()) {
                        if (!classesDirs.contains(classesDir)) continue;
                        for (File srcDir : srcSet.getAllJava().getSrcDirs()) {
                            sourceDirs.add(new LazySourceDir(srcDir.toPath(), classesDir.toPath()));
                        }
                    }
                    File resourcesOutputDir = srcSet.getOutput().getResourcesDir();
                    if (!resourcesOutputDirs.contains(resourcesOutputDir)) continue;
                    for (File dir : srcSet.getResources().getSrcDirs()) {
                        resourceDirs.add(new LazySourceDir(dir.toPath(), resourcesOutputDir.toPath()));
                    }
                }
                if (!sourceDirs.isEmpty() || !resourceDirs.isEmpty()) {
                    builder.moduleBuilder.addArtifactSources((ArtifactSources)new DefaultArtifactSources(classifier, sourceDirs, resourceDirs));
                }
            });
        });
        return project.getProviders().provider(() -> new DefaultProjectDescriptor(builder.moduleBuilder));
    }

    private static void collectSourceSetOutput(DefaultCopySpec spec, List<File> classesDir, List<File> resourcesDir) {
        for (Object paths : spec.getSourcePaths()) {
            if (!(paths instanceof SourceSetOutput)) continue;
            SourceSetOutput sso = (SourceSetOutput)paths;
            classesDir.addAll(sso.getClassesDirs().getFiles());
            resourcesDir.add(sso.getResourcesDir());
        }
        for (CopySpecInternal child : spec.getChildren()) {
            ProjectDescriptorBuilder.collectSourceSetOutput((DefaultCopySpec)child, classesDir, resourcesDir);
        }
    }

    private ProjectDescriptorBuilder(Project project) {
        this.moduleBuilder = WorkspaceModule.builder().setModuleId(WorkspaceModuleId.of((String)String.valueOf(project.getGroup()), (String)project.getName(), (String)String.valueOf(project.getVersion()))).setModuleDir(project.getLayout().getProjectDirectory().getAsFile().toPath()).setBuildDir(((Directory)project.getLayout().getBuildDirectory().get()).getAsFile().toPath()).setBuildFile(project.getBuildFile().toPath());
    }
}

