/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import com.google.common.annotations.VisibleForTesting;
import io.quarkus.deployment.configuration.ConfigCompatibility;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.Expressions;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.source.yaml.YamlConfigSourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public final class EffectiveConfig {
    private final SmallRyeConfig config;
    private final Map<String, String> values;

    private EffectiveConfig(Builder builder) {
        PropertiesConfigSource platformPropertiesConfigSource = builder.platformProperties.isEmpty() ? new PropertiesConfigSource(Map.of("platform.quarkus.native.builder-image", "<<ignored>>"), "platformProperties", 0) : new PropertiesConfigSource(builder.platformProperties, "platformProperties", 0);
        this.config = ConfigUtils.emptyConfigBuilder().forClassLoader(EffectiveConfig.toUrlClassloader(builder.sourceDirectories)).withSources(new ConfigSource[]{new PropertiesConfigSource(builder.forcedProperties, "forcedProperties", 600)}).withSources(new ConfigSource[]{new PropertiesConfigSource(this.asStringMap(builder.taskProperties), "taskProperties", 500)}).addSystemSources().withSources(new ConfigSource[]{new PropertiesConfigSource(builder.buildProperties, "quarkusBuildProperties", 290)}).withSources(new ConfigSource[]{new PropertiesConfigSource(this.asStringMap(builder.projectProperties), "projectProperties", 280)}).withSources((ConfigSourceProvider)new YamlConfigSourceLoader.InFileSystem()).withSources((ConfigSourceProvider)new YamlConfigSourceLoader.InClassPath()).addPropertiesSources().withSources(new ConfigSource[]{platformPropertiesConfigSource}).withDefaultValues(builder.defaultProperties).withProfile(builder.profile).withMapping(PackageConfig.class).withMapping(NativeConfig.class).withInterceptors(new ConfigSourceInterceptor[]{ConfigCompatibility.FrontEnd.instance(), ConfigCompatibility.BackEnd.instance()}).build();
        this.values = EffectiveConfig.generateFullConfigMap(this.config);
    }

    public SmallRyeConfig getConfig() {
        return this.config;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    private Map<String, String> asStringMap(Map<String, ?> map) {
        HashMap<String, String> target = new HashMap<String, String>();
        map.forEach((k, v) -> {
            if (v != null) {
                target.put((String)k, v.toString());
            }
        });
        return target;
    }

    @VisibleForTesting
    static Map<String, String> generateFullConfigMap(final SmallRyeConfig config) {
        return (Map)Expressions.withoutExpansion((Supplier)new Supplier<Map<String, String>>(){

            @Override
            public Map<String, String> get() {
                HashMap<String, String> properties = new HashMap<String, String>();
                for (String propertyName : config.getPropertyNames()) {
                    String value = config.getRawValue(propertyName);
                    if (value == null) continue;
                    properties.put(propertyName, value);
                }
                return Collections.unmodifiableMap(properties);
            }
        });
    }

    static Builder builder() {
        return new Builder();
    }

    private static ClassLoader toUrlClassloader(Set<File> sourceDirectories) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File sourceDirectory : sourceDirectories) {
            try {
                urls.add(sourceDirectory.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader()){

            @Override
            public URL getResource(String name) {
                if (name.startsWith("META-INF/services/")) {
                    return null;
                }
                return super.getResource(name);
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                if (name.startsWith("META-INF/services/")) {
                    return Collections.emptyEnumeration();
                }
                return super.getResources(name);
            }
        };
    }

    static final class Builder {
        private Map<String, String> platformProperties = Collections.emptyMap();
        private Map<String, String> forcedProperties = Collections.emptyMap();
        private Map<String, ?> taskProperties = Collections.emptyMap();
        private Map<String, String> buildProperties = Collections.emptyMap();
        private Map<String, ?> projectProperties = Collections.emptyMap();
        private Map<String, String> defaultProperties = Collections.emptyMap();
        private Set<File> sourceDirectories = Collections.emptySet();
        private String profile = "prod";

        Builder() {
        }

        EffectiveConfig build() {
            return new EffectiveConfig(this);
        }

        Builder withPlatformProperties(Map<String, String> platformProperties) {
            this.platformProperties = platformProperties;
            return this;
        }

        Builder withForcedProperties(Map<String, String> forcedProperties) {
            this.forcedProperties = forcedProperties;
            return this;
        }

        Builder withTaskProperties(Map<String, ?> taskProperties) {
            this.taskProperties = taskProperties;
            return this;
        }

        Builder withBuildProperties(Map<String, String> buildProperties) {
            this.buildProperties = buildProperties;
            return this;
        }

        Builder withProjectProperties(Map<String, ?> projectProperties) {
            this.projectProperties = projectProperties;
            return this;
        }

        Builder withDefaultProperties(Map<String, String> defaultProperties) {
            this.defaultProperties = defaultProperties;
            return this;
        }

        Builder withSourceDirectories(Set<File> sourceDirectories) {
            this.sourceDirectories = sourceDirectories;
            return this;
        }

        Builder withProfile(String profile) {
            this.profile = profile;
            return this;
        }
    }
}

