/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.ListExtensions;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.gradle.tasks.GradleMessageWriter;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class QuarkusListExtensions
extends QuarkusPlatformTask {
    private static final String DEFAULT_FORMAT = "concise";
    private boolean all = true;
    private boolean installed = false;
    private boolean fromCli = false;
    private String format = "concise";
    private String searchPattern;
    private String category;

    @Input
    public boolean isAll() {
        return this.all;
    }

    @Option(description="List all extensions or just the installable.", option="all")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Input
    public boolean isFromCli() {
        return this.fromCli;
    }

    @Option(description="Indicates that a task is run from the Quarkus CLI.", option="fromCli")
    public void setFromCli(boolean fromCli) {
        this.fromCli = fromCli;
    }

    @Input
    public boolean isInstalled() {
        return this.installed;
    }

    @Option(description="List only installed extensions.", option="installed")
    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    @Optional
    @Input
    public String getFormat() {
        return this.format;
    }

    @Option(description="Select the output format among 'id' (display the artifactId only), 'concise' (display name and artifactId) and 'full' (concise format and version related columns).", option="format")
    public void setFormat(String format) {
        this.format = format;
    }

    @Optional
    @Input
    public String getSearchPattern() {
        return this.searchPattern;
    }

    @Option(description="Search filter on extension list. The format is based on Java Pattern.", option="searchPattern")
    public void setSearchPattern(String searchPattern) {
        this.searchPattern = searchPattern;
    }

    @Optional
    @Input
    public String getCategory() {
        return this.category;
    }

    @Option(description="Only list extensions from given category.", option="category")
    public void setCategory(String category) {
        this.category = category;
    }

    public QuarkusListExtensions() {
        super("Lists the available quarkus extensions");
    }

    @TaskAction
    public void listExtensions() {
        try {
            QuarkusProject quarkusProject = this.getQuarkusProject(this.installed);
            ListExtensions listExtensions = new ListExtensions(quarkusProject).all(this.isFromCli() ? false : this.isAll()).fromCli(this.isFromCli()).format(this.getFormat()).installed(this.isInstalled()).search(this.getSearchPattern()).category(this.getCategory());
            listExtensions.execute();
            if (!this.fromCli) {
                GradleMessageWriter log = this.messageWriter();
                if (DEFAULT_FORMAT.equalsIgnoreCase(this.format)) {
                    log.info("");
                    log.info("To get more information, append `%s` to your command line.", new Object[]{"--format=full"});
                }
                if (!this.installed && (this.category == null || this.category.isBlank())) {
                    log.info("");
                    log.info("To list only extensions from specific category, append `%s` to your command line.", new Object[]{"--category=\"categoryId\""});
                }
                log.info("");
                log.info("Add an extension to your project by adding the dependency to your %s or use `%s`", new Object[]{"build.gradle", "./gradlew addExtension --extensions=\"artifactId\""});
            }
        }
        catch (Exception e) {
            throw new GradleException("Unable to list extensions", (Throwable)e);
        }
    }
}

