/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.AddExtensions;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class QuarkusAddExtension
extends QuarkusPlatformTask {
    private List<String> extensionsToAdd;

    public QuarkusAddExtension() {
        super("Adds Quarkus extensions specified by the user to the project.");
    }

    @Option(option="extensions", description="Configures the extensions to be added.")
    public void setExtensionsToAdd(List<String> extensionsToAdd) {
        this.extensionsToAdd = extensionsToAdd;
    }

    @Input
    public List<String> getExtensionsToAdd() {
        return this.extensionsToAdd;
    }

    @TaskAction
    public void addExtension() {
        Set extensionsSet = this.getExtensionsToAdd().stream().flatMap(ext -> Arrays.stream(ext.split(","))).map(String::trim).collect(Collectors.toSet());
        try {
            AddExtensions addExtensions = new AddExtensions(this.getQuarkusProject(false)).extensions(extensionsSet);
            addExtensions.execute();
        }
        catch (Exception e) {
            throw new GradleException("Failed to add extensions " + String.valueOf(this.getExtensionsToAdd()), (Throwable)e);
        }
    }
}

