/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class QuarkusBuildCacheableAppParts
extends QuarkusBuildTask {
    static final String QUARKUS_ARTIFACT_PROPERTIES = "quarkus-artifact.properties";

    @Inject
    public QuarkusBuildCacheableAppParts() {
        super("Quarkus application build with the ability to cache the built artifacts, excluding dependencies. Do not use this task directly, use 'quarkusBuild'", true);
    }

    @Internal
    public boolean isCachedByDefault() {
        if (this.nativeEnabled()) {
            return false;
        }
        return switch (this.jarType()) {
            case PackageConfig.JarConfig.JarType.FAST_JAR, PackageConfig.JarConfig.JarType.LEGACY_JAR -> true;
            default -> false;
        };
    }

    @OutputDirectories
    public Map<String, File> getOutputDirectories() {
        HashMap<String, File> outputs = new HashMap<String, File>();
        if (this.nativeEnabled()) {
            if (!this.nativeSourcesOnly()) {
                outputs.put("app-build-dir", this.appBuildDir().toFile());
            }
        } else {
            switch (this.jarType()) {
                case FAST_JAR: 
                case LEGACY_JAR: {
                    outputs.put("app-build-dir", this.appBuildDir().toFile());
                    break;
                }
            }
        }
        return outputs;
    }

    @TaskAction
    public void performQuarkusBuild() {
        Path appDir = this.appBuildDir();
        this.getFileSystemOperations().delete(delete -> delete.delete(new Object[]{appDir}));
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Falling back to 'full quarkus application build' for native sources, this task's output is empty for this package type");
            } else {
                this.fastJarBuild();
            }
        } else {
            switch (this.jarType()) {
                case FAST_JAR: {
                    this.fastJarBuild();
                    break;
                }
                case LEGACY_JAR: {
                    this.legacyJarBuild();
                    break;
                }
                case MUTABLE_JAR: 
                case UBER_JAR: {
                    this.getLogger().info("Falling back to 'full quarkus application build' for JAR type {}, this task's output is empty for this package type", (Object)this.jarType());
                }
            }
        }
    }

    private void legacyJarBuild() {
        this.generateBuild();
        Path genDir = this.genBuildDir();
        Path appDir = this.appBuildDir();
        this.getLogger().info("Synchronizing Quarkus legacy-jar app for JAR type {} into {}", (Object)this.jarType(), (Object)appDir);
        this.getFileSystemOperations().sync(sync -> {
            sync.into((Object)appDir);
            sync.from(new Object[]{genDir});
            sync.include(new String[]{"**", QUARKUS_ARTIFACT_PROPERTIES});
            sync.exclude(new String[]{"lib/**"});
        });
        this.getFileSystemOperations().copy(copy -> {
            copy.into((Object)appDir);
            copy.from(new Object[]{genDir});
            copy.include(new String[]{"lib/modified-*"});
        });
    }

    private void fastJarBuild() {
        this.generateBuild();
        String outputDirectory = this.outputDirectory();
        Path genDir = this.genBuildDir();
        Path appDir = this.appBuildDir();
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Synchronizing Quarkus fast-jar-like app for native sources into {}", (Object)appDir);
            } else {
                this.getLogger().info("Synchronizing Quarkus fast-jar-like app for native into {}", (Object)appDir);
            }
        } else {
            this.getLogger().info("Synchronizing Quarkus fast-jar-like app for JAR type {} into {}", (Object)this.jarType(), (Object)appDir);
        }
        this.getFileSystemOperations().sync(sync -> {
            sync.into((Object)appDir);
            sync.from(new Object[]{genDir});
            sync.exclude(new String[]{outputDirectory + "/lib/**"});
        });
    }
}

