/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.tasks.QuarkusBuild;
import io.quarkus.gradle.tasks.QuarkusPluginExtensionView;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.gradle.tasks.services.ForcedPropertieBuildService;
import io.quarkus.gradle.tasks.worker.BuildWorker;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.smallrye.config.Expressions;
import io.smallrye.config.SmallRyeConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.util.GradleVersion;
import org.gradle.workers.WorkQueue;

public abstract class QuarkusBuildTask
extends QuarkusTask {
    private static final String QUARKUS_BUILD_DIR = "quarkus-build";
    private static final String QUARKUS_BUILD_GEN_DIR = "quarkus-build/gen";
    private static final String QUARKUS_BUILD_APP_DIR = "quarkus-build/app";
    private static final String QUARKUS_BUILD_DEP_DIR = "quarkus-build/dep";
    static final String QUARKUS_ARTIFACT_PROPERTIES = "quarkus-artifact.properties";
    static final String NATIVE_SOURCES = "native-sources";
    private final QuarkusPluginExtensionView extensionView;
    private FileCollection classpath = this.getProject().getObjects().fileCollection();

    @Internal
    public abstract Property<ForcedPropertieBuildService> getAdditionalForcedProperties();

    QuarkusBuildTask(String description, boolean compatible) {
        super(description, compatible);
        this.extensionView = (QuarkusPluginExtensionView)this.getProject().getObjects().newInstance(QuarkusPluginExtensionView.class, new Object[]{this.extension()});
    }

    @Nested
    protected QuarkusPluginExtensionView getExtensionView() {
        return this.extensionView;
    }

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setCompileClasspath(FileCollection compileClasspath) {
        this.classpath = compileClasspath;
    }

    @Input
    public Map<String, String> getCachingRelevantInput() {
        return (Map)this.getExtensionView().getCachingRelevantInput().get();
    }

    PackageConfig.JarConfig.JarType jarType() {
        return (PackageConfig.JarConfig.JarType)this.getExtensionView().getJarType().get();
    }

    boolean jarEnabled() {
        return (Boolean)this.getExtensionView().getJarEnabled().get();
    }

    boolean nativeEnabled() {
        return (Boolean)this.getExtensionView().getNativeEnabled().get();
    }

    boolean nativeSourcesOnly() {
        return (Boolean)this.getExtensionView().getNativeSourcesOnly().get();
    }

    Path gradleBuildDir() {
        return this.buildDir.toPath();
    }

    Path genBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_GEN_DIR);
    }

    Path appBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_APP_DIR);
    }

    Path depBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_DEP_DIR);
    }

    File artifactProperties() {
        return new File(this.buildDir, QUARKUS_ARTIFACT_PROPERTIES);
    }

    File nativeSources() {
        return new File(this.buildDir, NATIVE_SOURCES);
    }

    File fastJar() {
        return new File(this.buildDir, this.outputDirectory());
    }

    File runnerJar() {
        return new File(this.buildDir, this.runnerJarFileName());
    }

    File nativeRunner() {
        return new File(this.buildDir, this.nativeRunnerFileName());
    }

    String runnerJarFileName() {
        return this.runnerName() + ".jar";
    }

    String nativeRunnerFileName() {
        return this.runnerName();
    }

    String runnerName() {
        return this.runnerBaseName() + this.runnerSuffix();
    }

    String nativeImageSourceJarDirName() {
        return this.runnerBaseName() + "-native-image-source-jar";
    }

    String runnerBaseName() {
        return (String)this.getExtensionView().getRunnerName().get();
    }

    String outputDirectory() {
        return ((Path)this.getExtensionView().getOutputDirectory().get()).toString();
    }

    private String runnerSuffix() {
        return (String)this.getExtensionView().getRunnerSuffix().get();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getApplicationModel();

    ApplicationModel resolveAppModelForBuild() {
        try {
            return ToolingUtils.deserializeAppModel((Path)((RegularFile)this.getApplicationModel().get()).getAsFile().toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void generateBuild() {
        Path buildDir = this.gradleBuildDir();
        Path genDir = this.genBuildDir();
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Building Quarkus app for native (sources only) packaging in {}", (Object)genDir);
            } else {
                this.getLogger().info("Building Quarkus app for native packaging in {}", (Object)genDir);
            }
        } else {
            this.getLogger().info("Building Quarkus app for JAR type {} in {}", (Object)this.jarType(), (Object)genDir);
        }
        QuarkusBuildTask.deleteFileIfExists(genDir.resolve(this.outputDirectory()).resolve("app-cds.jsa"));
        this.getFileSystemOperations().delete(delete -> {
            delete.delete(new Object[]{genDir});
            if (this.nativeEnabled()) {
                if (this.jarEnabled()) {
                    throw QuarkusBuild.nativeAndJar();
                }
                delete.delete(new Object[]{this.fastJar()});
            } else if (this.jarEnabled()) {
                switch (this.jarType()) {
                    case FAST_JAR: {
                        delete.delete(new Object[]{buildDir.resolve(this.nativeImageSourceJarDirName())});
                        delete.delete(new Object[]{this.fastJar()});
                        break;
                    }
                    case LEGACY_JAR: {
                        delete.delete(new Object[]{buildDir.resolve("lib")});
                        break;
                    }
                }
            }
        });
        ApplicationModel appModel = this.resolveAppModelForBuild();
        SmallRyeConfig config = this.getExtensionView().buildEffectiveConfiguration(appModel.getAppArtifact(), ((ForcedPropertieBuildService)this.getAdditionalForcedProperties().get()).getProperties()).getConfig();
        Map quarkusProperties = (Map)Expressions.withoutExpansion(() -> {
            HashMap<String, String> values = new HashMap<String, String>();
            for (String key : config.getMapKeys("quarkus").values()) {
                values.put(key, config.getConfigValue(key).getValue());
            }
            return values;
        });
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Starting Quarkus application build for native (sources only) packaging");
            } else {
                this.getLogger().info("Starting Quarkus application build for native packaging");
            }
        } else {
            this.getLogger().info("Starting Quarkus application build for JAR type {}", (Object)this.jarType());
        }
        if (this.getLogger().isEnabled(LogLevel.INFO)) {
            this.getLogger().info("Effective properties: {}", (Object)quarkusProperties.entrySet().stream().map(Object::toString).sorted().collect(Collectors.joining("\n    ", "\n    ", "")));
        }
        WorkQueue workQueue = this.workQueue(quarkusProperties, (List)this.getExtensionView().getBuildForkOptions().get());
        workQueue.submit(BuildWorker.class, params -> {
            params.getBuildSystemProperties().putAll(this.getExtensionView().buildSystemProperties(appModel.getAppArtifact(), quarkusProperties));
            params.getBaseName().set(this.getExtensionView().getFinalName());
            params.getTargetDirectory().set(buildDir.toFile());
            params.getAppModel().set((Object)appModel);
            params.getGradleVersion().set((Object)GradleVersion.current().getVersion());
        });
        workQueue.await();
        this.getFileSystemOperations().copy(copy -> {
            copy.from(new Object[]{buildDir});
            copy.into((Object)genDir);
            copy.eachFile((Action)new CopyActionDeleteNonWriteableTarget(genDir));
            if (this.nativeEnabled()) {
                if (this.jarEnabled()) {
                    throw QuarkusBuild.nativeAndJar();
                }
                if (this.nativeSourcesOnly()) {
                    copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                    copy.include(new String[]{this.nativeImageSourceJarDirName() + "/**"});
                } else {
                    copy.include(new String[]{this.nativeRunnerFileName()});
                    copy.include(new String[]{this.nativeImageSourceJarDirName() + "/**"});
                    copy.include(new String[]{this.outputDirectory() + "/**"});
                    copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                }
            } else if (this.jarEnabled()) {
                switch (this.jarType()) {
                    case FAST_JAR: {
                        copy.include(new String[]{this.outputDirectory() + "/**"});
                        copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                        break;
                    }
                    case LEGACY_JAR: {
                        copy.include(new String[]{"lib/**"});
                        copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                        copy.include(new String[]{this.runnerJarFileName()});
                        break;
                    }
                    case MUTABLE_JAR: 
                    case UBER_JAR: {
                        copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                        copy.include(new String[]{this.runnerJarFileName()});
                    }
                }
            }
        });
    }

    void abort(String message, Object ... args) {
        this.getLogger().warn(message, args);
        this.getProject().getTasks().stream().filter(t -> t != this).filter(t -> !t.getState().getExecuted()).forEach(t -> t.setEnabled(false));
        throw new StopExecutionException();
    }

    protected static void deleteFileIfExists(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class CopyActionDeleteNonWriteableTarget
    implements Action<FileCopyDetails> {
        private final Path destDir;

        public CopyActionDeleteNonWriteableTarget(Path destDir) {
            this.destDir = destDir;
        }

        public void execute(FileCopyDetails details) {
            Path destFile = this.destDir.resolve(details.getPath());
            if (Files.exists(destFile, new LinkOption[0]) && !Files.isWritable(destFile)) {
                QuarkusBuildTask.deleteFileIfExists(destFile);
            }
        }
    }
}

