/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.utilities.OS;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class QuarkusTask
extends DefaultTask {
    private static final List<String> WORKER_BUILD_FORK_OPTIONS = List.of("quarkus.");
    private final transient QuarkusPluginExtension extension;
    protected final File projectDir;
    protected final File buildDir;

    QuarkusTask(String description) {
        this.setDescription(description);
        this.setGroup("quarkus");
        this.extension = (QuarkusPluginExtension)this.getProject().getExtensions().findByType(QuarkusPluginExtension.class);
        this.projectDir = this.getProject().getProjectDir();
        this.buildDir = this.getProject().getBuildDir();
        this.notCompatibleWithConfigurationCache("The Quarkus Plugin isn't compatible with the configuration cache");
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    QuarkusPluginExtension extension() {
        return this.extension;
    }

    WorkQueue workQueue(Map<String, String> configMap, Supplier<List<Action<? super JavaForkOptions>>> forkOptionsActions) {
        WorkerExecutor workerExecutor = this.getWorkerExecutor();
        if (Boolean.getBoolean("org.gradle.debug") || Boolean.getBoolean("quarkus.gradle-worker.no-process")) {
            return workerExecutor.classLoaderIsolation();
        }
        return workerExecutor.processIsolation(processWorkerSpec -> this.configureProcessWorkerSpec((ProcessWorkerSpec)processWorkerSpec, configMap, (List)forkOptionsActions.get()));
    }

    private void configureProcessWorkerSpec(ProcessWorkerSpec processWorkerSpec, Map<String, String> configMap, List<Action<? super JavaForkOptions>> customizations) {
        String quarkusWorkerMaxHeap;
        JavaForkOptions forkOptions = processWorkerSpec.getForkOptions();
        customizations.forEach(a -> a.execute((Object)forkOptions));
        String userDir = configMap.get("user.dir");
        if (userDir != null) {
            forkOptions.systemProperty("user.dir", (Object)userDir);
        }
        if ((quarkusWorkerMaxHeap = System.getProperty("quarkus.gradle-worker.max-heap")) != null && forkOptions.getAllJvmArgs().stream().noneMatch(arg -> arg.startsWith("-Xmx"))) {
            forkOptions.jvmArgs(new Object[]{"-Xmx" + quarkusWorkerMaxHeap});
        }
        forkOptions.environment(System.getenv());
        if (OS.determineOS() == OS.WINDOWS) {
            String java = forkOptions.getExecutable();
            Path javaBinPath = Paths.get(java, new String[0]).getParent().toAbsolutePath();
            String javaBin = javaBinPath.toString();
            String javaHome = javaBinPath.getParent().toString();
            forkOptions.environment("JAVA_HOME", (Object)javaHome);
            forkOptions.environment("PATH", (Object)(javaBin + File.pathSeparator + System.getenv("PATH")));
        }
        configMap.entrySet().stream().filter(e -> WORKER_BUILD_FORK_OPTIONS.stream().anyMatch(((String)e.getKey()).toLowerCase()::startsWith)).forEach(e -> forkOptions.systemProperty((String)e.getKey(), e.getValue()));
    }
}

