/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.cmd.RunCommandActionResultBuildItem;
import io.quarkus.deployment.cmd.RunCommandHandler;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.ProcessUtil;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class QuarkusRun
extends QuarkusBuildTask {
    private final Property<File> workingDirectory;
    private final SourceSet mainSourceSet;
    private final ListProperty<String> jvmArgs;

    @Inject
    public QuarkusRun() {
        this("Quarkus runs target application");
    }

    public QuarkusRun(String description) {
        super(description);
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.mainSourceSet = (SourceSet)((SourceSetContainer)this.getProject().getExtensions().getByType(SourceSetContainer.class)).getByName("main");
        this.workingDirectory = objectFactory.property(File.class);
        this.workingDirectory.convention(this.getProject().provider(() -> QuarkusPluginExtension.getLastFile(this.getCompilationOutput())));
        this.jvmArgs = objectFactory.listProperty(String.class);
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCompilationOutput() {
        return this.mainSourceSet.getOutput().getClassesDirs();
    }

    @Input
    public Property<File> getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Deprecated
    public void setWorkingDir(String workingDir) {
        this.workingDirectory.set((Object)this.getProject().file((Object)workingDir));
    }

    @Input
    public ListProperty<String> getJvmArguments() {
        return this.jvmArgs;
    }

    @Internal
    public List<String> getJvmArgs() {
        return (List)this.jvmArgs.get();
    }

    @Option(description="Set JVM arguments", option="jvm-args")
    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs.set(jvmArgs);
    }

    @TaskAction
    public void runQuarkus() {
        ApplicationModel appModel = this.resolveAppModelForBuild();
        Properties sysProps = new Properties();
        sysProps.putAll(this.extension().buildEffectiveConfiguration(appModel.getAppArtifact()).getValues());
        try (CuratedApplication curatedApplication = QuarkusBootstrap.builder().setBaseClassLoader(((Object)((Object)this)).getClass().getClassLoader()).setExistingModel(appModel).setTargetDirectory(this.getProject().getBuildDir().toPath()).setBaseName(this.extension().finalName()).setBuildSystemProperties(sysProps).setAppArtifact(appModel.getAppArtifact()).setLocalProjectDiscovery(Boolean.valueOf(false)).setIsolateDeployment(true).build().bootstrap();){
            AugmentAction action = curatedApplication.createAugmentor();
            final AtomicReference exists = new AtomicReference();
            final AtomicReference tooMany = new AtomicReference();
            final String target = System.getProperty("quarkus.run.target");
            action.performCustomBuild(RunCommandHandler.class.getName(), (Object)new Consumer<Map<String, List>>(){

                @Override
                public void accept(Map<String, List> cmds) {
                    List cmd = null;
                    if (target != null) {
                        cmd = cmds.get(target);
                        if (cmd == null) {
                            exists.set(false);
                            return;
                        }
                    } else if (cmds.size() == 1) {
                        cmd = cmds.values().iterator().next();
                    } else if (cmds.size() == 2) {
                        for (Map.Entry<String, List> entry : cmds.entrySet()) {
                            if (entry.getKey().equals("java")) continue;
                            cmd = entry.getValue();
                            break;
                        }
                    } else {
                        if (cmds.size() > 2) {
                            tooMany.set(cmds.keySet().stream().collect(Collectors.joining(" ")));
                            return;
                        }
                        throw new RuntimeException("Should never reach this!");
                    }
                    List args = (List)cmd.get(0);
                    if (QuarkusRun.this.getJvmArguments().isPresent() && !((List)QuarkusRun.this.getJvmArguments().get()).isEmpty()) {
                        args.addAll(1, QuarkusRun.this.getJvmArgs());
                    }
                    QuarkusRun.this.getProject().getLogger().info("Executing \"" + String.join((CharSequence)" ", args) + "\"");
                    Path wd = (Path)cmd.get(1);
                    File wdir = wd != null ? wd.toFile() : (File)QuarkusRun.this.workingDirectory.get();
                    try {
                        ProcessUtil.launch(args, wdir, QuarkusRun.this.getProject().getLogger());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }, new String[]{RunCommandActionResultBuildItem.class.getName()});
            if (target != null && !((Boolean)exists.get()).booleanValue()) {
                this.getProject().getLogger().error("quarkus.run.target " + target + " is not found");
                return;
            }
            if (tooMany.get() != null) {
                this.getProject().getLogger().error("Too many installed extensions support quarkus:run.  Use -Dquarkus.run.target=<target> to choose");
                this.getProject().getLogger().error("Extensions: " + (String)tooMany.get());
            }
        }
        catch (BootstrapException e) {
            throw new GradleException("Failed to run application", (Throwable)e);
        }
    }
}

