/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.dsl.Manifest;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import io.quarkus.runtime.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

@CacheableTask
public abstract class QuarkusBuild
extends QuarkusBuildTask {
    private static final String NATIVE_PROPERTY_NAMESPACE = "quarkus.native";
    public static final String QUARKUS_IGNORE_LEGACY_DEPLOY_BUILD = "quarkus.ignore.legacy.deploy.build";

    @Inject
    public QuarkusBuild() {
        super("Builds a Quarkus application.");
    }

    public QuarkusBuild nativeArgs(Action<Map<String, ?>> action) {
        HashMap nativeArgsMap = new HashMap();
        action.execute(nativeArgsMap);
        for (Map.Entry nativeArg : nativeArgsMap.entrySet()) {
            this.getForcedProperties().put((Object)this.expandConfigurationKey((String)nativeArg.getKey()), (Object)nativeArg.getValue().toString());
        }
        return this;
    }

    @Internal
    public MapProperty<String, String> getForcedProperties() {
        return this.extension().forcedPropertiesProperty();
    }

    @Internal
    public ListProperty<String> getIgnoredEntries() {
        return this.extension().ignoredEntriesProperty();
    }

    @Option(description="When using the uber-jar option, this option can be used to specify one or more entries that should be excluded from the final jar", option="ignored-entry")
    public void setIgnoredEntries(List<String> ignoredEntries) {
        this.getIgnoredEntries().addAll(ignoredEntries);
    }

    @Internal
    public Manifest getManifest() {
        return this.extension().manifest();
    }

    public QuarkusBuild manifest(Action<Manifest> action) {
        action.execute((Object)this.getManifest());
        return this;
    }

    @Internal
    public File getRunnerJar() {
        return this.runnerJar();
    }

    @Internal
    public File getNativeRunner() {
        return this.nativeRunner();
    }

    @Internal
    public File getFastJar() {
        return this.fastJar();
    }

    @Internal
    public File getArtifactProperties() {
        return this.artifactProperties();
    }

    @OutputDirectories
    protected Map<String, File> getBuildOutputDirectories() {
        HashMap<String, File> outputs = new HashMap<String, File>();
        if (this.nativeEnabled()) {
            if (this.jarEnabled()) {
                throw QuarkusBuild.nativeAndJar();
            }
            if (this.nativeSourcesOnly()) {
                outputs.put("fast-jar", this.fastJar());
                outputs.put("generated", this.genBuildDir().toFile());
                outputs.put("native-source", this.nativeSources());
            } else {
                outputs.put("native-source", this.nativeSources());
                outputs.put("fast-jar", this.fastJar());
            }
        } else if (this.jarEnabled()) {
            switch (this.jarType()) {
                case LEGACY_JAR: {
                    outputs.put("fast-jar", this.fastJar());
                    outputs.put("legacy-lib", this.gradleBuildDir().resolve("lib").toFile());
                    break;
                }
                case FAST_JAR: {
                    outputs.put("fast-jar", this.fastJar());
                    break;
                }
                case MUTABLE_JAR: 
                case UBER_JAR: {
                    outputs.put("fast-jar", this.fastJar());
                    outputs.put("generated", this.genBuildDir().toFile());
                }
            }
        }
        return outputs;
    }

    @OutputFiles
    protected Map<String, File> getBuildOutputFiles() {
        HashMap<String, File> outputs = new HashMap<String, File>();
        if (this.nativeEnabled()) {
            if (this.jarEnabled()) {
                throw QuarkusBuild.nativeAndJar();
            }
            if (this.nativeSourcesOnly()) {
                outputs.put("artifact-properties", this.artifactProperties());
            } else {
                outputs.put("native-runner", this.nativeRunner());
                outputs.put("artifact-properties", this.artifactProperties());
            }
        } else if (this.jarEnabled()) {
            PackageConfig.JarConfig.JarType packageType = this.jarType();
            switch (packageType) {
                case LEGACY_JAR: 
                case UBER_JAR: {
                    outputs.put("runner-jar", this.runnerJar());
                    outputs.put("artifact-properties", this.artifactProperties());
                    break;
                }
                case FAST_JAR: 
                case MUTABLE_JAR: {
                    outputs.put("artifact-properties", this.artifactProperties());
                }
            }
        }
        return outputs;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    protected Collection<File> getBuildInputFiles() {
        ArrayList<File> inputs = new ArrayList<File>();
        if (this.nativeEnabled()) {
            if (this.jarEnabled()) {
                throw QuarkusBuild.nativeAndJar();
            }
            if (!this.nativeSourcesOnly()) {
                Path appBuildBaseDir = this.appBuildDir();
                inputs.add(this.genBuildDir().toFile());
                inputs.add(appBuildBaseDir.resolve(this.outputDirectory()).toFile());
                this.runnerAndArtifactsInputs(inputs::add, appBuildBaseDir);
            }
        } else if (this.jarEnabled()) {
            PackageConfig.JarConfig.JarType packageType = this.jarType();
            switch (packageType) {
                case FAST_JAR: {
                    Path appBuildBaseDir = this.appBuildDir();
                    inputs.add(this.genBuildDir().toFile());
                    inputs.add(appBuildBaseDir.resolve(this.outputDirectory()).toFile());
                    this.runnerAndArtifactsInputs(inputs::add, appBuildBaseDir);
                    break;
                }
                case LEGACY_JAR: {
                    inputs.add(this.depBuildDir().resolve("lib").toFile());
                    inputs.add(this.appBuildDir().resolve("lib").toFile());
                    this.runnerAndArtifactsInputs(inputs::add, this.appBuildDir());
                    break;
                }
            }
        }
        return inputs;
    }

    private void runnerAndArtifactsInputs(Consumer<File> buildInputs, Path sourceDir) {
        buildInputs.accept(sourceDir.resolve("quarkus-artifact.properties").toFile());
        buildInputs.accept(sourceDir.resolve(this.nativeRunnerFileName()).toFile());
        buildInputs.accept(sourceDir.resolve(this.runnerJarFileName()).toFile());
        buildInputs.accept(sourceDir.resolve(this.nativeImageSourceJarDirName()).toFile());
    }

    @TaskAction
    public void finalizeQuarkusBuild() {
        if (((Map)this.extension().forcedPropertiesProperty().get()).containsKey(QUARKUS_IGNORE_LEGACY_DEPLOY_BUILD)) {
            this.getLogger().info("SKIPPING finalizedBy deploy build");
            return;
        }
        this.getLogger().info("Removing output files and directories (provide a clean state).");
        this.getFileSystemOperations().delete(delete -> delete.delete(new Object[]{this.getBuildOutputFiles().values()}));
        if (this.nativeEnabled()) {
            if (this.jarEnabled()) {
                throw QuarkusBuild.nativeAndJar();
            }
            if (this.nativeSourcesOnly()) {
                this.generateBuild();
                this.assembleFullBuild();
            } else {
                this.assembleFastJar();
            }
        } else if (this.jarEnabled()) {
            switch (this.jarType()) {
                case FAST_JAR: {
                    this.assembleFastJar();
                    break;
                }
                case LEGACY_JAR: {
                    this.assembleLegacyJar();
                    break;
                }
                case MUTABLE_JAR: 
                case UBER_JAR: {
                    this.generateBuild();
                    this.assembleFullBuild();
                }
            }
        }
    }

    private void assembleLegacyJar() {
        this.getLogger().info("Finalizing Quarkus build for {} JAR type", (Object)this.jarType());
        Path buildDir = this.buildDir.toPath();
        Path libDir = buildDir.resolve("lib");
        Path depBuildDir = this.depBuildDir();
        Path appBuildDir = this.appBuildDir();
        this.getLogger().info("Removing potentially existing legacy-jar lib/ directory.");
        this.getFileSystemOperations().delete(delete -> delete.delete(new Object[]{libDir}));
        this.getLogger().info("Copying lib/ directory from {} into {}", (Object)depBuildDir, (Object)buildDir);
        this.getFileSystemOperations().copy(copy -> {
            copy.into((Object)buildDir);
            copy.from(new Object[]{depBuildDir});
            copy.include(new String[]{"lib/**"});
        });
        this.getLogger().info("Copying lib/ directory from {} into {}", (Object)appBuildDir, (Object)buildDir);
        this.getFileSystemOperations().copy(copy -> {
            copy.into((Object)buildDir);
            copy.from(new Object[]{appBuildDir});
            copy.include(new String[]{"lib/**"});
        });
        this.getLogger().info("Cleaning up lib/ directory in {}", (Object)buildDir);
        try (Stream<Path> files = Files.walk(libDir, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.getFileName().toString().startsWith("modified-")).map(f -> f.getParent().resolve(f.getFileName().toString().substring("modified-".length()))).collect(Collectors.toList()).forEach(f -> {
                try {
                    Files.deleteIfExists(f);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new GradleException("Failed to clean up non-modified jars in lib/");
        }
        this.copyRunnersAndArtifactProperties(appBuildDir);
    }

    private void assembleFullBuild() {
        File targetDir = this.buildDir;
        Path genBuildDir = this.genBuildDir();
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Copying Quarkus build for native sources from {} into {}", (Object)genBuildDir, (Object)targetDir);
            } else {
                this.getLogger().info("Copying Quarkus native build from {} into {}", (Object)genBuildDir, (Object)targetDir);
            }
        } else {
            this.getLogger().info("Copying Quarkus build for {} JAR type from {} into {}", new Object[]{this.jarType(), genBuildDir, targetDir});
        }
        this.getFileSystemOperations().copy(copy -> {
            copy.into((Object)targetDir);
            copy.from(new Object[]{genBuildDir});
        });
        this.copyRunnersAndArtifactProperties(this.genBuildDir());
    }

    private void assembleFastJar() {
        File appTargetDir = this.fastJar();
        Path appBuildBaseDir = this.appBuildDir();
        Path appBuildDir = appBuildBaseDir.resolve(this.outputDirectory());
        Path depBuildDir = this.depBuildDir();
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Synchronizing Quarkus build for native sources from {} and {} into {}", new Object[]{appBuildDir, depBuildDir, appTargetDir});
            } else {
                this.getLogger().info("Synchronizing Quarkus native build from {} and {} into {}", new Object[]{appBuildDir, depBuildDir, appTargetDir});
            }
        } else {
            this.getLogger().info("Synchronizing Quarkus build for {} JAR type from {} and {} into {}", new Object[]{this.jarType(), appBuildDir, depBuildDir, appTargetDir});
        }
        this.getFileSystemOperations().sync(sync -> {
            sync.eachFile((Action)new QuarkusBuildTask.CopyActionDeleteNonWriteableTarget(appTargetDir.toPath()));
            sync.into((Object)appTargetDir);
            sync.from(new Object[]{appBuildDir, depBuildDir});
        });
        this.copyRunnersAndArtifactProperties(appBuildBaseDir);
    }

    private void copyRunnersAndArtifactProperties(Path sourceDir) {
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Copying remaining Quarkus application artifacts for native sources from {} into {}", (Object)sourceDir, (Object)this.buildDir);
            } else {
                this.getLogger().info("Copying remaining Quarkus application artifacts for native build from {} into {}", (Object)sourceDir, (Object)this.buildDir);
            }
        } else {
            this.getLogger().info("Copying remaining Quarkus application artifacts for {} JAR type from {} into {}", new Object[]{this.jarType(), sourceDir, this.buildDir});
        }
        this.getFileSystemOperations().copy(copy -> copy.into((Object)this.buildDir).from(new Object[]{sourceDir}).include(new String[]{"quarkus-artifact.properties", this.nativeRunnerFileName(), this.runnerJarFileName(), "jib-image*", "native-sources", this.nativeImageSourceJarDirName() + "/**"}));
    }

    private String expandConfigurationKey(String shortKey) {
        String hyphenatedKey = StringUtil.hyphenate((String)shortKey);
        if (hyphenatedKey.startsWith(NATIVE_PROPERTY_NAMESPACE)) {
            return hyphenatedKey;
        }
        return String.format("%s.%s", NATIVE_PROPERTY_NAMESPACE, hyphenatedKey);
    }

    static GradleException nativeAndJar() {
        return new GradleException("Outputting both native and JAR packages is not currently supported");
    }
}

