/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.gradle.tasks.worker.CodeGenWorker;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;

@CacheableTask
public abstract class QuarkusGenerateCode
extends QuarkusTask {
    public static final String QUARKUS_GENERATED_SOURCES = "quarkus-generated-sources";
    public static final String QUARKUS_TEST_GENERATED_SOURCES = "quarkus-test-generated-sources";
    public static final String[] CODE_GENERATION_PROVIDER = new String[]{"grpc", "avdl", "avpr", "avsc"};
    public static final String[] CODE_GENERATION_INPUT = new String[]{"proto", "avro"};
    private Set<Path> sourcesDirectories;
    private FileCollection compileClasspath;
    private final LaunchMode launchMode;
    private final String inputSourceSetName;

    @Inject
    public QuarkusGenerateCode(LaunchMode launchMode, String inputSourceSetName) {
        super("Performs Quarkus pre-build preparations, such as sources generation");
        this.launchMode = launchMode;
        this.inputSourceSetName = inputSourceSetName;
    }

    @CompileClasspath
    public FileCollection getClasspath() {
        return this.compileClasspath;
    }

    public void setCompileClasspath(Configuration compileClasspath) {
        this.compileClasspath = compileClasspath;
    }

    @Input
    public Map<String, String> getCachingRelevantInput() {
        return this.extension().baseConfig().quarkusProperties();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Set<File> getInputDirectory() {
        HashSet<File> inputDirectories = new HashSet<File>();
        Path src = this.projectDir.toPath().resolve("src").resolve(this.inputSourceSetName);
        for (String input : CODE_GENERATION_INPUT) {
            Path providerSrcDir = src.resolve(input);
            if (!Files.exists(providerSrcDir, new LinkOption[0])) continue;
            inputDirectories.add(providerSrcDir.toFile());
        }
        return inputDirectories;
    }

    @OutputDirectory
    public abstract DirectoryProperty getGeneratedOutputDirectory();

    @TaskAction
    public void generateCode() {
        ApplicationModel appModel = this.extension().getApplicationModel(this.launchMode);
        Map<String, String> configMap = this.extension().buildEffectiveConfiguration(appModel.getAppArtifact()).configMap();
        File outputPath = ((Directory)this.getGeneratedOutputDirectory().get()).getAsFile();
        this.getLogger().debug("Will trigger preparing sources for source directory: {} buildDir: {}", this.sourcesDirectories, (Object)this.buildDir.getAbsolutePath());
        WorkQueue workQueue = this.workQueue(configMap, () -> this.extension().codeGenForkOptions);
        workQueue.submit(CodeGenWorker.class, params -> {
            params.getBuildSystemProperties().putAll(configMap);
            params.getBaseName().set((Object)this.extension().finalName());
            params.getTargetDirectory().set(this.buildDir);
            params.getAppModel().set((Object)appModel);
            params.getSourceDirectories().setFrom((Iterable)this.sourcesDirectories.stream().map(Path::toFile).collect(Collectors.toList()));
            params.getOutputPath().set(outputPath);
            params.getLaunchMode().set((Object)this.launchMode);
        });
        workQueue.await();
    }

    public void setSourcesDirectories(Set<Path> sourcesDirectories) {
        this.sourcesDirectories = sourcesDirectories;
    }
}

