/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.api.tasks.TaskAction;

public abstract class QuarkusBuildDependencies
extends QuarkusBuildTask {
    static final String CLASS_LOADING_REMOVED_ARTIFACTS = "quarkus.class-loading.removed-artifacts";
    static final String CLASS_LOADING_PARENT_FIRST_ARTIFACTS = "quarkus.class-loading.parent-first-artifacts";
    static final String FILTER_OPTIONAL_DEPENDENCIES = "quarkus.package.filter-optional-dependencies";
    static final String INCLUDED_OPTIONAL_DEPENDENCIES = "quarkus.package.included-optional-dependencies";

    @Inject
    public QuarkusBuildDependencies() {
        super("Collect dependencies for the Quarkus application to be built. Do not use this task directly, use 'quarkusBuild'");
    }

    @OutputDirectories
    public Map<String, File> getOutputDirectories() {
        HashMap<String, File> outputs = new HashMap<String, File>();
        PackageConfig.BuiltInType packageType = this.packageType();
        switch (packageType) {
            case JAR: 
            case FAST_JAR: 
            case NATIVE: 
            case LEGACY_JAR: 
            case LEGACY: {
                outputs.put("dependencies-dir", this.depBuildDir().toFile());
                break;
            }
            case MUTABLE_JAR: 
            case UBER_JAR: 
            case NATIVE_SOURCES: {
                break;
            }
            default: {
                throw new GradleException("Unsupported package type " + packageType);
            }
        }
        return outputs;
    }

    @TaskAction
    public void collectDependencies() {
        Path depDir = this.depBuildDir();
        this.getFileSystemOperations().delete(delete -> delete.delete(new Object[]{depDir}));
        PackageConfig.BuiltInType packageType = this.packageType();
        switch (packageType) {
            case JAR: 
            case FAST_JAR: 
            case NATIVE: {
                this.fastJarDependencies();
                break;
            }
            case LEGACY_JAR: 
            case LEGACY: {
                this.legacyJarDependencies();
                break;
            }
            case MUTABLE_JAR: 
            case UBER_JAR: 
            case NATIVE_SOURCES: {
                this.getLogger().info("Falling back to 'full quarkus application build' for package type {}, this task's output is empty for this package type", (Object)packageType);
                break;
            }
            default: {
                throw new GradleException("Unsupported package type " + packageType);
            }
        }
    }

    private void fastJarDependencies() {
        Path depDir = this.depBuildDir();
        Path libBoot = depDir.resolve("lib/boot");
        Path libMain = depDir.resolve("lib/main");
        this.jarDependencies(libBoot, libMain);
    }

    private void legacyJarDependencies() {
        Path depDir = this.depBuildDir();
        Path lib = depDir.resolve("lib");
        this.jarDependencies(lib, lib);
    }

    private void jarDependencies(Path libBoot, Path libMain) {
        Path depDir = this.depBuildDir();
        this.getLogger().info("Placing Quarkus application dependencies for package type {} in {}", (Object)this.packageType(), (Object)depDir);
        try {
            Files.createDirectories(libBoot, new FileAttribute[0]);
            Files.createDirectories(libMain, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new GradleException(String.format("Failed to create directories in %s", depDir), (Throwable)e);
        }
        ApplicationModel appModel = this.resolveAppModelForBuild();
        Map<String, String> configMap = this.extension().buildEffectiveConfiguration(appModel.getAppArtifact()).configMap();
        Set removedArtifacts = Optional.ofNullable(configMap.getOrDefault(CLASS_LOADING_REMOVED_ARTIFACTS, null)).map(QuarkusBuildDependencies::dependenciesListToArtifactKeySet).orElse(Collections.emptySet());
        this.getLogger().info("Removed artifacts: {}", (Object)configMap.getOrDefault(CLASS_LOADING_REMOVED_ARTIFACTS, "(none)"));
        String parentFirstArtifactsProp = configMap.getOrDefault(CLASS_LOADING_PARENT_FIRST_ARTIFACTS, "");
        Set<ArtifactKey> parentFirstArtifacts = QuarkusBuildDependencies.dependenciesListToArtifactKeySet(parentFirstArtifactsProp);
        this.getLogger().info("parent first artifacts: {}", (Object)configMap.getOrDefault(CLASS_LOADING_PARENT_FIRST_ARTIFACTS, "(none)"));
        String optionalDependenciesProp = configMap.getOrDefault(INCLUDED_OPTIONAL_DEPENDENCIES, "");
        boolean filterOptionalDependencies = Boolean.parseBoolean(configMap.getOrDefault(FILTER_OPTIONAL_DEPENDENCIES, "false"));
        Set<Object> optionalDependencies = filterOptionalDependencies ? QuarkusBuildDependencies.dependenciesListToArtifactKeySet(optionalDependenciesProp) : Collections.emptySet();
        appModel.getRuntimeDependencies().stream().filter(appDep -> {
            if (!appDep.isJar()) {
                return false;
            }
            if (filterOptionalDependencies && appDep.isOptional()) {
                return optionalDependencies.contains(appDep.getKey());
            }
            return !removedArtifacts.contains(appDep.getKey());
        }).map(dep -> Map.entry(dep.isFlagSet(512) || parentFirstArtifacts.contains(dep.getKey()) ? libBoot : libMain, dep)).peek(depAndTarget -> {
            ResolvedDependency dep = (ResolvedDependency)depAndTarget.getValue();
            Path targetDir = (Path)depAndTarget.getKey();
            dep.getResolvedPaths().forEach(p -> {
                String file = dep.getGroupId() + "." + p.getFileName();
                Path target = targetDir.resolve(file);
                if (!Files.exists(target, new LinkOption[0])) {
                    this.getLogger().debug("Dependency {} : copying {} to {}", new Object[]{dep.toGACTVString(), p, target});
                    try {
                        Files.copy(p, target, new CopyOption[0]);
                    }
                    catch (IOException e) {
                        throw new GradleException(String.format("Failed to copy %s to %s", p, target), (Throwable)e);
                    }
                }
            });
        }).collect(Collectors.toMap(Map.Entry::getKey, depAndTarget -> 1, Integer::sum)).forEach((path, count) -> this.getLogger().info("Copied {} files into {}", count, path));
    }

    private static Set<ArtifactKey> dependenciesListToArtifactKeySet(String optionalDependenciesProp) {
        return Arrays.stream(optionalDependenciesProp.split(",")).map(String::trim).filter(gact -> !gact.isEmpty()).map(ArtifactKey::fromString).collect(Collectors.toSet());
    }
}

