/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.buildfile.GradleGroovyProjectBuildFile;
import io.quarkus.devtools.project.buildfile.GradleKotlinProjectBuildFile;
import io.quarkus.devtools.project.buildfile.GradleProjectBuildFile;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.gradle.GradleUtils;
import io.quarkus.gradle.tasks.GradleMessageWriter;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;

public abstract class QuarkusPlatformTask
extends QuarkusTask {
    private volatile ExtensionCatalogResolver catalogResolver;

    QuarkusPlatformTask(String description) {
        super(description);
    }

    private ExtensionCatalog extensionsCatalog(boolean limitExtensionsToImportedPlatforms, MessageWriter log) {
        List<ArtifactCoords> platforms = this.importedPlatforms();
        ExtensionCatalogResolver catalogResolver = this.getExtensionCatalogResolver(log);
        if (catalogResolver.hasRegistries() && !limitExtensionsToImportedPlatforms) {
            try {
                return catalogResolver.resolveExtensionCatalog(platforms);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to resolve extension catalog", e);
            }
        }
        return ToolsUtils.mergePlatforms(platforms, (AppModelResolver)this.extension().getAppModelResolver());
    }

    protected ExtensionCatalogResolver getExtensionCatalogResolver(MessageWriter log) {
        if (this.catalogResolver == null) {
            try {
                this.catalogResolver = QuarkusProjectHelper.isRegistryClientEnabled() ? QuarkusProjectHelper.getCatalogResolver((MessageWriter)log) : ExtensionCatalogResolver.empty();
            }
            catch (RegistryResolutionException e) {
                throw new RuntimeException("Failed to initialize Quarkus extension catalog resolver", e);
            }
        }
        return this.catalogResolver;
    }

    protected List<ArtifactCoords> importedPlatforms() {
        List<Dependency> bomDeps = GradleUtils.listProjectBoms(this.getProject());
        if (bomDeps.isEmpty()) {
            throw new GradleException("No platforms detected in the project");
        }
        Configuration boms = this.getProject().getConfigurations().detachedConfiguration(bomDeps.toArray(new Dependency[0]));
        HashSet processedKeys = new HashSet(1);
        ArrayList<ArtifactCoords> platforms = new ArrayList<ArtifactCoords>();
        boms.getResolutionStrategy().eachDependency(d -> {
            if (!d.getTarget().getName().endsWith("-quarkus-platform-descriptor") || !processedKeys.add(ArtifactKey.ga((String)d.getTarget().getGroup(), (String)d.getTarget().getName()))) {
                return;
            }
            ArtifactCoords platform = ArtifactCoords.of((String)d.getTarget().getGroup(), (String)d.getTarget().getName(), (String)d.getTarget().getVersion(), (String)"json", (String)d.getTarget().getVersion());
            platforms.add(platform);
        });
        boms.getResolvedConfiguration();
        if (platforms.isEmpty()) {
            throw new RuntimeException("No Quarkus platforms found in the project");
        }
        return platforms;
    }

    protected String quarkusCoreVersion() {
        List<Dependency> bomDeps = GradleUtils.listProjectBoms(this.getProject());
        if (bomDeps.isEmpty()) {
            throw new GradleException("No platforms detected in the project");
        }
        Configuration boms = this.getProject().getConfigurations().detachedConfiguration(bomDeps.toArray(new Dependency[0]));
        AtomicReference quarkusVersionRef = new AtomicReference();
        boms.getResolutionStrategy().eachDependency(d -> {
            if (quarkusVersionRef.get() == null && d.getTarget().getName().equals("quarkus-core") && d.getTarget().getGroup().equals("io.quarkus")) {
                quarkusVersionRef.set(d.getTarget().getVersion());
            }
        });
        boms.getResolvedConfiguration();
        String quarkusCoreVersion = (String)quarkusVersionRef.get();
        if (quarkusCoreVersion == null) {
            throw new IllegalStateException("Failed to determine the Quarkus core version for the project");
        }
        return quarkusCoreVersion;
    }

    protected QuarkusProject getQuarkusProject(boolean limitExtensionsToImportedPlatforms) {
        GradleProjectBuildFile buildFile;
        Path rootProjectPath;
        GradleMessageWriter log = this.messageWriter();
        ExtensionCatalog catalog = this.extensionsCatalog(limitExtensionsToImportedPlatforms, log);
        Path projectDirPath = this.getProject().getProjectDir().toPath();
        Path path = rootProjectPath = this.getProject().getParent() != null ? this.getProject().getRootProject().getProjectDir().toPath() : projectDirPath;
        if (Files.exists(rootProjectPath.resolve("settings.gradle.kts"), new LinkOption[0]) && Files.exists(projectDirPath.resolve("build.gradle.kts"), new LinkOption[0])) {
            buildFile = new GradleKotlinProjectBuildFile(this.getProject(), catalog);
        } else if (Files.exists(rootProjectPath.resolve("settings.gradle"), new LinkOption[0]) && Files.exists(projectDirPath.resolve("build.gradle"), new LinkOption[0])) {
            buildFile = new GradleGroovyProjectBuildFile(this.getProject(), catalog);
        } else {
            throw new GradleException("Mixed DSL is not supported. Both build and settings file need to use either Kotlin or Groovy DSL");
        }
        return QuarkusProjectHelper.getProject((Path)this.getProject().getProjectDir().toPath(), (ExtensionCatalog)catalog, (ExtensionManager)buildFile, (MessageWriter)log);
    }

    protected GradleMessageWriter messageWriter() {
        return new GradleMessageWriter(this.getLogger());
    }

    protected static URL toURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GradleException("Malformed URL:" + url, (Throwable)e);
        }
    }
}

