/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import com.google.common.annotations.VisibleForTesting;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

final class EffectiveConfig {
    private final Map<String, String> fullConfig;
    private final List<URL> applicationPropsSources;
    private final SmallRyeConfig config;

    private EffectiveConfig(Builder builder) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        this.applicationPropsSources = new ArrayList<URL>();
        configSources.add((ConfigSource)new PropertiesConfigSource(builder.forcedProperties, "forcedProperties", 600));
        configSources.add((ConfigSource)new PropertiesConfigSource(this.asStringMap(builder.taskProperties), "taskProperties", 500));
        configSources.add((ConfigSource)new PropertiesConfigSource(ConfigSourceUtil.propertiesToMap((Properties)System.getProperties()), "System.getProperties()", 400));
        configSources.add((ConfigSource)new EnvConfigSource(300){});
        configSources.add((ConfigSource)new PropertiesConfigSource(builder.buildProperties, "quarkusBuildProperties", 290));
        configSources.add((ConfigSource)new PropertiesConfigSource(this.asStringMap(builder.projectProperties), "projectProperties", 280));
        EffectiveConfig.configSourcesForApplicationProperties(builder.sourceDirectories, this.applicationPropsSources::add, configSources::add, 250, new String[]{"application.properties", "application.yaml", "application.yml"});
        EffectiveConfig.configSourcesForApplicationProperties(builder.sourceDirectories, this.applicationPropsSources::add, configSources::add, 100, new String[]{"microprofile-config.properties"});
        this.config = EffectiveConfig.buildConfig(builder.profile, configSources);
        this.fullConfig = EffectiveConfig.generateFullConfigMap(this.config);
    }

    SmallRyeConfig config() {
        return this.config;
    }

    private Map<String, String> asStringMap(Map<String, ?> map) {
        HashMap<String, String> target = new HashMap<String, String>();
        map.forEach((k, v) -> {
            if (v != null) {
                target.put((String)k, v.toString());
            }
        });
        return target;
    }

    @VisibleForTesting
    static Map<String, String> generateFullConfigMap(SmallRyeConfig config) {
        HashMap map = new HashMap();
        config.getPropertyNames().forEach(property -> {
            String v = config.getConfigValue(property).getValue();
            if (v != null) {
                map.put(property, v);
            }
        });
        return Collections.unmodifiableMap(map);
    }

    @VisibleForTesting
    static SmallRyeConfig buildConfig(String profile, List<ConfigSource> configSources) {
        return ConfigUtils.emptyConfigBuilder().withSources(configSources).withProfile(profile).build();
    }

    static Builder builder() {
        return new Builder();
    }

    Map<String, String> configMap() {
        return this.fullConfig;
    }

    List<URL> applicationPropsSources() {
        return this.applicationPropsSources;
    }

    static void configSourcesForApplicationProperties(Set<File> sourceDirectories, Consumer<URL> sourceUrls, Consumer<ConfigSource> configSourceConsumer, int ordinal, String[] fileExtensions) {
        URL[] resourceUrls;
        for (URL resourceUrl : resourceUrls = (URL[])sourceDirectories.stream().map(File::toURI).map(u -> {
            try {
                return u.toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new)) {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{resourceUrl});
            CombinedConfigSourceProvider configSourceProvider = new CombinedConfigSourceProvider(sourceUrls, ordinal, fileExtensions);
            configSourceProvider.getConfigSources(classLoader).forEach(configSourceConsumer);
        }
    }

    static final class CombinedConfigSourceProvider
    extends AbstractLocationConfigSourceLoader
    implements ConfigSourceProvider {
        private final Consumer<URL> sourceUrls;
        private final int ordinal;
        private final String[] fileExtensions;

        CombinedConfigSourceProvider(Consumer<URL> sourceUrls, int ordinal, String[] fileExtensions) {
            this.sourceUrls = sourceUrls;
            this.ordinal = ordinal;
            this.fileExtensions = fileExtensions;
        }

        protected String[] getFileExtensions() {
            return this.fileExtensions;
        }

        protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
            this.sourceUrls.accept(url);
            return url.getPath().endsWith(".properties") ? new PropertiesConfigSource(url, ordinal) : new YamlConfigSource(url, ordinal);
        }

        public List<ConfigSource> getConfigSources(ClassLoader classLoader) {
            return this.loadConfigSources(this.getFileExtensions(), this.ordinal, classLoader);
        }
    }

    static final class Builder {
        private Map<String, String> buildProperties = Collections.emptyMap();
        private Map<String, ?> projectProperties = Collections.emptyMap();
        private Map<String, ?> taskProperties = Collections.emptyMap();
        private Map<String, String> forcedProperties = Collections.emptyMap();
        private Set<File> sourceDirectories = Collections.emptySet();
        private String profile = "prod";

        Builder() {
        }

        EffectiveConfig build() {
            return new EffectiveConfig(this);
        }

        Builder withForcedProperties(Map<String, String> forcedProperties) {
            this.forcedProperties = forcedProperties;
            return this;
        }

        Builder withTaskProperties(Map<String, ?> taskProperties) {
            this.taskProperties = taskProperties;
            return this;
        }

        Builder withBuildProperties(Map<String, String> buildProperties) {
            this.buildProperties = buildProperties;
            return this;
        }

        Builder withProjectProperties(Map<String, ?> projectProperties) {
            this.projectProperties = projectProperties;
            return this;
        }

        Builder withSourceDirectories(Set<File> sourceDirectories) {
            this.sourceDirectories = sourceDirectories;
            return this;
        }

        Builder withProfile(String profile) {
            this.profile = profile;
            return this;
        }
    }
}

