/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.deployment.util.DeploymentUtil;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class Deploy
extends QuarkusBuildTask {
    @Input
    Optional<String> deployer = Optional.empty();
    boolean imageBuild = false;
    Optional<String> imageBuilder = Optional.empty();

    @Option(option="deployer", description="The deployer to use")
    public void setDeployer(String deployer) {
        this.deployer = Optional.ofNullable(deployer);
    }

    @Option(option="image-build", description="Perform an image build before deployment")
    public void setImageBuild(boolean imageBuild) {
        this.imageBuild = imageBuild;
    }

    @Option(option="image-builder", description="Perform an image build using the selected builder before deployment")
    public void setImageBuilder(String imageBuilder) {
        this.imageBuilder = Optional.ofNullable(imageBuilder);
        this.imageBuild = true;
    }

    @Inject
    public Deploy() {
        super("Deploy");
        this.extension().forcedPropertiesProperty().convention(this.getProject().provider(() -> {
            HashMap<Object, String> props = new HashMap<Object, String>();
            props.put("quarkus." + this.getDeployer().name() + ".deploy", "true");
            props.put("quarkus.container-image.build", String.valueOf(this.imageBuilder.isPresent() || this.imageBuild));
            this.imageBuilder.ifPresent(b -> props.put("quarkus.container-image.builder", (String)b));
            return props;
        }));
    }

    @TaskAction
    public void checkRequiredExtensions() {
        List unsatisfied;
        Deployer deployer = this.getDeployer();
        String requiredDeployerExtension = deployer.getExtension();
        Optional<String> requiredContainerImageExtension = this.requiredContainerImageExtension();
        List projectDependencies = this.getProject().getConfigurations().stream().flatMap(c -> c.getDependencies().stream()).map(d -> d.getName()).collect(Collectors.toList());
        if (!projectDependencies.contains(requiredDeployerExtension)) {
            this.abort("Task: {} requires extensions: {}\nTo add the extensions to the project you can run the following command:\n\tgradle addExtension --extensions={}", this.getName(), requiredDeployerExtension, requiredDeployerExtension);
        } else if (!requiredContainerImageExtension.map(b -> projectDependencies.stream().anyMatch(d -> d.equals(b))).orElse(true).booleanValue()) {
            this.abort("Task: {} using: {} is explicitly configured with missing container image builder extension: {}. Aborting.", this.getName(), deployer.name(), requiredContainerImageExtension.get());
        } else if (this.imageBuild && deployer.getRequiresOneOf().length > 0 && (unsatisfied = Arrays.stream(deployer.requiresOneOf).filter(r -> !projectDependencies.stream().anyMatch(d -> d.equals(r))).collect(Collectors.toList())).size() == deployer.getRequiresOneOf().length) {
            this.abort("Task: {} using: {} requires one of the following container image extensions: {}. Aborting.", this.getName(), deployer.name(), unsatisfied.stream().collect(Collectors.joining(", ", "[", "]")));
        }
    }

    public Deployer getDeployer() {
        return this.deployer.or(() -> DeploymentUtil.getEnabledDeployer()).or(() -> this.getProjectDeployers().stream().findFirst()).map(Deployer::valueOf).orElse(Deployer.kubernetes);
    }

    public Optional<String> requiredContainerImageExtension() {
        return this.imageBuilder.map(b -> "quarkus-container-image-" + b).or(() -> this.imageBuild ? Arrays.stream(this.getDeployer().requiresOneOf).findFirst() : Optional.empty());
    }

    private Set<String> getProjectDeployers() {
        return this.getProject().getConfigurations().stream().flatMap(c -> c.getDependencies().stream()).map(d -> d.getName()).filter(d -> Arrays.stream(Deployer.values()).map(Deployer::getExtension).anyMatch(e -> d.equals(e))).map(d -> d.replaceAll("^quarkus\\-", "")).collect(Collectors.toSet());
    }

    public static enum Deployer {
        kubernetes("quarkus-kubernetes", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        minikube("quarkus-minikube", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        kind("quarkus-kind", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        knative("quarkus-kubernetes", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
        openshift("quarkus-openshift", new String[0]);

        private final String extension;
        private final String[] requiresOneOf;

        private Deployer(String extension, String ... requiresOneOf) {
            this.extension = extension;
            this.requiresOneOf = requiresOneOf;
        }

        public String getExtension() {
            return this.extension;
        }

        public String[] getRequiresOneOf() {
            return this.requiresOneOf;
        }
    }
}

