/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks.worker;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.CodeGenerator;
import io.quarkus.gradle.tasks.worker.CodeGenWorkerParams;
import io.quarkus.gradle.tasks.worker.QuarkusWorker;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CodeGenWorker
extends QuarkusWorker<CodeGenWorkerParams> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeGenWorker.class);
    public static final String INIT_AND_RUN = "initAndRun";

    public void execute() {
        CodeGenWorkerParams params = (CodeGenWorkerParams)this.getParameters();
        Properties props = this.buildSystemProperties();
        ResolvedDependency appArtifact = ((ApplicationModel)params.getAppModel().get()).getAppArtifact();
        Path buildDir = ((File)params.getTargetDirectory().getAsFile().get()).toPath();
        Path generatedSourceDir = ((Directory)params.getOutputPath().get()).getAsFile().toPath();
        String gav = appArtifact.getGroupId() + ":" + appArtifact.getArtifactId() + ":" + appArtifact.getVersion();
        LOGGER.info("Generating Quarkus code for {}", (Object)gav);
        LOGGER.info("  launch mode:                  {}", params.getLaunchMode().get());
        LOGGER.info("  base name:                    {}", params.getBaseName().get());
        LOGGER.info("  generated source directory:   {}", (Object)generatedSourceDir);
        LOGGER.info("  build directory:              {}", (Object)buildDir);
        try (CuratedApplication appCreationContext = this.createAppCreationContext();){
            Method initAndRun;
            QuarkusClassLoader deploymentClassLoader = appCreationContext.createDeploymentClassLoader();
            Class codeGenerator = deploymentClassLoader.loadClass(CodeGenerator.class.getName());
            try {
                initAndRun = codeGenerator.getMethod(INIT_AND_RUN, QuarkusClassLoader.class, PathCollection.class, Path.class, Path.class, Consumer.class, ApplicationModel.class, Properties.class, String.class, Boolean.TYPE);
            }
            catch (Exception e) {
                throw new GradleException("Quarkus code generation phase has failed", (Throwable)e);
            }
            Consumer<Path> sourceRegistrar = p -> {};
            LaunchMode launchMode = (LaunchMode)params.getLaunchMode().get();
            initAndRun.invoke(null, deploymentClassLoader, PathList.from((Iterable)params.getSourceDirectories().getFiles().stream().map(File::toPath).collect(Collectors.toList())), generatedSourceDir, buildDir, sourceRegistrar, appCreationContext.getApplicationModel(), props, launchMode.name(), launchMode == LaunchMode.TEST);
        }
        catch (BootstrapException | ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new GradleException("Failed to generate sources in the QuarkusPrepare task for " + gav + " due to " + (Exception)e, e);
        }
    }
}

