/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks.worker;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.ArtifactResult;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.AugmentResult;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.JarResult;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.gradle.tasks.worker.BuildWorkerParams;
import io.quarkus.gradle.tasks.worker.QuarkusWorker;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BuildWorker
extends QuarkusWorker<BuildWorkerParams> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildWorker.class);

    public void execute() {
        BuildWorkerParams params = (BuildWorkerParams)this.getParameters();
        Properties props = this.buildSystemProperties();
        ResolvedDependency appArtifact = ((ApplicationModel)params.getAppModel().get()).getAppArtifact();
        String gav = appArtifact.getGroupId() + ":" + appArtifact.getArtifactId() + ":" + appArtifact.getVersion();
        LOGGER.info("Building Quarkus application {}", (Object)gav);
        LOGGER.info("  base name:                   {}", params.getBaseName().get());
        LOGGER.info("  target directory:            {}", params.getTargetDirectory().getAsFile().get());
        LOGGER.info("  configured package type:     {}", (Object)props.getProperty("quarkus.package.type"));
        LOGGER.info("  configured output directory: {}", (Object)props.getProperty("quarkus.package.output-directory"));
        LOGGER.info("  configured output name:      {}", (Object)props.getProperty("quarkus.package.output-name"));
        try (CuratedApplication appCreationContext = this.createAppCreationContext();){
            AugmentAction augmentor = appCreationContext.createAugmentor("io.quarkus.deployment.pkg.builditem.ProcessInheritIODisabled$Factory", Collections.emptyMap());
            AugmentResult result = augmentor.createProductionApplication();
            if (result == null) {
                System.err.println("createProductionApplication() returned 'null' AugmentResult");
            } else {
                Path nativeResult = result.getNativeResult();
                LOGGER.info("AugmentResult.nativeResult = {}", (Object)nativeResult);
                List results = result.getResults();
                if (results == null) {
                    LOGGER.warn("AugmentResult.results = null");
                } else {
                    LOGGER.info("AugmentResult.results = {}", (Object)results.stream().map(ArtifactResult::getPath).map(r -> r == null ? "null" : r.toString()).collect(Collectors.joining("\n    ", "\n    ", "")));
                }
                JarResult jar = result.getJar();
                LOGGER.info("AugmentResult:");
                if (jar == null) {
                    LOGGER.info("    .jar = null");
                } else {
                    LOGGER.info("    .jar.path = {}", (Object)jar.getPath());
                    LOGGER.info("    .jar.libraryDir = {}", (Object)jar.getLibraryDir());
                    LOGGER.info("    .jar.originalArtifact = {}", (Object)jar.getOriginalArtifact());
                    LOGGER.info("    .jar.uberJar = {}", (Object)jar.isUberJar());
                }
            }
            LOGGER.info("Quarkus application build was successful");
        }
        catch (BootstrapException e) {
            throw new GradleException("Failed to build Quarkus application for " + gav + " due to " + e, (Throwable)e);
        }
    }
}

