/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.UpdateProject;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.PlatformStreamCoords;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class QuarkusUpdate
extends QuarkusPlatformTask {
    private boolean perModule = false;
    private boolean noRewrite;
    private boolean rewriteDryRun;
    private String targetStreamId;
    private String targetPlatformVersion;
    private String rewritePluginVersion = null;
    private String rewriteUpdateRecipesVersion = null;

    @Input
    @Optional
    public Boolean getNoRewrite() {
        return this.noRewrite;
    }

    @Option(description="Disable the rewrite feature.", option="noRewrite")
    public QuarkusUpdate setNoRewrite(Boolean noRewrite) {
        this.noRewrite = noRewrite;
        return this;
    }

    @Input
    @Optional
    public Boolean getRewriteDryRun() {
        return this.rewriteDryRun;
    }

    @Option(description="Rewrite in dry-mode.", option="rewriteDryRun")
    public QuarkusUpdate setRewriteDryRun(Boolean rewriteDryRun) {
        this.rewriteDryRun = rewriteDryRun;
        return this;
    }

    @Input
    public boolean getPerModule() {
        return this.perModule;
    }

    @Option(description="Log project's state per module.", option="perModule")
    public void setPerModule(boolean perModule) {
        this.perModule = perModule;
    }

    @Input
    @Optional
    public String getRewritePluginVersion() {
        return this.rewritePluginVersion;
    }

    @Option(description="The OpenRewrite plugin version", option="rewritePluginVersion")
    public void setRewritePluginVersion(String rewritePluginVersion) {
        this.rewritePluginVersion = rewritePluginVersion;
    }

    @Input
    @Optional
    public String getRewriteUpdateRecipesVersion() {
        return this.rewriteUpdateRecipesVersion;
    }

    @Option(description=" The io.quarkus:quarkus-update-recipes version. This artifact contains the base recipes used by this tool to update a project.", option="updateRecipesVersion")
    public QuarkusUpdate setRewriteUpdateRecipesVersion(String rewriteUpdateRecipesVersion) {
        this.rewriteUpdateRecipesVersion = rewriteUpdateRecipesVersion;
        return this;
    }

    @Input
    @Optional
    public String getTargetStreamId() {
        return this.targetStreamId;
    }

    @Option(description="A target stream, for example:  2.0", option="stream")
    public void setStreamId(String targetStreamId) {
        this.targetStreamId = targetStreamId;
    }

    @Input
    @Optional
    public String getTargetPlatformVersion() {
        return this.targetPlatformVersion;
    }

    @Option(description="A target platform version, for example:  2.0.0.Final", option="platformVersion")
    public void setTargetPlatformVersion(String targetPlatformVersion) {
        this.targetPlatformVersion = targetPlatformVersion;
    }

    public QuarkusUpdate() {
        super("Log Quarkus-specific recommended project updates, such as the new Quarkus platform BOM versions, new versions of Quarkus extensions that aren't managed by the Quarkus BOMs, etc");
    }

    @TaskAction
    public void logUpdates() {
        ExtensionCatalog targetCatalog;
        this.getProject().getLogger().warn(this.getName() + " is experimental, its options and output might change in future versions");
        QuarkusProject quarkusProject = this.getQuarkusProject(false);
        try {
            if (this.targetPlatformVersion != null) {
                ArtifactCoords targetPrimaryBom = QuarkusUpdate.getPrimaryBom(quarkusProject.getExtensionsCatalog());
                targetPrimaryBom = ArtifactCoords.pom((String)targetPrimaryBom.getGroupId(), (String)targetPrimaryBom.getArtifactId(), (String)this.targetPlatformVersion);
                targetCatalog = this.getExtensionCatalogResolver(quarkusProject.log()).resolveExtensionCatalog(List.of(targetPrimaryBom));
            } else if (this.targetStreamId != null) {
                PlatformStreamCoords platformStream = PlatformStreamCoords.fromString((String)this.targetStreamId);
                targetCatalog = this.getExtensionCatalogResolver(quarkusProject.log()).resolveExtensionCatalog(platformStream);
                this.targetPlatformVersion = QuarkusUpdate.getPrimaryBom(targetCatalog).getVersion();
            } else {
                targetCatalog = this.getExtensionCatalogResolver(quarkusProject.log()).resolveExtensionCatalog();
                this.targetPlatformVersion = QuarkusUpdate.getPrimaryBom(targetCatalog).getVersion();
            }
        }
        catch (RegistryResolutionException e) {
            throw new RuntimeException("Failed to resolve the recommended Quarkus extension catalog from the configured extension registries", e);
        }
        UpdateProject invoker = new UpdateProject(quarkusProject);
        invoker.latestCatalog(targetCatalog);
        if (this.rewriteUpdateRecipesVersion != null) {
            invoker.rewriteUpdateRecipesVersion(this.rewriteUpdateRecipesVersion);
        }
        if (this.rewritePluginVersion != null) {
            invoker.rewritePluginVersion(this.rewritePluginVersion);
        }
        invoker.targetPlatformVersion(this.targetPlatformVersion);
        invoker.rewriteDryRun(this.rewriteDryRun);
        invoker.noRewrite(this.noRewrite);
        invoker.perModule(this.perModule);
        invoker.appModel(this.extension().getApplicationModel());
        try {
            invoker.execute();
        }
        catch (Exception e) {
            throw new GradleException("Failed to apply recommended updates", (Throwable)e);
        }
    }

    private static ArtifactCoords getPrimaryBom(ExtensionCatalog c) {
        return c.getDerivedFrom().isEmpty() ? c.getBom() : ((ExtensionOrigin)c.getDerivedFrom().get(0)).getBom();
    }
}

