/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.util.IoUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;

public class QuarkusGradleUtils {
    private static final String ERROR_COLLECTING_PROJECT_CLASSES = "Failed to collect project's classes in a temporary dir";

    public static SourceSet getSourceSet(Project project, String sourceSetName) {
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaConvention == null) {
            throw new IllegalArgumentException("The project does not include the Java plugin");
        }
        return (SourceSet)javaConvention.getSourceSets().getByName(sourceSetName);
    }

    public static String getClassesDir(SourceSet sourceSet, File tmpDir, boolean test) {
        return QuarkusGradleUtils.getClassesDir(sourceSet, tmpDir, true, test);
    }

    public static String getClassesDir(SourceSet sourceSet, File tmpDir, boolean populated, boolean test) {
        FileCollection classesDirs = sourceSet.getOutput().getClassesDirs();
        Set classDirFiles = classesDirs.getFiles();
        if (classDirFiles.size() == 1) {
            return classesDirs.getAsPath();
        }
        HashSet<Path> classesPaths = new HashSet<Path>(classDirFiles.size());
        classesDirs.forEach(f -> classesPaths.add(f.toPath()));
        Path merged = QuarkusGradleUtils.mergeClassesDirs(classesPaths, tmpDir, populated, test);
        return merged == null ? null : merged.toString();
    }

    public static Path mergeClassesDirs(Collection<Path> classesDirs, File tmpDir, boolean populated, boolean test) {
        Path classesDir = null;
        Iterator<Path> i = classesDirs.iterator();
        int dirCount = 0;
        while (i.hasNext()) {
            Path next = i.next();
            if (!Files.exists(next, new LinkOption[0])) continue;
            try {
                switch (dirCount++) {
                    case 0: {
                        classesDir = next;
                        break;
                    }
                    case 1: {
                        Path tmpClassesDir = tmpDir.toPath().resolve("quarkus-app-classes" + (test ? "-test" : ""));
                        if (!populated) {
                            return tmpClassesDir;
                        }
                        if (Files.exists(tmpClassesDir, new LinkOption[0])) {
                            IoUtils.recursiveDelete((Path)tmpClassesDir);
                        }
                        IoUtils.copy((Path)classesDir, (Path)tmpClassesDir);
                        classesDir = tmpClassesDir;
                    }
                    default: {
                        IoUtils.copy((Path)next, (Path)classesDir);
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(ERROR_COLLECTING_PROJECT_CLASSES, e);
            }
        }
        if (classesDir == null) {
            return null;
        }
        return classesDir;
    }
}

