/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.devmode.DependenciesFilter;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.QuarkusDevModeLauncher;
import io.quarkus.gradle.dsl.CompilerOption;
import io.quarkus.gradle.dsl.CompilerOptions;
import io.quarkus.gradle.tasks.GradleDevModeLauncher;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.options.Option;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.util.GradleVersion;

public class QuarkusDev
extends QuarkusTask {
    public static final String IO_QUARKUS_DEVMODE_ARGS = "io.quarkus.devmode-args";
    private Set<File> filesIncludedInClasspath = new HashSet<File>();
    protected Configuration quarkusDevConfiguration;
    private File buildDir;
    private String sourceDir;
    private String workingDir;
    private List<String> jvmArgs;
    private boolean preventnoverify = false;
    private List<String> args = new LinkedList<String>();
    private List<String> compilerArgs = new LinkedList<String>();
    private CompilerOptions compilerOptions = new CompilerOptions();
    private boolean shouldPropagateJavaCompilerArgs = true;

    @Inject
    public QuarkusDev() {
        super("Development mode: enables hot deployment with background compilation");
    }

    public QuarkusDev(String name) {
        super(name);
    }

    @CompileClasspath
    public Configuration getQuarkusDevConfiguration() {
        return this.quarkusDevConfiguration;
    }

    public void setQuarkusDevConfiguration(Configuration quarkusDevConfiguration) {
        this.quarkusDevConfiguration = quarkusDevConfiguration;
    }

    @InputDirectory
    @Optional
    public File getBuildDir() {
        if (this.buildDir == null) {
            this.buildDir = this.getProject().getBuildDir();
        }
        return this.buildDir;
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    @Optional
    @InputDirectory
    public File getSourceDir() {
        if (this.sourceDir == null) {
            return this.extension().sourceDir();
        }
        return new File(this.sourceDir);
    }

    @Option(description="Set source directory", option="source-dir")
    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Input
    public String getWorkingDir() {
        if (this.workingDir == null) {
            return this.extension().workingDir().toString();
        }
        return this.workingDir;
    }

    @Option(description="Set working directory", option="working-dir")
    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    @Optional
    @Input
    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Option(description="Set JVM arguments", option="jvm-args")
    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    @Optional
    @Input
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    @Option(description="Set application arguments", option="quarkus-args")
    public void setArgsString(String argsString) {
        this.setArgs(Arrays.asList(Commandline.translateCommandline((String)argsString)));
    }

    @Input
    public boolean isPreventnoverify() {
        return this.preventnoverify;
    }

    @Option(description="value is intended to be set to true when some generated bytecode is erroneous causing the JVM to crash when the verify:none option is set (which is on by default)", option="prevent-noverify")
    public void setPreventnoverify(boolean preventnoverify) {
        this.preventnoverify = preventnoverify;
    }

    @Optional
    @Input
    public List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @Option(description="Additional parameters to pass to javac when recompiling changed source files", option="compiler-args")
    public void setCompilerArgs(List<String> compilerArgs) {
        this.compilerArgs = compilerArgs;
    }

    @Internal
    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public QuarkusDev compilerOptions(Action<CompilerOptions> action) {
        action.execute((Object)this.compilerOptions);
        return this;
    }

    @TaskAction
    public void startDev() {
        block12: {
            if (!this.getSourceDir().isDirectory()) {
                throw new GradleException("The `src/main/java` directory is required, please create it.");
            }
            if (!this.extension().outputDirectory().isDirectory()) {
                throw new GradleException("The project has no output yet, this should not happen as build should have been executed first. Does the project have any source files?");
            }
            try {
                QuarkusDevModeLauncher runner = this.newLauncher();
                String outputFile = System.getProperty(IO_QUARKUS_DEVMODE_ARGS);
                if (outputFile == null) {
                    this.getProject().exec(action -> {
                        action.commandLine((Iterable)runner.args()).workingDir((Object)this.getWorkingDir());
                        action.setStandardInput(System.in).setErrorOutput((OutputStream)System.out).setStandardOutput((OutputStream)System.out);
                    });
                    break block12;
                }
                try (BufferedWriter is = Files.newBufferedWriter(Paths.get(outputFile, new String[0]), new OpenOption[0]);){
                    for (String i : runner.args()) {
                        is.write(i);
                        is.newLine();
                    }
                }
            }
            catch (Exception e) {
                throw new GradleException("Failed to run", (Throwable)e);
            }
        }
    }

    private QuarkusDevModeLauncher newLauncher() throws Exception {
        Object toolchainSpec;
        JavaToolchainService toolChainService;
        Provider provider;
        Project project = this.getProject();
        String java = null;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.7")) >= 0 && (provider = (toolChainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class)).launcherFor((JavaToolchainSpec)(toolchainSpec = ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getToolchain()))).isPresent()) {
            java = ((JavaLauncher)provider.get()).getExecutablePath().getAsFile().getAbsolutePath();
        }
        GradleDevModeLauncher.Builder builder = (GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)GradleDevModeLauncher.builder(this.getLogger(), java).preventnoverify(this.isPreventnoverify())).projectDir(project.getProjectDir())).buildDir(this.getBuildDir())).outputDir(this.getBuildDir())).debug(System.getProperty("debug"))).debugHost(System.getProperty("debugHost"))).debugPort(System.getProperty("debugPort"))).suspend(System.getProperty("suspend"));
        if (System.getProperty(IO_QUARKUS_DEVMODE_ARGS) == null) {
            ((GradleDevModeLauncher.Builder)builder.jvmArgs("-Dquarkus.test.basic-console=true")).jvmArgs("-Dio.quarkus.force-color-support=true");
        }
        if (this.getJvmArgs() != null) {
            builder.jvmArgs(this.getJvmArgs());
        }
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            builder.buildSystemProperty((String)entry.getKey(), entry.getValue().toString());
        }
        builder.applicationName(project.getName());
        if (project.getVersion() != null) {
            builder.applicationVersion(project.getVersion().toString());
        }
        builder.sourceEncoding(this.getSourceEncoding());
        ApplicationModel appModel = this.extension().getApplicationModel(LaunchMode.DEVELOPMENT);
        HashSet<ArtifactKey> hashSet = new HashSet<ArtifactKey>();
        for (Object localDep : DependenciesFilter.getReloadableModules((ApplicationModel)appModel)) {
            this.addLocalProject((ResolvedDependency)localDep, builder, hashSet, appModel.getAppArtifact().getWorkspaceModule().getId().equals(localDep.getWorkspaceModule().getId()));
        }
        this.addQuarkusDevModeDeps(builder);
        HashSet<Path> resourceDirs = new HashSet<Path>();
        for (SourceDir resourceDir : appModel.getApplicationModule().getMainSources().getResourceDirs()) {
            resourceDirs.add(resourceDir.getOutputDir());
        }
        Set configuredParentFirst = QuarkusBootstrap.createClassLoadingConfig((PathCollection)PathsCollection.from(resourceDirs), (QuarkusBootstrap.Mode)QuarkusBootstrap.Mode.DEV, Collections.emptyList()).parentFirstArtifacts;
        HashSet parentFirstArtifactKeys = new HashSet(configuredParentFirst);
        parentFirstArtifactKeys.addAll(appModel.getParentFirst());
        for (Object artifact : appModel.getDependencies()) {
            if (hashSet.contains(artifact.getKey())) continue;
            artifact.getResolvedPaths().forEach(arg_0 -> this.lambda$newLauncher$1(parentFirstArtifactKeys, (ResolvedDependency)artifact, builder, arg_0));
        }
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPluginConvention != null) {
            builder.sourceJavaVersion(javaPluginConvention.getSourceCompatibility().toString());
            builder.targetJavaVersion(javaPluginConvention.getTargetCompatibility().toString());
        }
        for (CompilerOption compilerOptions : this.compilerOptions.getCompilerOptions()) {
            builder.compilerOptions(compilerOptions.getName(), compilerOptions.getArgs());
        }
        if (this.getCompilerArgs().isEmpty() && this.shouldPropagateJavaCompilerArgs) {
            this.getJavaCompileTask().map(compileTask -> compileTask.getOptions().getCompilerArgs()).ifPresent(args -> builder.compilerOptions("java", (List)args));
        } else {
            builder.compilerOptions("java", this.getCompilerArgs());
        }
        this.modifyDevModeContext(builder);
        Path serializedModel = ToolingUtils.serializeAppModel((ApplicationModel)appModel, (Task)this, (boolean)false);
        serializedModel.toFile().deleteOnExit();
        builder.jvmArgs("-Dquarkus-internal.serialized-app-model.path=" + serializedModel.toAbsolutePath());
        ApplicationModel testAppModel = this.extension().getApplicationModel(LaunchMode.TEST);
        Path serializedTestModel = ToolingUtils.serializeAppModel((ApplicationModel)testAppModel, (Task)this, (boolean)true);
        serializedTestModel.toFile().deleteOnExit();
        builder.jvmArgs("-Dquarkus-internal-test.serialized-app-model.path=" + serializedTestModel.toAbsolutePath());
        this.extension().outputDirectory().mkdirs();
        if (!this.args.isEmpty()) {
            builder.applicationArgs(String.join((CharSequence)" ", this.args));
        }
        return builder.build();
    }

    protected void modifyDevModeContext(GradleDevModeLauncher.Builder builder) {
    }

    private void addQuarkusDevModeDeps(GradleDevModeLauncher.Builder builder) {
        String pomPropsPath = "META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties";
        InputStream devModePomPropsIs = DevModeMain.class.getClassLoader().getResourceAsStream("META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties");
        if (devModePomPropsIs == null) {
            throw new GradleException("Failed to locate META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties on the classpath");
        }
        Properties devModeProps = new Properties();
        try (InputStream is = devModePomPropsIs;){
            devModeProps.load(is);
        }
        catch (IOException e) {
            throw new GradleException("Failed to load META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties from the classpath", (Throwable)e);
        }
        String devModeGroupId = devModeProps.getProperty("groupId");
        if (devModeGroupId == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties is missing groupId");
        }
        String devModeArtifactId = devModeProps.getProperty("artifactId");
        if (devModeArtifactId == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties is missing artifactId");
        }
        String devModeVersion = devModeProps.getProperty("version");
        if (devModeVersion == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-core-deployment/pom.properties is missing version");
        }
        Dependency devModeDependency = this.getProject().getDependencies().create((Object)String.format("%s:%s:%s", devModeGroupId, devModeArtifactId, devModeVersion));
        Configuration devModeDependencyConfiguration = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{devModeDependency});
        for (ResolvedArtifact appDep : devModeDependencyConfiguration.getResolvedConfiguration().getResolvedArtifacts()) {
            ModuleVersionIdentifier artifactId = appDep.getModuleVersion().getId();
            if (artifactId.getGroup().equals("io.quarkus") && artifactId.getName().equals("quarkus-ide-launcher")) continue;
            if (artifactId.getGroup().equals("io.quarkus") && artifactId.getName().equals("quarkus-class-change-agent")) {
                builder.jvmArgs("-javaagent:" + appDep.getFile().getAbsolutePath());
                continue;
            }
            builder.classpathEntry(appDep.getFile());
        }
    }

    private void addLocalProject(ResolvedDependency project, GradleDevModeLauncher.Builder builder, Set<ArtifactKey> addeDeps, boolean root) {
        String resourcesOutputPath;
        addeDeps.add(project.getKey());
        ArtifactSources sources = project.getSources();
        if (sources == null) {
            return;
        }
        LinkedHashSet<Path> sourcePaths = new LinkedHashSet<Path>();
        LinkedHashSet<Path> sourceParentPaths = new LinkedHashSet<Path>();
        HashSet<Path> classesDirs = new HashSet<Path>(sources.getSourceDirs().size());
        for (SourceDir src : sources.getSourceDirs()) {
            if (!Files.exists(src.getDir(), new LinkOption[0])) continue;
            sourcePaths.add(src.getDir());
            sourceParentPaths.add(src.getDir().getParent());
            if (src.getOutputDir() == null) continue;
            classesDirs.add(src.getOutputDir());
        }
        Path classesDir = classesDirs.isEmpty() ? null : QuarkusGradleUtils.mergeClassesDirs(classesDirs, project.getWorkspaceModule().getBuildDir(), root, root);
        LinkedHashSet<Path> resourcesSrcDirs = new LinkedHashSet<Path>();
        Path resourcesOutputDir = null;
        for (SourceDir resource : sources.getResourceDirs()) {
            resourcesSrcDirs.add(resource.getDir());
            if (resourcesOutputDir != null) continue;
            resourcesOutputDir = resource.getOutputDir();
        }
        if (sourcePaths.isEmpty() && (resourcesOutputDir == null || !Files.exists(resourcesOutputDir, new LinkOption[0])) || classesDir == null) {
            return;
        }
        if (resourcesOutputDir != null && Files.exists(resourcesOutputDir, new LinkOption[0])) {
            resourcesOutputPath = resourcesOutputDir.toString();
            if (!Files.exists(classesDir, new LinkOption[0])) {
                classesDir = resourcesOutputDir;
            }
        } else {
            resourcesOutputPath = classesDir.toString();
        }
        DevModeContext.ModuleInfo.Builder moduleBuilder = new DevModeContext.ModuleInfo.Builder().setArtifactKey(project.getKey()).setName(project.getArtifactId()).setProjectDirectory(project.getWorkspaceModule().getModuleDir().getAbsolutePath()).setSourcePaths((PathCollection)PathList.from(sourcePaths)).setClassesPath(classesDir.toString()).setResourcePaths((PathCollection)PathList.from(resourcesSrcDirs)).setResourcesOutputPath(resourcesOutputPath).setSourceParents((PathCollection)PathList.from(sourceParentPaths)).setPreBuildOutputDir(project.getWorkspaceModule().getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(project.getWorkspaceModule().getBuildDir().toString());
        ArtifactSources testSources = project.getWorkspaceModule().getTestSources();
        if (testSources != null) {
            LinkedHashSet<Path> testSourcePaths = new LinkedHashSet<Path>();
            LinkedHashSet<Path> testSourceParentPaths = new LinkedHashSet<Path>();
            HashSet<Path> testClassesDirs = new HashSet<Path>(testSources.getSourceDirs().size());
            for (SourceDir src : testSources.getSourceDirs()) {
                if (!Files.exists(src.getDir(), new LinkOption[0])) continue;
                testSourcePaths.add(src.getDir());
                testSourceParentPaths.add(src.getDir().getParent());
                if (src.getOutputDir() == null) continue;
                testClassesDirs.add(src.getOutputDir());
            }
            Path testClassesDir = testClassesDirs.isEmpty() ? null : QuarkusGradleUtils.mergeClassesDirs(testClassesDirs, project.getWorkspaceModule().getBuildDir(), root, root);
            LinkedHashSet<Path> testResourcesSrcDirs = new LinkedHashSet<Path>();
            Path testResourcesOutputDir = null;
            for (SourceDir resource : testSources.getResourceDirs()) {
                testResourcesSrcDirs.add(resource.getDir());
                if (testResourcesOutputDir != null) continue;
                testResourcesOutputDir = resource.getOutputDir();
            }
            if (testClassesDir != null && (!testSourcePaths.isEmpty() || testResourcesOutputDir != null && Files.exists(testResourcesOutputDir, new LinkOption[0]))) {
                String testResourcesOutputPath;
                if (testResourcesOutputDir != null && Files.exists(testResourcesOutputDir, new LinkOption[0])) {
                    testResourcesOutputPath = testResourcesOutputDir.toString();
                    if (!Files.exists(testClassesDir, new LinkOption[0])) {
                        testClassesDir = testResourcesOutputDir;
                    }
                } else {
                    testResourcesOutputPath = testClassesDir.toString();
                }
                moduleBuilder.setTestSourcePaths((PathCollection)PathList.from(testSourcePaths)).setTestClassesPath(testClassesDir.toString()).setTestResourcePaths((PathCollection)PathList.from(testResourcesSrcDirs)).setTestResourcesOutputPath(testResourcesOutputPath);
            }
        }
        DevModeContext.ModuleInfo wsModuleInfo = moduleBuilder.build();
        if (root) {
            builder.mainModule(wsModuleInfo);
        } else {
            builder.dependency(wsModuleInfo);
        }
    }

    private String getSourceEncoding() {
        return this.getJavaCompileTask().map(javaCompile -> javaCompile.getOptions().getEncoding()).orElse(null);
    }

    private java.util.Optional<JavaCompile> getJavaCompileTask() {
        return java.util.Optional.ofNullable((JavaCompile)this.getProject().getTasks().getByName("compileJava"));
    }

    public void shouldPropagateJavaCompilerArgs(boolean shouldPropagateJavaCompilerArgs) {
        this.shouldPropagateJavaCompilerArgs = shouldPropagateJavaCompilerArgs;
    }

    private /* synthetic */ void lambda$newLauncher$1(Set parentFirstArtifactKeys, ResolvedDependency artifact, GradleDevModeLauncher.Builder builder, Path p) {
        File file = p.toFile();
        if (file.exists() && parentFirstArtifactKeys.contains(artifact.getKey()) && this.filesIncludedInClasspath.add(file)) {
            this.getProject().getLogger().debug("Adding dependency {}", (Object)file);
            builder.classpathEntry(file);
        }
    }
}

