/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.extension.SourceSetExtension;
import io.quarkus.gradle.tasks.QuarkusAddExtension;
import io.quarkus.gradle.tasks.QuarkusBuild;
import io.quarkus.gradle.tasks.QuarkusDev;
import io.quarkus.gradle.tasks.QuarkusGenerateCode;
import io.quarkus.gradle.tasks.QuarkusGoOffline;
import io.quarkus.gradle.tasks.QuarkusInfo;
import io.quarkus.gradle.tasks.QuarkusListCategories;
import io.quarkus.gradle.tasks.QuarkusListExtensions;
import io.quarkus.gradle.tasks.QuarkusListPlatforms;
import io.quarkus.gradle.tasks.QuarkusRemoteDev;
import io.quarkus.gradle.tasks.QuarkusRemoveExtension;
import io.quarkus.gradle.tasks.QuarkusTest;
import io.quarkus.gradle.tasks.QuarkusTestConfig;
import io.quarkus.gradle.tasks.QuarkusUpdate;
import io.quarkus.gradle.tooling.GradleApplicationModelBuilder;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.util.GradleVersion;

public class QuarkusPlugin
implements Plugin<Project> {
    public static final String ID = "io.quarkus";
    public static final String QUARKUS_PACKAGE_TYPE = "quarkus.package.type";
    public static final String EXTENSION_NAME = "quarkus";
    public static final String LIST_EXTENSIONS_TASK_NAME = "listExtensions";
    public static final String LIST_CATEGORIES_TASK_NAME = "listCategories";
    public static final String LIST_PLATFORMS_TASK_NAME = "listPlatforms";
    public static final String ADD_EXTENSION_TASK_NAME = "addExtension";
    public static final String REMOVE_EXTENSION_TASK_NAME = "removeExtension";
    public static final String QUARKUS_GENERATE_CODE_TASK_NAME = "quarkusGenerateCode";
    public static final String QUARKUS_GENERATE_CODE_DEV_TASK_NAME = "quarkusGenerateCodeDev";
    public static final String QUARKUS_GENERATE_CODE_TESTS_TASK_NAME = "quarkusGenerateCodeTests";
    public static final String QUARKUS_BUILD_TASK_NAME = "quarkusBuild";
    public static final String QUARKUS_DEV_TASK_NAME = "quarkusDev";
    public static final String QUARKUS_REMOTE_DEV_TASK_NAME = "quarkusRemoteDev";
    public static final String QUARKUS_TEST_TASK_NAME = "quarkusTest";
    public static final String QUARKUS_GO_OFFLINE_TASK_NAME = "quarkusGoOffline";
    public static final String QUARKUS_INFO_TASK_NAME = "quarkusInfo";
    public static final String QUARKUS_UPDATE_TASK_NAME = "quarkusUpdate";
    @Deprecated
    public static final String BUILD_NATIVE_TASK_NAME = "buildNative";
    public static final String TEST_NATIVE_TASK_NAME = "testNative";
    @Deprecated
    public static final String QUARKUS_TEST_CONFIG_TASK_NAME = "quarkusTestConfig";
    public static final String NATIVE_TEST_SOURCE_SET_NAME = "native-test";
    public static final String NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "nativeTestImplementation";
    public static final String NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "nativeTestRuntimeOnly";
    public static final String INTEGRATION_TEST_TASK_NAME = "quarkusIntTest";
    public static final String INTEGRATION_TEST_SOURCE_SET_NAME = "integrationTest";
    public static final String INTEGRATION_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "integrationTestImplementation";
    public static final String INTEGRATION_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "integrationTestRuntimeOnly";
    private final ToolingModelBuilderRegistry registry;

    @Inject
    public QuarkusPlugin(ToolingModelBuilderRegistry registry) {
        this.registry = registry;
    }

    public void apply(Project project) {
        this.verifyGradleVersion();
        this.registerModel();
        QuarkusPluginExtension quarkusExt = (QuarkusPluginExtension)project.getExtensions().create(EXTENSION_NAME, QuarkusPluginExtension.class, new Object[]{project});
        project.getPluginManager().apply(JavaPlugin.class);
        this.registerTasks(project, quarkusExt);
    }

    private void registerTasks(Project project, final QuarkusPluginExtension quarkusExt) {
        TaskContainer tasks = project.getTasks();
        tasks.register(LIST_EXTENSIONS_TASK_NAME, QuarkusListExtensions.class);
        tasks.register(LIST_CATEGORIES_TASK_NAME, QuarkusListCategories.class);
        tasks.register(LIST_PLATFORMS_TASK_NAME, QuarkusListPlatforms.class);
        tasks.register(ADD_EXTENSION_TASK_NAME, QuarkusAddExtension.class);
        tasks.register(REMOVE_EXTENSION_TASK_NAME, QuarkusRemoveExtension.class);
        tasks.register(QUARKUS_INFO_TASK_NAME, QuarkusInfo.class);
        tasks.register(QUARKUS_UPDATE_TASK_NAME, QuarkusUpdate.class);
        tasks.register(QUARKUS_GO_OFFLINE_TASK_NAME, QuarkusGoOffline.class, task -> {
            task.setCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.NORMAL)));
            task.setTestCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.TEST)));
            task.setQuarkusDevClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT)));
        });
        TaskProvider quarkusGenerateCode = tasks.register(QUARKUS_GENERATE_CODE_TASK_NAME, QuarkusGenerateCode.class);
        TaskProvider quarkusGenerateCodeDev = tasks.register(QUARKUS_GENERATE_CODE_DEV_TASK_NAME, QuarkusGenerateCode.class, task -> task.setDevMode(true));
        TaskProvider quarkusGenerateCodeTests = tasks.register(QUARKUS_GENERATE_CODE_TESTS_TASK_NAME, QuarkusGenerateCode.class, task -> task.setTest(true));
        TaskProvider quarkusBuild = tasks.register(QUARKUS_BUILD_TASK_NAME, QuarkusBuild.class, build -> build.dependsOn(new Object[]{quarkusGenerateCode}));
        TaskProvider quarkusDev = tasks.register(QUARKUS_DEV_TASK_NAME, QuarkusDev.class);
        TaskProvider quarkusRemoteDev = tasks.register(QUARKUS_REMOTE_DEV_TASK_NAME, QuarkusRemoteDev.class);
        TaskProvider quarkusTest = tasks.register(QUARKUS_TEST_TASK_NAME, QuarkusTest.class);
        tasks.register(QUARKUS_TEST_CONFIG_TASK_NAME, QuarkusTestConfig.class);
        tasks.register(BUILD_NATIVE_TASK_NAME, DefaultTask.class, task -> {
            task.finalizedBy(new Object[]{quarkusBuild});
            task.doFirst(t -> project.getLogger().warn("The 'buildNative' task has been deprecated in favor of 'build -Dquarkus.package.type=native'"));
        });
        this.configureBuildNativeTask(project);
        Consumer<Test> configureTestTask = t -> {
            t.doFirst((Action)new Action<Task>(){

                public void execute(Task test) {
                    quarkusExt.beforeTest(t);
                }
            });
            t.useJUnitPlatform();
            quarkusBuild.configure(task -> task.shouldRunAfter(new Object[]{t}));
        };
        project.getPlugins().withType(BasePlugin.class, basePlugin -> tasks.getByName("assemble").dependsOn(new Object[]{quarkusBuild}));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            this.createConfigurations(project);
            project.afterEvaluate(this::afterEvaluate);
            tasks.named("compileJava", JavaCompile.class, compileJava -> {
                compileJava.mustRunAfter(new Object[]{quarkusGenerateCode});
                compileJava.mustRunAfter(new Object[]{quarkusGenerateCodeDev});
            });
            tasks.named("compileTestJava", JavaCompile.class, compileTestJava -> {
                compileTestJava.dependsOn(new Object[]{quarkusGenerateCode});
                compileTestJava.dependsOn(new Object[]{quarkusGenerateCodeTests});
                if (project.getGradle().getStartParameter().getTaskNames().contains(QUARKUS_DEV_TASK_NAME)) {
                    compileTestJava.getOptions().setFailOnError(false);
                }
            });
            TaskProvider classesTask = tasks.named("classes");
            TaskProvider resourcesTask = tasks.named("processResources");
            TaskProvider testClassesTask = tasks.named("testClasses");
            TaskProvider testResourcesTask = tasks.named("processTestResources");
            quarkusGenerateCode.configure(task -> {
                task.dependsOn(new Object[]{resourcesTask});
                task.setCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.NORMAL)));
            });
            quarkusGenerateCodeDev.configure(task -> {
                task.dependsOn(new Object[]{resourcesTask});
                task.setCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT)));
            });
            quarkusGenerateCodeTests.configure(task -> {
                task.dependsOn(new Object[]{resourcesTask});
                task.setCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.TEST)));
            });
            quarkusDev.configure(task -> {
                task.dependsOn(new Object[]{classesTask, resourcesTask, testClassesTask, testResourcesTask, quarkusGenerateCodeDev, quarkusGenerateCodeTests});
                task.setQuarkusDevConfiguration(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT)));
            });
            quarkusRemoteDev.configure(task -> {
                task.dependsOn(new Object[]{classesTask, resourcesTask});
                task.setQuarkusDevConfiguration(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT)));
            });
            quarkusTest.configure(task -> {
                task.dependsOn(new Object[]{classesTask, resourcesTask, testClassesTask, testResourcesTask, quarkusGenerateCode, quarkusGenerateCodeTests});
                task.setQuarkusDevConfiguration(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT)));
            });
            quarkusBuild.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask, tasks.named("jar")}));
            SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
            quarkusGenerateCode.configure(task -> task.setSourcesDirectories(this.getSourcesParents(mainSourceSet)));
            quarkusGenerateCodeDev.configure(task -> task.setSourcesDirectories(this.getSourcesParents(mainSourceSet)));
            quarkusGenerateCodeTests.configure(task -> task.setSourcesDirectories(this.getSourcesParents(testSourceSet)));
            SourceSet intTestSourceSet = (SourceSet)sourceSets.create(INTEGRATION_TEST_SOURCE_SET_NAME);
            intTestSourceSet.setCompileClasspath(intTestSourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            intTestSourceSet.setRuntimeClasspath(intTestSourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            tasks.register(INTEGRATION_TEST_TASK_NAME, Test.class, intTestTask -> {
                intTestTask.setGroup("verification");
                intTestTask.setDescription("Runs Quarkus integration tests");
                intTestTask.dependsOn(new Object[]{quarkusBuild, tasks.named("test")});
                intTestTask.setClasspath(intTestSourceSet.getRuntimeClasspath());
                intTestTask.setTestClassesDirs(intTestSourceSet.getOutput().getClassesDirs());
            });
            SourceSet nativeTestSourceSet = (SourceSet)sourceSets.create(NATIVE_TEST_SOURCE_SET_NAME);
            nativeTestSourceSet.setCompileClasspath(nativeTestSourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)intTestSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            nativeTestSourceSet.setRuntimeClasspath(nativeTestSourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)intTestSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            tasks.register(TEST_NATIVE_TASK_NAME, Test.class, testNative -> {
                testNative.setDescription("Runs native image tests");
                testNative.setGroup("verification");
                testNative.dependsOn(new Object[]{quarkusBuild, tasks.named("test")});
                testNative.setTestClassesDirs((FileCollection)project.files(new Object[]{nativeTestSourceSet.getOutput().getClassesDirs(), intTestSourceSet.getOutput().getClassesDirs()}));
                testNative.setClasspath(nativeTestSourceSet.getRuntimeClasspath());
            });
            tasks.withType(Test.class).forEach(configureTestTask);
            tasks.withType(Test.class).whenTaskAdded(configureTestTask::accept);
            SourceSet generatedSourceSet = (SourceSet)sourceSets.create("quarkus-generated-sources");
            SourceSet generatedTestSourceSet = (SourceSet)sourceSets.create("quarkus-test-generated-sources");
            for (String provider : QuarkusGenerateCode.CODE_GENERATION_PROVIDER) {
                mainSourceSet.getJava().srcDir((Object)new File(((Directory)generatedSourceSet.getJava().getClassesDirectory().get()).getAsFile(), provider));
                testSourceSet.getJava().srcDir((Object)new File(((Directory)generatedTestSourceSet.getJava().getClassesDirectory().get()).getAsFile(), provider));
            }
        });
        project.getPlugins().withId("org.jetbrains.kotlin.jvm", plugin -> {
            quarkusDev.configure(task -> task.shouldPropagateJavaCompilerArgs(false));
            tasks.named("compileKotlin", task -> {
                task.mustRunAfter(new Object[]{quarkusGenerateCode});
                task.mustRunAfter(new Object[]{quarkusGenerateCodeDev});
            });
            tasks.named("compileTestKotlin", task -> task.dependsOn(new Object[]{quarkusGenerateCodeTests}));
        });
    }

    private void createConfigurations(Project project) {
        ConfigurationContainer configContainer = project.getConfigurations();
        ((Configuration)configContainer.maybeCreate(NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testImplementation")});
        ((Configuration)configContainer.maybeCreate(NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testRuntimeOnly")});
        ((Configuration)configContainer.maybeCreate(INTEGRATION_TEST_IMPLEMENTATION_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testImplementation")});
        ((Configuration)configContainer.maybeCreate(INTEGRATION_TEST_RUNTIME_ONLY_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testRuntimeOnly")});
        ApplicationDeploymentClasspathBuilder.initConfigurations((Project)project);
    }

    private Set<Path> getSourcesParents(SourceSet mainSourceSet) {
        Set srcDirs = mainSourceSet.getJava().getSrcDirs();
        return srcDirs.stream().map(File::toPath).map(Path::getParent).collect(Collectors.toSet());
    }

    private void registerModel() {
        this.registry.register((ToolingModelBuilder)new GradleApplicationModelBuilder());
    }

    private void verifyGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) < 0) {
            throw new GradleException("Quarkus plugin requires Gradle 6.1 or later. Current version is: " + GradleVersion.current());
        }
    }

    private void configureBuildNativeTask(Project project) {
        project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(project.getPath() + BUILD_NATIVE_TASK_NAME) || taskGraph.hasTask(project.getPath() + TEST_NATIVE_TASK_NAME)) {
                project.getExtensions().getExtraProperties().set(QUARKUS_PACKAGE_TYPE, (Object)"native");
            }
        });
    }

    private void afterEvaluate(Project project) {
        this.visitProjectDependencies(project, project, new HashSet<String>());
        ConfigurationContainer configurations = project.getConfigurations();
        SourceSetExtension sourceSetExtension = ((QuarkusPluginExtension)project.getExtensions().getByType(QuarkusPluginExtension.class)).sourceSetExtension();
        if (sourceSetExtension.extraNativeTest() != null) {
            SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            SourceSet nativeTestSourceSets = (SourceSet)sourceSets.getByName(NATIVE_TEST_SOURCE_SET_NAME);
            nativeTestSourceSets.setCompileClasspath(nativeTestSourceSets.getCompileClasspath().plus((FileCollection)((SourceSet)sourceSets.getByName(INTEGRATION_TEST_SOURCE_SET_NAME)).getOutput()).plus((FileCollection)sourceSetExtension.extraNativeTest().getOutput()));
            nativeTestSourceSets.setRuntimeClasspath(nativeTestSourceSets.getRuntimeClasspath().plus((FileCollection)((SourceSet)sourceSets.getByName(INTEGRATION_TEST_SOURCE_SET_NAME)).getOutput()).plus((FileCollection)sourceSetExtension.extraNativeTest().getOutput()));
            ((Configuration)configurations.findByName(NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configurations.findByName(sourceSetExtension.extraNativeTest().getImplementationConfigurationName())});
            ((Configuration)configurations.findByName(NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configurations.findByName(sourceSetExtension.extraNativeTest().getRuntimeOnlyConfigurationName())});
        }
    }

    private void visitProjectDep(Project project, Project dep, Set<String> visited) {
        if (dep.getState().getExecuted()) {
            this.setupQuarkusBuildTaskDeps(project, dep, visited);
        } else {
            dep.afterEvaluate(p -> this.setupQuarkusBuildTaskDeps(project, (Project)p, visited));
        }
    }

    private void setupQuarkusBuildTaskDeps(Project project, Project dep, Set<String> visited) {
        TaskProvider<Task> quarkusDev;
        TaskProvider<Task> jarTask;
        if (!visited.add(dep.getPath())) {
            return;
        }
        project.getLogger().debug("Configuring {} task dependencies on {} tasks", (Object)project, (Object)dep);
        TaskProvider<Task> quarkusBuild = this.getLazyTaskOrNull(project, QUARKUS_BUILD_TASK_NAME);
        if (quarkusBuild != null && (jarTask = this.getLazyTaskOrNull(dep, "jar")) != null) {
            TaskProvider<Task> quarkusPrepare = this.getLazyTaskOrNull(project, QUARKUS_GENERATE_CODE_TASK_NAME);
            TaskProvider<Task> quarkusPrepareDev = this.getLazyTaskOrNull(project, QUARKUS_GENERATE_CODE_DEV_TASK_NAME);
            TaskProvider<Task> quarkusPrepareTests = this.getLazyTaskOrNull(project, QUARKUS_GENERATE_CODE_TESTS_TASK_NAME);
            quarkusBuild.configure(task -> task.dependsOn(new Object[]{jarTask}));
            if (quarkusPrepare != null) {
                quarkusPrepare.configure(task -> task.dependsOn(new Object[]{jarTask}));
            }
            if (quarkusPrepareDev != null) {
                quarkusPrepareDev.configure(task -> task.dependsOn(new Object[]{jarTask}));
            }
            if (quarkusPrepareTests != null) {
                quarkusPrepareTests.configure(task -> task.dependsOn(new Object[]{jarTask}));
            }
        }
        if ((quarkusDev = this.getLazyTaskOrNull(project, QUARKUS_DEV_TASK_NAME)) != null) {
            TaskProvider<Task> resourcesTaskJandex;
            TaskProvider<Task> resourcesTask = this.getLazyTaskOrNull(dep, "processResources");
            if (resourcesTask != null) {
                quarkusDev.configure(task -> task.dependsOn(new Object[]{resourcesTask}));
            }
            if ((resourcesTaskJandex = this.getLazyTaskOrNull(dep, "jandex")) != null) {
                quarkusDev.configure(task -> task.dependsOn(new Object[]{resourcesTaskJandex}));
            }
        }
        this.visitProjectDependencies(project, dep, visited);
    }

    protected void visitProjectDependencies(Project project, Project dep, Set<String> visited) {
        Configuration compileConfig = (Configuration)dep.getConfigurations().findByName("compileClasspath");
        if (compileConfig != null) {
            Configuration compilePlusRuntimeConfig = dep.getConfigurations().detachedConfiguration(new Dependency[0]).extendsFrom(new Configuration[]{compileConfig});
            Configuration runtimeOnlyConfig = (Configuration)dep.getConfigurations().findByName("runtimeOnly");
            if (runtimeOnlyConfig != null) {
                compilePlusRuntimeConfig.extendsFrom(new Configuration[]{runtimeOnlyConfig});
            }
            compilePlusRuntimeConfig.getIncoming().getDependencies().forEach(d -> {
                if (d instanceof ProjectDependency) {
                    this.visitProjectDep(project, ((ProjectDependency)d).getDependencyProject(), visited);
                }
            });
        }
    }

    private TaskProvider<Task> getLazyTaskOrNull(Project project, String name) {
        try {
            return project.getTasks().named(name);
        }
        catch (UnknownTaskException e) {
            return null;
        }
    }
}

