/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.handlers.UpdateCommandHandler;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import io.quarkus.registry.RegistryResolutionException;
import java.util.HashMap;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusUpdate
extends QuarkusPlatformTask {
    private boolean perModule = false;
    private boolean recommendedState = false;
    private boolean rectify = false;

    @Input
    public boolean getPerModule() {
        return this.perModule;
    }

    @Option(description="Log project's state per module.", option="perModule")
    public void setPerModule(boolean perModule) {
        this.perModule = perModule;
    }

    @Input
    public boolean getRecommendedState() {
        return this.recommendedState;
    }

    @Option(description="Log the new recommended project state.", option="recommendedState")
    public void setRecommendedState(boolean recommendedState) {
        this.recommendedState = recommendedState;
    }

    @Input
    public boolean getRectify() {
        return this.rectify;
    }

    @Option(description="Log the rectified state of the current project according to the recommendations based on the currently enforced Quarkus platforms.", option="rectify")
    public void setRectify(boolean rectify) {
        this.rectify = rectify;
    }

    public QuarkusUpdate() {
        super("Log Quarkus-specific recommended project updates, such as the new Quarkus platform BOM versions, new versions of Quarkus extensions that aren't managed by the Quarkus BOMs, etc");
    }

    @TaskAction
    public void logUpdates() {
        this.getProject().getLogger().warn(this.getName() + " is experimental, its options and output might change in future versions");
        QuarkusProject quarkusProject = this.getQuarkusProject(false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            params.put("latest-catalog", this.getExtensionCatalogResolver(quarkusProject.log()).resolveExtensionCatalog());
        }
        catch (RegistryResolutionException e) {
            throw new GradleException("Failed to resolve the latest Quarkus extension catalog from the configured extension registries", (Throwable)e);
        }
        params.put("app-model", this.extension().getApplicationModel());
        params.put("log-state-per-module", this.perModule);
        params.put("log-recommended-state", this.recommendedState);
        params.put("rectify", this.rectify);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(quarkusProject, params);
        try {
            new UpdateCommandHandler().execute(invocation);
        }
        catch (Exception e) {
            throw new GradleException("Failed to resolve recommended updates", (Throwable)e);
        }
    }
}

