/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.extension;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.gradle.AppModelGradleResolver;
import io.quarkus.gradle.extension.SourceSetExtension;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.testing.Test;
import org.gradle.jvm.tasks.Jar;

public class QuarkusPluginExtension {
    private final Project project;
    private final Property<String> finalName;
    private final MapProperty<String, String> quarkusBuildProperties;
    private final SourceSetExtension sourceSetExtension;

    public QuarkusPluginExtension(Project project) {
        this.project = project;
        this.finalName = project.getObjects().property(String.class);
        this.finalName.convention(project.provider(() -> String.format("%s-%s", project.getName(), project.getVersion())));
        this.sourceSetExtension = new SourceSetExtension();
        this.quarkusBuildProperties = project.getObjects().mapProperty(String.class, String.class);
    }

    public void beforeTest(Test task) {
        try {
            Map props = task.getSystemProperties();
            ApplicationModel appModel = this.getApplicationModel(LaunchMode.TEST);
            Path serializedModel = ToolingUtils.serializeAppModel((ApplicationModel)appModel, (Task)task, (boolean)true);
            props.put("quarkus-internal-test.serialized-app-model.path", serializedModel.toString());
            StringJoiner outputSourcesDir = new StringJoiner(",");
            for (File outputSourceDir : this.combinedOutputSourceDirs()) {
                outputSourcesDir.add(outputSourceDir.getAbsolutePath());
            }
            props.put("OUTPUT_SOURCES_DIR", outputSourcesDir.toString());
            SourceSetContainer sourceSets = (SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            File outputDirectoryAsFile = QuarkusPluginExtension.getLastFile(mainSourceSet.getOutput().getClassesDirs());
            String fileList = this.getSourceSets().stream().filter(sourceSet -> Objects.equals(task.getTestClassesDirs().getAsPath(), sourceSet.getOutput().getClassesDirs().getAsPath())).flatMap(sourceSet -> sourceSet.getOutput().getClassesDirs().getFiles().stream()).filter(File::exists).distinct().map(testSrcDir -> String.format("%s:%s", this.project.relativePath(testSrcDir), this.project.relativePath((Object)outputDirectoryAsFile))).collect(Collectors.joining(","));
            task.environment("TEST_TO_MAIN_MAPPINGS", (Object)fileList);
            this.project.getLogger().debug("test dir mapping - {}", (Object)fileList);
            String nativeRunner = task.getProject().getBuildDir().toPath().resolve(this.buildNativeRunnerName(props)).toAbsolutePath().toString();
            props.put("native.image.path", nativeRunner);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to resolve deployment classpath", e);
        }
    }

    public String buildNativeRunnerName(Map<String, Object> taskSystemProps) {
        Properties properties = new Properties(taskSystemProps.size());
        properties.putAll(taskSystemProps);
        ((Map)this.quarkusBuildProperties.get()).entrySet().forEach(buildEntry -> properties.putIfAbsent(buildEntry.getKey(), buildEntry.getValue()));
        System.getProperties().entrySet().forEach(propEntry -> properties.putIfAbsent(propEntry.getKey(), propEntry.getValue()));
        System.getenv().entrySet().forEach(envEntry -> properties.putIfAbsent(envEntry.getKey(), envEntry.getValue()));
        StringBuilder nativeRunnerName = new StringBuilder();
        if (properties.containsKey("quarkus.package.output-name")) {
            nativeRunnerName.append(properties.get("quarkus.package.output-name"));
        } else {
            nativeRunnerName.append(this.finalName());
        }
        if (!properties.containsKey("quarkus.package.add-runner-suffix") || properties.containsKey("quarkus.package.add-runner-suffix") && Boolean.parseBoolean((String)properties.get("quarkus.package.add-runner-suffix"))) {
            nativeRunnerName.append("-runner");
        }
        return nativeRunnerName.toString();
    }

    public Property<String> getFinalName() {
        return this.finalName;
    }

    public String finalName() {
        return (String)this.getFinalName().get();
    }

    public void setFinalName(String finalName) {
        this.getFinalName().set((Object)finalName);
    }

    public void sourceSets(Action<? super SourceSetExtension> action) {
        action.execute((Object)this.sourceSetExtension);
    }

    public SourceSetExtension sourceSetExtension() {
        return this.sourceSetExtension;
    }

    public Set<File> resourcesDir() {
        return ((SourceSet)this.getSourceSets().getByName("main")).getResources().getSrcDirs();
    }

    public Set<File> combinedOutputSourceDirs() {
        LinkedHashSet<File> sourcesDirs = new LinkedHashSet<File>();
        sourcesDirs.addAll(((SourceSet)this.getSourceSets().getByName("main")).getOutput().getClassesDirs().getFiles());
        sourcesDirs.addAll(((SourceSet)this.getSourceSets().getByName("test")).getOutput().getClassesDirs().getFiles());
        return sourcesDirs;
    }

    public AppModelResolver getAppModelResolver() {
        return this.getAppModelResolver(LaunchMode.NORMAL);
    }

    public AppModelResolver getAppModelResolver(LaunchMode mode) {
        return new AppModelGradleResolver(this.project, mode);
    }

    public ApplicationModel getApplicationModel() {
        return this.getApplicationModel(LaunchMode.NORMAL);
    }

    public ApplicationModel getApplicationModel(LaunchMode mode) {
        return ToolingUtils.create((Project)this.project, (LaunchMode)mode);
    }

    public static File getLastFile(FileCollection fileCollection) {
        File result = null;
        for (File f : fileCollection) {
            if (result != null && !f.exists()) continue;
            result = f;
        }
        return result;
    }

    private SourceSetContainer getSourceSets() {
        return (SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class);
    }

    public Path appJarOrClasses() {
        SourceSet mainSourceSet;
        String classesPath;
        File f;
        Jar jarTask = (Jar)this.project.getTasks().findByName("jar");
        if (jarTask == null) {
            throw new RuntimeException("Failed to locate task 'jar' in the project.");
        }
        Provider jarProvider = jarTask.getArchiveFile();
        Path classesDir = null;
        if (jarProvider.isPresent() && (f = ((RegularFile)jarProvider.get()).getAsFile()).exists()) {
            classesDir = f.toPath();
        }
        if (classesDir == null && (classesPath = QuarkusGradleUtils.getClassesDir(mainSourceSet = (SourceSet)this.getSourceSets().getByName("main"), jarTask.getTemporaryDir(), false)) != null) {
            classesDir = Paths.get(classesPath, new String[0]);
        }
        if (classesDir == null) {
            throw new RuntimeException("Failed to locate project's classes directory");
        }
        return classesDir;
    }

    public MapProperty<String, String> getQuarkusBuildProperties() {
        return this.quarkusBuildProperties;
    }

    public void set(String name, @Nullable String value) {
        this.quarkusBuildProperties.put((Object)String.format("quarkus.%s", name), (Object)value);
    }

    public void set(String name, Property<String> value) {
        this.quarkusBuildProperties.put((Object)String.format("quarkus.%s", name), value);
    }
}

