/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.GradleLogger;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.DefaultTask;

public abstract class QuarkusTask
extends DefaultTask {
    private QuarkusPluginExtension extension;

    QuarkusTask(String description) {
        GradleLogger.logSupplier = () -> ((QuarkusTask)this).getLogger();
        this.setDescription(description);
        this.setGroup("quarkus");
    }

    QuarkusPluginExtension extension() {
        if (this.extension == null) {
            this.extension = (QuarkusPluginExtension)this.getProject().getExtensions().findByType(QuarkusPluginExtension.class);
        }
        return this.extension;
    }

    protected Properties getBuildSystemProperties(ResolvedDependency appArtifact) {
        Map properties = this.getProject().getProperties();
        Properties realProperties = new Properties();
        for (Map.Entry entry2 : properties.entrySet()) {
            String key = (String)entry2.getKey();
            Object value = entry2.getValue();
            if (key == null || !(value instanceof String) || !key.startsWith("quarkus.")) continue;
            realProperties.setProperty(key, (String)value);
        }
        if (!this.extension().getQuarkusBuildProperties().isEmpty()) {
            this.extension().getQuarkusBuildProperties().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("quarkus.")).forEach(entry -> realProperties.put(entry.getKey(), entry.getValue()));
        }
        realProperties.putIfAbsent("quarkus.application.name", appArtifact.getArtifactId());
        realProperties.putIfAbsent("quarkus.application.version", appArtifact.getVersion());
        return realProperties;
    }
}

