/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.ListCategories;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.gradle.tasks.GradleMessageWriter;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusListCategories
extends QuarkusPlatformTask {
    private static final String DEFAULT_FORMAT = "concise";
    private boolean fromCli = false;
    private String format = "concise";

    @Input
    public boolean isFromCli() {
        return this.fromCli;
    }

    @Option(description="Indicates that a task is run from the Quarkus CLI.", option="fromCli")
    public void setFromCli(boolean fromCli) {
        this.fromCli = fromCli;
    }

    @Optional
    @Input
    public String getFormat() {
        return this.format;
    }

    @Option(description="Select the output format among 'id' (display the categoryId only), 'concise' (display name and categoryId) and 'full' (name, categoryId and description columns).", option="format")
    public void setFormat(String format) {
        this.format = format;
    }

    public QuarkusListCategories() {
        super("Lists quarkus extensions categories");
    }

    @TaskAction
    public void listCategories() {
        try {
            QuarkusProject quarkusProject = this.getQuarkusProject(false);
            ListCategories listExtensions = new ListCategories(quarkusProject).fromCli(this.isFromCli()).format(this.getFormat());
            listExtensions.execute();
            if (!this.fromCli) {
                GradleMessageWriter log = this.messageWriter();
                if (DEFAULT_FORMAT.equalsIgnoreCase(this.format)) {
                    log.info("");
                    log.info("To get more information, append `%s` to your command line.", new Object[]{"--format=full"});
                }
                log.info("");
                log.info("To list extensions in given category, use:\n%s", new Object[]{"`./gradlew listExtensions --category=\"categoryId\"`"});
            }
        }
        catch (Exception e) {
            throw new GradleException("Unable to list extension categories", (Throwable)e);
        }
    }
}

