/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.app.ConfiguredClassLoading;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.devmode.DependenciesFilter;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.QuarkusDevModeLauncher;
import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.dsl.CompilerOption;
import io.quarkus.gradle.dsl.CompilerOptions;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.GradleDevModeLauncher;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.options.Option;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.util.GradleVersion;

public class QuarkusDev
extends QuarkusTask {
    public static final String IO_QUARKUS_DEVMODE_ARGS = "io.quarkus.devmode-args";
    private final Configuration quarkusDevConfiguration;
    private final SourceSet mainSourceSet;
    private final CompilerOptions compilerOptions = new CompilerOptions();
    private final Property<File> workingDirectory;
    private final Property<Boolean> preventNoVerify;
    private final Property<Boolean> shouldPropagateJavaCompilerArgs;
    private final ListProperty<String> args;
    private final ListProperty<String> jvmArgs;
    private final ListProperty<String> compilerArgs;
    private final Set<File> filesIncludedInClasspath = new HashSet<File>();

    @Inject
    public QuarkusDev(Configuration quarkusDevConfiguration, QuarkusPluginExtension extension) {
        this("Development mode: enables hot deployment with background compilation", quarkusDevConfiguration, extension);
    }

    public QuarkusDev(String name, Configuration quarkusDevConfiguration, QuarkusPluginExtension extension) {
        super(name);
        this.quarkusDevConfiguration = quarkusDevConfiguration;
        this.mainSourceSet = (SourceSet)((SourceSetContainer)this.getProject().getExtensions().getByType(SourceSetContainer.class)).getByName("main");
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.workingDirectory = objectFactory.property(File.class);
        this.workingDirectory.convention(this.getProject().provider(() -> QuarkusPluginExtension.getLastFile(this.getCompilationOutput())));
        this.preventNoVerify = objectFactory.property(Boolean.class);
        this.preventNoVerify.convention((Object)false);
        this.shouldPropagateJavaCompilerArgs = objectFactory.property(Boolean.class);
        this.shouldPropagateJavaCompilerArgs.convention((Object)true);
        this.args = objectFactory.listProperty(String.class);
        this.compilerArgs = objectFactory.listProperty(String.class);
        this.jvmArgs = objectFactory.listProperty(String.class);
    }

    @CompileClasspath
    public Configuration getQuarkusDevConfiguration() {
        return this.quarkusDevConfiguration;
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSources() {
        return this.mainSourceSet.getAllJava().getSourceDirectories();
    }

    @Optional
    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCompilationOutput() {
        return this.mainSourceSet.getOutput().getClassesDirs();
    }

    @Input
    public Property<File> getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Deprecated
    public void setWorkingDir(String workingDir) {
        this.workingDirectory.set((Object)this.getProject().file((Object)workingDir));
    }

    @Input
    public Property<Boolean> getPreventNoVerify() {
        return this.preventNoVerify;
    }

    @Deprecated
    @Internal
    public boolean isPreventnoverify() {
        return (Boolean)this.getPreventNoVerify().get();
    }

    @Deprecated
    @Option(description="value is intended to be set to true when some generated bytecode is erroneous causing the JVM to crash when the verify:none option is set (which is on by default)", option="prevent-noverify")
    public void setPreventnoverify(boolean preventNoVerify) {
        this.getPreventNoVerify().set((Object)preventNoVerify);
    }

    @Input
    public ListProperty<String> getJvmArguments() {
        return this.jvmArgs;
    }

    @Internal
    public List<String> getJvmArgs() {
        return (List)this.jvmArgs.get();
    }

    @Option(description="Set JVM arguments", option="jvm-args")
    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs.set(jvmArgs);
    }

    @Input
    public ListProperty<String> getArguments() {
        return this.args;
    }

    @Internal
    public List<String> getArgs() {
        return (List)this.args.get();
    }

    public void setArgs(List<String> args) {
        this.args.set(args);
    }

    @Option(description="Set application arguments", option="quarkus-args")
    public void setArgsString(String argsString) {
        this.setArgs(Arrays.asList(Commandline.translateCommandline((String)argsString)));
    }

    @Input
    public ListProperty<String> getCompilerArguments() {
        return this.compilerArgs;
    }

    @Internal
    public List<String> getCompilerArgs() {
        return (List)this.getCompilerArguments().get();
    }

    @Option(description="Additional parameters to pass to javac when recompiling changed source files", option="compiler-args")
    public void setCompilerArgs(List<String> compilerArgs) {
        this.getCompilerArguments().set(compilerArgs);
    }

    @Internal
    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public QuarkusDev compilerOptions(Action<CompilerOptions> action) {
        action.execute((Object)this.compilerOptions);
        return this;
    }

    @TaskAction
    public void startDev() {
        block12: {
            if (!this.sourcesExist()) {
                throw new GradleException("The `src/main/java` directory is required, please create it.");
            }
            if (!this.classesExist()) {
                throw new GradleException("The project has no output yet, this should not happen as build should have been executed first. Does the project have any source files?");
            }
            try {
                QuarkusDevModeLauncher runner = this.newLauncher();
                String outputFile = System.getProperty(IO_QUARKUS_DEVMODE_ARGS);
                if (outputFile == null) {
                    this.getProject().exec(action -> {
                        action.commandLine((Iterable)runner.args()).workingDir(this.getWorkingDirectory().get());
                        action.setStandardInput(System.in).setErrorOutput((OutputStream)System.out).setStandardOutput((OutputStream)System.out);
                    });
                    break block12;
                }
                try (BufferedWriter is = Files.newBufferedWriter(Paths.get(outputFile, new String[0]), new OpenOption[0]);){
                    for (String i : runner.args()) {
                        is.write(i);
                        is.newLine();
                    }
                }
            }
            catch (Exception e) {
                throw new GradleException("Failed to run", (Throwable)e);
            }
        }
    }

    private boolean sourcesExist() {
        Set srcDirLocations = (Set)this.mainSourceSet.getAllJava().getSourceDirectories().getElements().get();
        for (FileSystemLocation srcDirLocation : srcDirLocations) {
            File[] files;
            File srcDir = srcDirLocation.getAsFile();
            if (!srcDir.exists() || !srcDir.isDirectory() || (files = srcDir.listFiles()) == null || files.length <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean classesExist() {
        for (FileSystemLocation location : (Set)this.getCompilationOutput().getElements().get()) {
            File locationAsFile = location.getAsFile();
            if (!locationAsFile.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private QuarkusDevModeLauncher newLauncher() throws Exception {
        Object toolchainSpec;
        JavaToolchainService toolChainService;
        Provider provider;
        Project project = this.getProject();
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        String java = null;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.7")) >= 0 && (provider = (toolChainService = (JavaToolchainService)project.getExtensions().getByType(JavaToolchainService.class)).launcherFor((JavaToolchainSpec)(toolchainSpec = javaPluginExtension.getToolchain()))).isPresent()) {
            java = ((JavaLauncher)provider.get()).getExecutablePath().getAsFile().getAbsolutePath();
        }
        GradleDevModeLauncher.Builder builder = (GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)((GradleDevModeLauncher.Builder)GradleDevModeLauncher.builder(this.getLogger(), java).preventnoverify((Boolean)this.getPreventNoVerify().getOrElse((Object)false))).projectDir(project.getProjectDir())).buildDir(project.getBuildDir())).outputDir(project.getBuildDir())).debug(System.getProperty("debug"))).debugHost(System.getProperty("debugHost"))).debugPort(System.getProperty("debugPort"))).suspend(System.getProperty("suspend"));
        if (System.getProperty(IO_QUARKUS_DEVMODE_ARGS) == null) {
            ((GradleDevModeLauncher.Builder)builder.jvmArgs("-Dquarkus.test.basic-console=true")).jvmArgs("-Dio.quarkus.force-color-support=true");
        }
        if (this.getJvmArguments().isPresent() && !((List)this.getJvmArguments().get()).isEmpty()) {
            builder.jvmArgs(this.getJvmArgs());
        }
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            builder.buildSystemProperty((String)entry.getKey(), entry.getValue().toString());
        }
        builder.applicationName(project.getName());
        builder.applicationVersion(project.getVersion().toString());
        builder.sourceEncoding(this.getSourceEncoding());
        ApplicationModel appModel = this.extension().getApplicationModel(LaunchMode.DEVELOPMENT);
        HashSet<ArtifactKey> hashSet = new HashSet<ArtifactKey>();
        for (Object localDep : DependenciesFilter.getReloadableModules((ApplicationModel)appModel)) {
            this.addLocalProject((ResolvedDependency)localDep, builder, hashSet, appModel.getAppArtifact().getWorkspaceModule().getId().equals(localDep.getWorkspaceModule().getId()));
        }
        this.addQuarkusDevModeDeps(builder, appModel);
        HashSet<Path> resourceDirs = new HashSet<Path>();
        for (Object resourceDir : appModel.getApplicationModule().getMainSources().getResourceDirs()) {
            resourceDirs.add(resourceDir.getOutputDir());
        }
        Collection configuredParentFirst = ConfiguredClassLoading.builder().setApplicationModel(appModel).setApplicationRoot((PathCollection)PathsCollection.from(resourceDirs)).setMode(QuarkusBootstrap.Mode.DEV).build().getParentFirstArtifacts();
        for (ResolvedDependency artifact : appModel.getDependencies()) {
            if (hashSet.contains(artifact.getKey())) continue;
            artifact.getResolvedPaths().forEach(p -> {
                File file = p.toFile();
                if (file.exists() && configuredParentFirst.contains(artifact.getKey()) && this.filesIncludedInClasspath.add(file)) {
                    this.getProject().getLogger().debug("Adding dependency {}", (Object)file);
                    builder.classpathEntry(artifact.getKey(), file);
                }
            });
        }
        builder.sourceJavaVersion(javaPluginExtension.getSourceCompatibility().toString());
        builder.targetJavaVersion(javaPluginExtension.getTargetCompatibility().toString());
        for (CompilerOption compilerOptions : this.compilerOptions.getCompilerOptions()) {
            builder.compilerOptions(compilerOptions.getName(), compilerOptions.getArgs());
        }
        if (((Boolean)this.shouldPropagateJavaCompilerArgs.get()).booleanValue() && this.getCompilerArgs().isEmpty()) {
            this.getJavaCompileTask().map(compileTask -> compileTask.getOptions().getCompilerArgs()).ifPresent(args -> builder.compilerOptions("java", (List)args));
        } else {
            builder.compilerOptions("java", this.getCompilerArgs());
        }
        this.modifyDevModeContext(builder);
        Path serializedModel = ToolingUtils.serializeAppModel((ApplicationModel)appModel, (Task)this, (boolean)false);
        serializedModel.toFile().deleteOnExit();
        builder.jvmArgs("-Dquarkus-internal.serialized-app-model.path=" + serializedModel.toAbsolutePath());
        ApplicationModel testAppModel = this.extension().getApplicationModel(LaunchMode.TEST);
        Path serializedTestModel = ToolingUtils.serializeAppModel((ApplicationModel)testAppModel, (Task)this, (boolean)true);
        serializedTestModel.toFile().deleteOnExit();
        builder.jvmArgs("-Dquarkus-internal-test.serialized-app-model.path=" + serializedTestModel.toAbsolutePath());
        if (this.args.isPresent() && !((List)this.args.get()).isEmpty()) {
            builder.applicationArgs(String.join((CharSequence)" ", (Iterable)this.args.get()));
        }
        return builder.build();
    }

    protected void modifyDevModeContext(GradleDevModeLauncher.Builder builder) {
    }

    private void addQuarkusDevModeDeps(GradleDevModeLauncher.Builder builder, ApplicationModel appModel) {
        ResolvedDependency coreDeployment = null;
        for (ResolvedDependency d : appModel.getDependencies()) {
            if (!d.isDeploymentCp() || !d.getArtifactId().equals("quarkus-core-deployment") || !d.getGroupId().equals("io.quarkus")) continue;
            coreDeployment = d;
            break;
        }
        if (coreDeployment == null) {
            throw new GradleException("Failed to locate io.quarkus:quarkus-core-deployment on the application build classpath");
        }
        String pomPropsPath = "META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties";
        InputStream devModePomPropsIs = DevModeMain.class.getClassLoader().getResourceAsStream("META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties");
        if (devModePomPropsIs == null) {
            throw new GradleException("Failed to locate META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties on the classpath");
        }
        Properties devModeProps = new Properties();
        try (InputStream is = devModePomPropsIs;){
            devModeProps.load(is);
        }
        catch (IOException e) {
            throw new GradleException("Failed to load META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties from the classpath", (Throwable)e);
        }
        String devModeGroupId = devModeProps.getProperty("groupId");
        if (devModeGroupId == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties is missing groupId");
        }
        String devModeArtifactId = devModeProps.getProperty("artifactId");
        if (devModeArtifactId == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties is missing artifactId");
        }
        String devModeVersion = devModeProps.getProperty("version");
        if (devModeVersion == null) {
            throw new GradleException("Classpath resource META-INF/maven/io.quarkus/quarkus-bootstrap-gradle-resolver/pom.properties is missing version");
        }
        Dependency gradleResolverDep = this.getProject().getDependencies().create((Object)String.format("%s:%s:%s", devModeGroupId, devModeArtifactId, devModeVersion));
        Dependency coreDeploymentDep = this.getProject().getDependencies().create((Object)String.format("%s:%s:%s", coreDeployment.getGroupId(), coreDeployment.getArtifactId(), coreDeployment.getVersion()));
        Configuration devModeDependencyConfiguration = this.getProject().getConfigurations().detachedConfiguration(new Dependency[]{gradleResolverDep, coreDeploymentDep});
        String platformConfigName = ToolingUtils.toPlatformConfigurationName((String)ApplicationDeploymentClasspathBuilder.getFinalRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT));
        Configuration platformConfig = (Configuration)this.getProject().getConfigurations().findByName(platformConfigName);
        if (platformConfig != null) {
            devModeDependencyConfiguration.extendsFrom(new Configuration[]{platformConfig});
        }
        for (ResolvedArtifact appDep : devModeDependencyConfiguration.getResolvedConfiguration().getResolvedArtifacts()) {
            ModuleVersionIdentifier artifactId = appDep.getModuleVersion().getId();
            if (artifactId.getGroup().equals("io.quarkus") && artifactId.getName().equals("quarkus-ide-launcher")) continue;
            if (artifactId.getGroup().equals("io.quarkus") && artifactId.getName().equals("quarkus-class-change-agent")) {
                builder.jvmArgs("-javaagent:" + appDep.getFile().getAbsolutePath());
                continue;
            }
            builder.classpathEntry(ArtifactKey.of((String)appDep.getModuleVersion().getId().getGroup(), (String)appDep.getName(), (String)appDep.getClassifier(), (String)appDep.getExtension()), appDep.getFile());
        }
    }

    private void addLocalProject(ResolvedDependency project, GradleDevModeLauncher.Builder builder, Set<ArtifactKey> addeDeps, boolean root) {
        String resourcesOutputPath;
        addeDeps.add(project.getKey());
        ArtifactSources sources = project.getSources();
        if (sources == null) {
            return;
        }
        LinkedHashSet<Path> sourcePaths = new LinkedHashSet<Path>();
        LinkedHashSet<Path> sourceParentPaths = new LinkedHashSet<Path>();
        HashSet<Path> classesDirs = new HashSet<Path>(sources.getSourceDirs().size());
        for (SourceDir src : sources.getSourceDirs()) {
            if (!Files.exists(src.getDir(), new LinkOption[0])) continue;
            sourcePaths.add(src.getDir());
            sourceParentPaths.add(src.getDir().getParent());
            if (src.getOutputDir() == null) continue;
            classesDirs.add(src.getOutputDir());
        }
        Path classesDir = classesDirs.isEmpty() ? null : QuarkusGradleUtils.mergeClassesDirs(classesDirs, project.getWorkspaceModule().getBuildDir(), root, root);
        LinkedHashSet<Path> resourcesSrcDirs = new LinkedHashSet<Path>();
        Path resourcesOutputDir = null;
        for (SourceDir resource : sources.getResourceDirs()) {
            resourcesSrcDirs.add(resource.getDir());
            if (resourcesOutputDir != null) continue;
            resourcesOutputDir = resource.getOutputDir();
        }
        if (sourcePaths.isEmpty() && (resourcesOutputDir == null || !Files.exists(resourcesOutputDir, new LinkOption[0])) || classesDir == null) {
            return;
        }
        if (resourcesOutputDir != null && Files.exists(resourcesOutputDir, new LinkOption[0])) {
            resourcesOutputPath = resourcesOutputDir.toString();
            if (!Files.exists(classesDir, new LinkOption[0])) {
                classesDir = resourcesOutputDir;
            }
        } else {
            resourcesOutputPath = classesDir.toString();
        }
        DevModeContext.ModuleInfo.Builder moduleBuilder = new DevModeContext.ModuleInfo.Builder().setArtifactKey(project.getKey()).setName(project.getArtifactId()).setProjectDirectory(project.getWorkspaceModule().getModuleDir().getAbsolutePath()).setSourcePaths((PathCollection)PathList.from(sourcePaths)).setClassesPath(classesDir.toString()).setResourcePaths((PathCollection)PathList.from(resourcesSrcDirs)).setResourcesOutputPath(resourcesOutputPath).setSourceParents((PathCollection)PathList.from(sourceParentPaths)).setPreBuildOutputDir(project.getWorkspaceModule().getBuildDir().toPath().resolve("generated-sources").toAbsolutePath().toString()).setTargetDir(project.getWorkspaceModule().getBuildDir().toString());
        ArtifactSources testSources = project.getWorkspaceModule().getTestSources();
        if (testSources != null) {
            LinkedHashSet<Path> testSourcePaths = new LinkedHashSet<Path>();
            LinkedHashSet<Path> testSourceParentPaths = new LinkedHashSet<Path>();
            HashSet<Path> testClassesDirs = new HashSet<Path>(testSources.getSourceDirs().size());
            for (SourceDir src : testSources.getSourceDirs()) {
                if (!Files.exists(src.getDir(), new LinkOption[0])) continue;
                testSourcePaths.add(src.getDir());
                testSourceParentPaths.add(src.getDir().getParent());
                if (src.getOutputDir() == null) continue;
                testClassesDirs.add(src.getOutputDir());
            }
            Path testClassesDir = testClassesDirs.isEmpty() ? null : QuarkusGradleUtils.mergeClassesDirs(testClassesDirs, project.getWorkspaceModule().getBuildDir(), root, root);
            LinkedHashSet<Path> testResourcesSrcDirs = new LinkedHashSet<Path>();
            Path testResourcesOutputDir = null;
            for (SourceDir resource : testSources.getResourceDirs()) {
                testResourcesSrcDirs.add(resource.getDir());
                if (testResourcesOutputDir != null) continue;
                testResourcesOutputDir = resource.getOutputDir();
            }
            if (testClassesDir != null && (!testSourcePaths.isEmpty() || testResourcesOutputDir != null && Files.exists(testResourcesOutputDir, new LinkOption[0]))) {
                String testResourcesOutputPath;
                if (testResourcesOutputDir != null && Files.exists(testResourcesOutputDir, new LinkOption[0])) {
                    testResourcesOutputPath = testResourcesOutputDir.toString();
                    if (!Files.exists(testClassesDir, new LinkOption[0])) {
                        testClassesDir = testResourcesOutputDir;
                    }
                } else {
                    testResourcesOutputPath = testClassesDir.toString();
                }
                moduleBuilder.setTestSourcePaths((PathCollection)PathList.from(testSourcePaths)).setTestClassesPath(testClassesDir.toString()).setTestResourcePaths((PathCollection)PathList.from(testResourcesSrcDirs)).setTestResourcesOutputPath(testResourcesOutputPath);
            }
        }
        DevModeContext.ModuleInfo wsModuleInfo = moduleBuilder.build();
        if (root) {
            builder.mainModule(wsModuleInfo);
        } else {
            builder.dependency(wsModuleInfo);
        }
    }

    private String getSourceEncoding() {
        return this.getJavaCompileTask().map(javaCompile -> javaCompile.getOptions().getEncoding()).orElse(null);
    }

    private java.util.Optional<JavaCompile> getJavaCompileTask() {
        return java.util.Optional.ofNullable((JavaCompile)this.getProject().getTasks().getByName("compileJava"));
    }

    public void shouldPropagateJavaCompilerArgs(boolean shouldPropagateJavaCompilerArgs) {
        this.shouldPropagateJavaCompilerArgs.set((Object)shouldPropagateJavaCompilerArgs);
    }
}

