/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.InfoCommandHandler;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.gradle.tasks.QuarkusPlatformTask;
import java.util.HashMap;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusInfo
extends QuarkusPlatformTask {
    private boolean perModule = false;

    @Input
    public boolean getPerModule() {
        return this.perModule;
    }

    @Option(description="Log project's state per module.", option="perModule")
    public void setPerModule(boolean perModule) {
        this.perModule = perModule;
    }

    public QuarkusInfo() {
        super("Log Quarkus-specific project information, such as imported Quarkus platform BOMs, Quarkus extensions found among the project dependencies, etc.");
    }

    @TaskAction
    public void logInfo() {
        QuarkusCommandOutcome outcome;
        this.getProject().getLogger().warn(this.getName() + " is experimental, its options and output might change in future versions");
        QuarkusProject quarkusProject = this.getQuarkusProject(false);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app-model", this.extension().getApplicationModel());
        params.put("log-state-per-module", this.perModule);
        QuarkusCommandInvocation invocation = new QuarkusCommandInvocation(quarkusProject, params);
        try {
            outcome = new InfoCommandHandler().execute(invocation);
        }
        catch (Exception e) {
            throw new GradleException("Failed to collect Quarkus project information", (Throwable)e);
        }
        if (outcome.getValue("recommendations-available", false)) {
            this.getProject().getLogger().warn("Non-recommended Quarkus platform BOM and/or extension versions were found. For more details, please, execute 'gradle quarkusUpdate --rectify'");
        }
    }
}

