/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.gradle.dsl.Manifest;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusTask;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.runtime.util.StringUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class QuarkusBuild
extends QuarkusTask {
    private static final String NATIVE_PROPERTY_NAMESPACE = "quarkus.native";
    private static final String MANIFEST_SECTIONS_PROPERTY_PREFIX = "quarkus.package.manifest.manifest-sections";
    private static final String MANIFEST_ATTRIBUTES_PROPERTY_PREFIX = "quarkus.package.manifest.attributes";
    private List<String> ignoredEntries = new ArrayList<String>();
    private Manifest manifest = new Manifest();

    public QuarkusBuild() {
        super("Quarkus builds a runner jar based on the build jar");
    }

    public QuarkusBuild nativeArgs(Action<Map<String, ?>> action) {
        HashMap nativeArgsMap = new HashMap();
        action.execute(nativeArgsMap);
        for (Map.Entry nativeArg : nativeArgsMap.entrySet()) {
            System.setProperty(this.expandConfigurationKey((String)nativeArg.getKey()), nativeArg.getValue().toString());
        }
        return this;
    }

    @Optional
    @Input
    public List<String> getIgnoredEntries() {
        return this.ignoredEntries;
    }

    @Option(description="When using the uber-jar option, this option can be used to specify one or more entries that should be excluded from the final jar", option="ignored-entry")
    public void setIgnoredEntries(List<String> ignoredEntries) {
        this.ignoredEntries.addAll(ignoredEntries);
    }

    @Classpath
    public FileCollection getClasspath() {
        SourceSet mainSourceSet = QuarkusGradleUtils.getSourceSet(this.getProject(), "main");
        return mainSourceSet.getCompileClasspath().plus(mainSourceSet.getRuntimeClasspath()).plus(mainSourceSet.getAnnotationProcessorPath()).plus((FileCollection)mainSourceSet.getResources());
    }

    @Input
    public Map<Object, Object> getQuarkusBuildSystemProperties() {
        HashMap<Object, Object> quarkusSystemProperties = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> systemProperty : System.getProperties().entrySet()) {
            if (!systemProperty.getKey().toString().startsWith("quarkus.") || !(systemProperty.getValue() instanceof Serializable)) continue;
            quarkusSystemProperties.put(systemProperty.getKey(), systemProperty.getValue());
        }
        return quarkusSystemProperties;
    }

    @Input
    public Map<String, String> getQuarkusBuildEnvProperties() {
        HashMap<String, String> quarkusEnvProperties = new HashMap<String, String>();
        for (Map.Entry<String, String> systemProperty : System.getenv().entrySet()) {
            if (systemProperty.getKey() == null || !systemProperty.getKey().startsWith("QUARKUS_")) continue;
            quarkusEnvProperties.put(systemProperty.getKey(), systemProperty.getValue());
        }
        return quarkusEnvProperties;
    }

    @Internal
    public Manifest getManifest() {
        return this.manifest;
    }

    public QuarkusBuild manifest(Action<Manifest> action) {
        action.execute((Object)this.getManifest());
        return this;
    }

    @OutputFile
    public File getRunnerJar() {
        return new File(this.getProject().getBuildDir(), this.extension().finalName() + "-runner.jar");
    }

    @OutputFile
    public File getNativeRunner() {
        return new File(this.getProject().getBuildDir(), this.extension().finalName() + "-runner");
    }

    @OutputDirectory
    public File getFastJar() {
        return new File(this.getProject().getBuildDir(), "quarkus-app");
    }

    @TaskAction
    public void buildQuarkus() {
        ApplicationModel appModel;
        try {
            appModel = this.extension().getAppModelResolver().resolveModel((ArtifactCoords)new GACTV(this.getProject().getGroup().toString(), this.getProject().getName(), this.getProject().getVersion().toString()));
        }
        catch (AppModelResolverException e) {
            throw new GradleException("Failed to resolve Quarkus application model for " + this.getProject().getPath(), (Throwable)e);
        }
        Properties effectiveProperties = this.getBuildSystemProperties(appModel.getAppArtifact());
        if (this.ignoredEntries != null && this.ignoredEntries.size() > 0) {
            String joinedEntries = String.join((CharSequence)",", this.ignoredEntries);
            effectiveProperties.setProperty("quarkus.package.user-configured-ignored-entries", joinedEntries);
        }
        this.exportCustomManifestProperties(effectiveProperties);
        try (CuratedApplication appCreationContext = QuarkusBootstrap.builder().setBaseClassLoader(((Object)((Object)this)).getClass().getClassLoader()).setExistingModel(appModel).setTargetDirectory(this.getProject().getBuildDir().toPath()).setBaseName(this.extension().finalName()).setBuildSystemProperties(effectiveProperties).setAppArtifact(appModel.getAppArtifact()).setLocalProjectDiscovery(Boolean.valueOf(false)).setIsolateDeployment(true).build().bootstrap();){
            appCreationContext.createAugmentor("io.quarkus.deployment.pkg.builditem.ProcessInheritIODisabled$Factory", Collections.emptyMap()).createProductionApplication();
        }
        catch (BootstrapException e) {
            throw new GradleException("Failed to build a runnable JAR", (Throwable)e);
        }
    }

    private void exportCustomManifestProperties(Properties buildSystemProperties) {
        if (this.manifest == null) {
            return;
        }
        for (Map.Entry entry : this.manifest.getAttributes().entrySet()) {
            buildSystemProperties.put(this.toManifestAttributeKey((String)entry.getKey()), entry.getValue());
        }
        for (Map.Entry entry : this.manifest.getSections().entrySet()) {
            for (Map.Entry attribute : ((Attributes)entry.getValue()).entrySet()) {
                buildSystemProperties.put(this.toManifestSectionAttributeKey((String)entry.getKey(), (String)attribute.getKey()), attribute.getValue());
            }
        }
    }

    private String toManifestAttributeKey(String key) {
        if (key.contains("\"")) {
            throw new GradleException("Manifest entry name " + key + " is invalid. \" characters are not allowed.");
        }
        return String.format("%s.\"%s\"", MANIFEST_ATTRIBUTES_PROPERTY_PREFIX, key);
    }

    private String toManifestSectionAttributeKey(String section, String key) {
        if (section.contains("\"")) {
            throw new GradleException("Manifest section name " + section + " is invalid. \" characters are not allowed.");
        }
        if (key.contains("\"")) {
            throw new GradleException("Manifest entry name " + key + " is invalid. \" characters are not allowed.");
        }
        return String.format("%s.\"%s\".\"%s\"", MANIFEST_SECTIONS_PROPERTY_PREFIX, section, key);
    }

    private String expandConfigurationKey(String shortKey) {
        String hyphenatedKey = StringUtil.hyphenate((String)shortKey);
        if (hyphenatedKey.startsWith(NATIVE_PROPERTY_NAMESPACE)) {
            return hyphenatedKey;
        }
        return String.format("%s.%s", NATIVE_PROPERTY_NAMESPACE, hyphenatedKey);
    }
}

