/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.devtools.project.buildfile.AbstractGradleBuildFile;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.attributes.Category;

public abstract class GradleProjectBuildFile
extends AbstractGradleBuildFile {
    private final Project project;

    public GradleProjectBuildFile(Project project, ExtensionCatalog catalog) {
        super(project.getProjectDir().toPath(), catalog, project.getParent() != null ? project.getRootProject().getProjectDir().toPath() : project.getProjectDir().toPath());
        this.project = project;
    }

    protected List<ArtifactCoords> getDependencies() throws IOException {
        List<Dependency> boms = this.boms();
        ArrayList<ArtifactCoords> coords = new ArrayList<ArtifactCoords>();
        boms.forEach(d -> coords.add(new ArtifactCoords(d.getGroup(), d.getName(), null, "pom", d.getVersion())));
        this.project.getConfigurations().getByName("implementation").getIncoming().getDependencies().forEach(d -> {
            if (!(d instanceof ModuleDependency)) {
                return;
            }
            ModuleDependency module = (ModuleDependency)d;
            coords.add(new ArtifactCoords(module.getGroup(), module.getName(), module.getVersion()));
        });
        return coords;
    }

    public String getProperty(String name) {
        Object o = this.project.getProperties().get(name);
        return o == null ? null : o.toString();
    }

    protected ArtifactCoords toBomImportCoords(ArtifactCoords rawBomCoords) {
        if (rawBomCoords.getGroupId().equals(this.getProperty("quarkusPlatformGroupId")) && rawBomCoords.getVersion().equals(this.getProperty("quarkusPlatformVersion"))) {
            return new ArtifactCoords("${quarkusPlatformGroupId}", rawBomCoords.getArtifactId().equals(this.getProperty("quarkusPlatformArtifactId")) ? "${quarkusPlatformArtifactId}" : rawBomCoords.getArtifactId(), "pom", "${quarkusPlatformVersion}");
        }
        return rawBomCoords;
    }

    private List<Dependency> boms() {
        ArrayList<Dependency> boms = new ArrayList<Dependency>();
        Configuration impl = this.project.getConfigurations().getByName("implementation");
        for (Dependency d : impl.getAllDependencies()) {
            ModuleDependency module;
            Category category;
            if (!(d instanceof ModuleDependency) || (category = (Category)(module = (ModuleDependency)d).getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE)) == null || !"enforced-platform".equals(category.getName()) && !"platform".equals(category.getName())) continue;
            boms.add(d);
        }
        return boms;
    }

    public List<ArtifactCoords> getInstalledPlatforms() throws IOException {
        List<Dependency> bomDeps = this.boms();
        if (bomDeps.isEmpty()) {
            return Collections.emptyList();
        }
        Configuration boms = this.project.getConfigurations().detachedConfiguration(bomDeps.toArray(new Dependency[0]));
        ArrayList<ArtifactCoords> platforms = new ArrayList<ArtifactCoords>();
        boms.getResolutionStrategy().eachDependency(d -> {
            if (!d.getTarget().getName().endsWith("-quarkus-platform-descriptor")) {
                return;
            }
            ArtifactCoords platform = new ArtifactCoords(d.getTarget().getGroup(), PlatformArtifacts.ensureBomArtifactId((String)d.getTarget().getName()), null, "pom", d.getTarget().getVersion());
            platforms.add(platform);
        });
        boms.getResolvedConfiguration();
        return platforms;
    }
}

