/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.ArrayTypeImpl;
import io.quarkus.arc.processor.bcextensions.ClassTypeImpl;
import io.quarkus.arc.processor.bcextensions.ParameterizedTypeImpl;
import io.quarkus.arc.processor.bcextensions.PrimitiveTypeImpl;
import io.quarkus.arc.processor.bcextensions.TypeVariableImpl;
import io.quarkus.arc.processor.bcextensions.UnresolvedTypeVariableImpl;
import io.quarkus.arc.processor.bcextensions.VoidTypeImpl;
import io.quarkus.arc.processor.bcextensions.WildcardTypeImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

abstract class TypeImpl<JandexType extends Type>
implements jakarta.enterprise.lang.model.types.Type {
    final IndexView jandexIndex;
    final AllAnnotationOverlays annotationOverlays;
    final JandexType jandexType;

    TypeImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, JandexType jandexType) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.jandexType = jandexType;
    }

    static jakarta.enterprise.lang.model.types.Type fromJandexType(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, Type jandexType) {
        switch (jandexType.kind()) {
            case VOID: {
                return new VoidTypeImpl(jandexIndex, annotationOverlays, jandexType.asVoidType());
            }
            case PRIMITIVE: {
                return new PrimitiveTypeImpl(jandexIndex, annotationOverlays, jandexType.asPrimitiveType());
            }
            case CLASS: {
                return new ClassTypeImpl(jandexIndex, annotationOverlays, jandexType.asClassType());
            }
            case ARRAY: {
                return new ArrayTypeImpl(jandexIndex, annotationOverlays, jandexType.asArrayType());
            }
            case PARAMETERIZED_TYPE: {
                return new ParameterizedTypeImpl(jandexIndex, annotationOverlays, jandexType.asParameterizedType());
            }
            case TYPE_VARIABLE: {
                return new TypeVariableImpl(jandexIndex, annotationOverlays, jandexType.asTypeVariable());
            }
            case UNRESOLVED_TYPE_VARIABLE: {
                return new UnresolvedTypeVariableImpl(jandexIndex, annotationOverlays, jandexType.asUnresolvedTypeVariable());
            }
            case WILDCARD_TYPE: {
                return new WildcardTypeImpl(jandexIndex, annotationOverlays, jandexType.asWildcardType());
            }
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(jandexType));
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.jandexType.hasAnnotation(DotName.createSimple((String)annotationType.getName()));
    }

    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        return this.jandexType.annotations().stream().anyMatch(it -> predicate.test(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)));
    }

    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, this.jandexType.annotation(DotName.createSimple((String)annotationType.getName())));
    }

    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        return this.jandexType.annotationsWithRepeatable(DotName.createSimple((String)annotationType.getName()), this.jandexIndex).stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).collect(Collectors.toUnmodifiableList());
    }

    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        return this.jandexType.annotations().stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).filter(predicate).collect(Collectors.toUnmodifiableList());
    }

    public Collection<AnnotationInfo> annotations() {
        return this.annotations(it -> true);
    }

    public String toString() {
        return this.jandexType.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeImpl)) {
            return false;
        }
        TypeImpl type = (TypeImpl)o;
        return Objects.equals(this.jandexType, type.jandexType);
    }

    public int hashCode() {
        return Objects.hash(this.jandexType);
    }
}

