/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.AnnotationValueArray;
import io.quarkus.arc.processor.bcextensions.AnnotationsOverlay;
import jakarta.enterprise.lang.model.AnnotationInfo;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.EquivalenceKey;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

abstract class AnnotationsTransformation<JandexDeclaration extends AnnotationTarget>
implements AnnotationsTransformer {
    final IndexView jandexIndex;
    final AllAnnotationOverlays annotationOverlays;
    private final AnnotationTarget.Kind kind;
    private final Map<EquivalenceKey, List<Consumer<AnnotationsTransformer.TransformationContext>>> transformations = new ConcurrentHashMap<EquivalenceKey, List<Consumer<AnnotationsTransformer.TransformationContext>>>();
    private volatile boolean frozen = false;

    AnnotationsTransformation(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, AnnotationTarget.Kind kind) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.kind = kind;
    }

    private void addAnnotation(JandexDeclaration jandexDeclaration, AnnotationInstance jandexAnnotation) {
        if (this.frozen) {
            throw new IllegalStateException("Annotations transformation frozen");
        }
        EquivalenceKey key = EquivalenceKey.of(jandexDeclaration);
        AnnotationInstance jandexAnnotationWithTarget = AnnotationInstance.create((DotName)jandexAnnotation.name(), jandexDeclaration, (List)jandexAnnotation.values());
        this.annotationsOverlay().getAnnotations(jandexDeclaration, this.jandexIndex).add(jandexAnnotationWithTarget);
        Consumer<AnnotationsTransformer.TransformationContext> transformation = ctx -> ((Transformation)ctx.transform().add(jandexAnnotationWithTarget)).done();
        this.transformations.computeIfAbsent(key, ignored -> new ArrayList()).add(transformation);
    }

    void addAnnotation(JandexDeclaration jandexDeclaration, Class<? extends Annotation> clazz) {
        AnnotationInstance jandexAnnotation = AnnotationInstance.create((DotName)DotName.createSimple((String)clazz.getName()), null, (AnnotationValue[])AnnotationValueArray.EMPTY);
        this.addAnnotation(jandexDeclaration, jandexAnnotation);
    }

    void addAnnotation(JandexDeclaration jandexDeclaration, AnnotationInfo annotation) {
        this.addAnnotation(jandexDeclaration, ((AnnotationInfoImpl)annotation).jandexAnnotation);
    }

    void addAnnotation(JandexDeclaration jandexDeclaration, Annotation annotation) {
        this.addAnnotation(jandexDeclaration, Annotations.jandexAnnotation(annotation));
    }

    private void removeMatchingAnnotations(JandexDeclaration declaration, Predicate<AnnotationInstance> predicate) {
        if (this.frozen) {
            throw new IllegalStateException("Annotations transformation frozen");
        }
        EquivalenceKey key = EquivalenceKey.of(declaration);
        this.annotationsOverlay().getAnnotations(declaration, this.jandexIndex).removeIf(predicate);
        Consumer<AnnotationsTransformer.TransformationContext> transformation = ctx -> ((Transformation)ctx.transform().remove((Predicate)predicate)).done();
        this.transformations.computeIfAbsent(key, ignored -> new ArrayList()).add(transformation);
    }

    void removeAnnotation(JandexDeclaration declaration, final Predicate<AnnotationInfo> predicate) {
        final EquivalenceKey key = EquivalenceKey.of(declaration);
        this.removeMatchingAnnotations(declaration, new Predicate<AnnotationInstance>(){

            @Override
            public boolean test(AnnotationInstance jandexAnnotation) {
                return key.equals(EquivalenceKey.of((AnnotationTarget)jandexAnnotation.target())) && predicate.test(new AnnotationInfoImpl(AnnotationsTransformation.this.jandexIndex, AnnotationsTransformation.this.annotationOverlays, jandexAnnotation));
            }
        });
    }

    void removeAllAnnotations(JandexDeclaration declaration) {
        this.removeAnnotation(declaration, ignored -> true);
    }

    void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return this.kind == kind;
    }

    @Override
    public void transform(AnnotationsTransformer.TransformationContext ctx) {
        JandexDeclaration jandexDeclaration = this.targetJandexDeclaration(ctx);
        EquivalenceKey key = EquivalenceKey.of(jandexDeclaration);
        this.transformations.getOrDefault(key, Collections.emptyList()).forEach(it -> it.accept(ctx));
    }

    abstract JandexDeclaration targetJandexDeclaration(AnnotationsTransformer.TransformationContext var1);

    abstract AnnotationsOverlay<JandexDeclaration> annotationsOverlay();

    static class Fields
    extends AnnotationsTransformation<FieldInfo> {
        Fields(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays) {
            super(jandexIndex, annotationOverlays, AnnotationTarget.Kind.FIELD);
        }

        @Override
        protected FieldInfo targetJandexDeclaration(AnnotationsTransformer.TransformationContext ctx) {
            return ctx.getTarget().asField();
        }

        @Override
        AnnotationsOverlay<FieldInfo> annotationsOverlay() {
            return this.annotationOverlays.fields;
        }
    }

    static class Parameters
    extends AnnotationsTransformation<MethodParameterInfo> {
        Parameters(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays) {
            super(jandexIndex, annotationOverlays, AnnotationTarget.Kind.METHOD_PARAMETER);
        }

        @Override
        protected MethodParameterInfo targetJandexDeclaration(AnnotationsTransformer.TransformationContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        AnnotationsOverlay<MethodParameterInfo> annotationsOverlay() {
            return this.annotationOverlays.parameters;
        }

        @Override
        public boolean appliesTo(AnnotationTarget.Kind kind) {
            return AnnotationTarget.Kind.METHOD == kind;
        }

        @Override
        public void transform(AnnotationsTransformer.TransformationContext ctx) {
            MethodInfo jandexMethod = ctx.getTarget().asMethod();
            for (MethodParameterInfo jandexDeclaration : jandexMethod.parameters()) {
                EquivalenceKey.MethodParameterEquivalenceKey key = EquivalenceKey.of((MethodParameterInfo)jandexDeclaration);
                this.transformations.getOrDefault(key, Collections.emptyList()).forEach(it -> it.accept(ctx));
            }
        }
    }

    static class Methods
    extends AnnotationsTransformation<MethodInfo> {
        Methods(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays) {
            super(jandexIndex, annotationOverlays, AnnotationTarget.Kind.METHOD);
        }

        @Override
        protected MethodInfo targetJandexDeclaration(AnnotationsTransformer.TransformationContext ctx) {
            return ctx.getTarget().asMethod();
        }

        @Override
        AnnotationsOverlay<MethodInfo> annotationsOverlay() {
            return this.annotationOverlays.methods;
        }
    }

    static class Classes
    extends AnnotationsTransformation<ClassInfo> {
        Classes(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays) {
            super(jandexIndex, annotationOverlays, AnnotationTarget.Kind.CLASS);
        }

        @Override
        protected ClassInfo targetJandexDeclaration(AnnotationsTransformer.TransformationContext ctx) {
            return ctx.getTarget().asClass();
        }

        @Override
        AnnotationsOverlay<ClassInfo> annotationsOverlay() {
            return this.annotationOverlays.classes;
        }
    }
}

