/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanStream;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.Switch;
import io.quarkus.gizmo.TryBlock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jboss.jandex.DotName;

public class ContextInstancesGenerator
extends AbstractGenerator {
    static final String APP_CONTEXT_INSTANCES_SUFFIX = "_ContextInstances";
    private final BeanDeployment beanDeployment;
    private final Map<DotName, String> scopeToGeneratedName;

    public ContextInstancesGenerator(boolean generateSources, ReflectionRegistration reflectionRegistration, BeanDeployment beanDeployment, Map<DotName, String> scopeToGeneratedName) {
        super(generateSources, reflectionRegistration);
        this.beanDeployment = beanDeployment;
        this.scopeToGeneratedName = scopeToGeneratedName;
    }

    void precomputeGeneratedName(DotName scope) {
        String generatedName = DEFAULT_PACKAGE + "." + this.beanDeployment.name + "_" + scope.toString().replace(".", "_") + APP_CONTEXT_INSTANCES_SUFFIX;
        this.scopeToGeneratedName.put(scope, generatedName);
    }

    Collection<ResourceOutput.Resource> generate(DotName scope) {
        List<BeanInfo> beans = new BeanStream(this.beanDeployment.getBeans()).withScope(scope).collect();
        ResourceClassOutput classOutput = new ResourceClassOutput(true, this.generateSources);
        String generatedName = this.scopeToGeneratedName.get(scope);
        this.reflectionRegistration.registerMethod(generatedName, "<init>", new String[0]);
        ClassCreator contextInstances = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(generatedName).interfaces(new Class[]{ContextInstances.class}).build();
        HashMap<String, FieldDescriptor> idToField = new HashMap<String, FieldDescriptor>();
        int fieldIndex = 0;
        for (BeanInfo bean : beans) {
            FieldCreator fc = (FieldCreator)contextInstances.getFieldCreator("" + fieldIndex++, ContextInstanceHandle.class).setModifiers(66);
            idToField.put(bean.getIdentifier(), fc.getFieldDescriptor());
        }
        FieldCreator lockField = (FieldCreator)contextInstances.getFieldCreator("lock", Lock.class).setModifiers(18);
        MethodCreator constructor = contextInstances.getMethodCreator("<init>", "V", new String[0]);
        constructor.invokeSpecialMethod(MethodDescriptors.OBJECT_CONSTRUCTOR, constructor.getThis(), new ResultHandle[0]);
        constructor.writeInstanceField(lockField.getFieldDescriptor(), constructor.getThis(), constructor.newInstance(MethodDescriptor.ofConstructor(ReentrantLock.class, (Class[])new Class[0]), new ResultHandle[0]));
        constructor.returnVoid();
        this.implementComputeIfAbsent(contextInstances, beans, idToField, lockField.getFieldDescriptor());
        this.implementGetIfPresent(contextInstances, beans, idToField);
        this.implementRemove(contextInstances, beans, idToField, lockField.getFieldDescriptor());
        this.implementClear(contextInstances, idToField, lockField.getFieldDescriptor());
        this.implementGetAllPresent(contextInstances, idToField, lockField.getFieldDescriptor());
        contextInstances.close();
        return classOutput.getResources();
    }

    private void implementGetAllPresent(ClassCreator contextInstances, Map<String, FieldDescriptor> idToField, FieldDescriptor lockField) {
        MethodCreator getAllPresent = (MethodCreator)contextInstances.getMethodCreator("getAllPresent", Set.class, new Class[0]).setModifiers(1);
        ResultHandle lock = getAllPresent.readInstanceField(lockField, getAllPresent.getThis());
        getAllPresent.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
        TryBlock tryBlock = getAllPresent.tryBlock();
        ResultHandle ret = tryBlock.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (FieldDescriptor field : idToField.values()) {
            ResultHandle copy = tryBlock.readInstanceField(field, tryBlock.getThis());
            tryBlock.ifNotNull(copy).trueBranch().invokeInterfaceMethod(MethodDescriptors.SET_ADD, ret, new ResultHandle[]{copy});
        }
        tryBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
        tryBlock.returnValue(ret);
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        catchBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
        catchBlock.throwException(catchBlock.getCaughtException());
    }

    private void implementClear(ClassCreator applicationContextInstances, Map<String, FieldDescriptor> idToField, FieldDescriptor lockField) {
        MethodCreator clear = (MethodCreator)applicationContextInstances.getMethodCreator("clear", Void.TYPE, new Class[0]).setModifiers(1);
        ResultHandle lock = clear.readInstanceField(lockField, clear.getThis());
        clear.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
        TryBlock tryBlock = clear.tryBlock();
        for (FieldDescriptor field : idToField.values()) {
            tryBlock.writeInstanceField(field, tryBlock.getThis(), tryBlock.loadNull());
        }
        tryBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
        tryBlock.returnVoid();
        CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
        catchBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
        catchBlock.throwException(catchBlock.getCaughtException());
    }

    private void implementRemove(ClassCreator contextInstances, List<BeanInfo> applicationScopedBeans, Map<String, FieldDescriptor> idToField, FieldDescriptor lockField) {
        MethodCreator remove = (MethodCreator)contextInstances.getMethodCreator("remove", ContextInstanceHandle.class, new Class[]{String.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = remove.stringSwitch(remove.getMethodParam(0));
        strSwitch.fallThrough();
        for (BeanInfo bean : applicationScopedBeans) {
            FieldDescriptor instanceField = idToField.get(bean.getIdentifier());
            MethodCreator removeBean = (MethodCreator)contextInstances.getMethodCreator("r" + instanceField.getName(), ContextInstanceHandle.class, new Class[0]).setModifiers(2);
            ResultHandle lock = removeBean.readInstanceField(lockField, removeBean.getThis());
            removeBean.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
            TryBlock tryBlock = removeBean.tryBlock();
            ResultHandle copy = tryBlock.readInstanceField(instanceField, tryBlock.getThis());
            BytecodeCreator isNotNull = tryBlock.ifNotNull(copy).trueBranch();
            isNotNull.writeInstanceField(instanceField, isNotNull.getThis(), isNotNull.loadNull());
            tryBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            tryBlock.returnValue(copy);
            CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
            catchBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            catchBlock.throwException(catchBlock.getCaughtException());
            strSwitch.caseOf((Object)bean.getIdentifier(), bc -> bc.returnValue(bc.invokeVirtualMethod(removeBean.getMethodDescriptor(), bc.getThis(), new ResultHandle[0])));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
    }

    private void implementGetIfPresent(ClassCreator contextInstances, List<BeanInfo> applicationScopedBeans, Map<String, FieldDescriptor> idToField) {
        MethodCreator getIfPresent = (MethodCreator)contextInstances.getMethodCreator("getIfPresent", ContextInstanceHandle.class, new Class[]{String.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = getIfPresent.stringSwitch(getIfPresent.getMethodParam(0));
        strSwitch.fallThrough();
        for (BeanInfo bean : applicationScopedBeans) {
            strSwitch.caseOf((Object)bean.getIdentifier(), bc -> bc.returnValue(bc.readInstanceField((FieldDescriptor)idToField.get(bean.getIdentifier()), bc.getThis())));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
    }

    private void implementComputeIfAbsent(ClassCreator contextInstances, List<BeanInfo> applicationScopedBeans, Map<String, FieldDescriptor> idToField, FieldDescriptor lockField) {
        MethodCreator computeIfAbsent = (MethodCreator)contextInstances.getMethodCreator("computeIfAbsent", ContextInstanceHandle.class, new Class[]{String.class, Supplier.class}).setModifiers(1);
        Switch.StringSwitch strSwitch = computeIfAbsent.stringSwitch(computeIfAbsent.getMethodParam(0));
        strSwitch.fallThrough();
        for (BeanInfo bean : applicationScopedBeans) {
            FieldDescriptor instanceField = idToField.get(bean.getIdentifier());
            MethodCreator compute = (MethodCreator)contextInstances.getMethodCreator("c" + instanceField.getName(), ContextInstanceHandle.class, new Class[]{Supplier.class}).setModifiers(2);
            ResultHandle copy = compute.readInstanceField(instanceField, compute.getThis());
            compute.ifNotNull(copy).trueBranch().returnValue(copy);
            ResultHandle lock = compute.readInstanceField(lockField, compute.getThis());
            compute.invokeInterfaceMethod(MethodDescriptors.LOCK_LOCK, lock, new ResultHandle[0]);
            TryBlock tryBlock = compute.tryBlock();
            ResultHandle val = tryBlock.readInstanceField(instanceField, compute.getThis());
            BytecodeCreator isNull = tryBlock.ifNull(val).trueBranch();
            ResultHandle newVal = isNull.invokeInterfaceMethod(MethodDescriptors.SUPPLIER_GET, compute.getMethodParam(0), new ResultHandle[0]);
            isNull.writeInstanceField(instanceField, compute.getThis(), newVal);
            tryBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
            catchBlock.invokeInterfaceMethod(MethodDescriptors.LOCK_UNLOCK, lock, new ResultHandle[0]);
            catchBlock.throwException(catchBlock.getCaughtException());
            compute.returnValue(compute.readInstanceField(instanceField, compute.getThis()));
            strSwitch.caseOf((Object)bean.getIdentifier(), bc -> bc.returnValue(bc.invokeVirtualMethod(compute.getMethodDescriptor(), bc.getThis(), new ResultHandle[]{bc.getMethodParam(1)})));
        }
        strSwitch.defaultCase(bc -> bc.throwException(IllegalArgumentException.class, "Unknown bean identifier"));
    }
}

