/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.InvokerCleanupTasks;
import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.AssignabilityCheck;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinBean;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InvocationTransformer;
import io.quarkus.arc.processor.InvocationTransformerKind;
import io.quarkus.arc.processor.InvokerInfo;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.Reflection2Gizmo;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.Var;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.TryCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.smallrye.common.annotation.SuppressForbidden;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.invoke.Invoker;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.jandex.gizmo2.StringBuilderGen;
import org.jboss.logging.Logger;

public class InvokerGenerator
extends AbstractGenerator {
    private static final Logger LOGGER = Logger.getLogger(InvokerGenerator.class);
    private final Predicate<DotName> applicationClassPredicate;
    private final IndexView beanArchiveIndex;
    private final BeanDeployment beanDeployment;
    private final AnnotationLiteralProcessor annotationLiterals;
    private final ReflectionRegistration reflectionRegistration;
    private final Predicate<DotName> injectionPointAnnotationsPredicate;
    private final Assignability assignability;
    private static final Map<PrimitiveType.Primitive, Set<ClassType>> WIDENING_CONVERSIONS_TO = Map.of(PrimitiveType.Primitive.BOOLEAN, Set.of(), PrimitiveType.Primitive.BYTE, Set.of(), PrimitiveType.Primitive.SHORT, Set.of(ClassType.BYTE_CLASS), PrimitiveType.Primitive.INT, Set.of(ClassType.BYTE_CLASS, ClassType.SHORT_CLASS, ClassType.CHARACTER_CLASS), PrimitiveType.Primitive.LONG, Set.of(ClassType.BYTE_CLASS, ClassType.SHORT_CLASS, ClassType.INTEGER_CLASS, ClassType.CHARACTER_CLASS), PrimitiveType.Primitive.FLOAT, Set.of(ClassType.BYTE_CLASS, ClassType.SHORT_CLASS, ClassType.INTEGER_CLASS, ClassType.LONG_CLASS, ClassType.CHARACTER_CLASS), PrimitiveType.Primitive.DOUBLE, Set.of(ClassType.BYTE_CLASS, ClassType.SHORT_CLASS, ClassType.INTEGER_CLASS, ClassType.LONG_CLASS, ClassType.FLOAT_CLASS, ClassType.CHARACTER_CLASS), PrimitiveType.Primitive.CHAR, Set.of());

    InvokerGenerator(boolean generateSources, Predicate<DotName> applicationClassPredicate, BeanDeployment deployment, AnnotationLiteralProcessor annotationLiterals, ReflectionRegistration reflectionRegistration, Predicate<DotName> injectionPointAnnotationsPredicate) {
        super(generateSources);
        this.applicationClassPredicate = applicationClassPredicate;
        this.beanArchiveIndex = deployment.getBeanArchiveIndex();
        this.beanDeployment = deployment;
        this.annotationLiterals = annotationLiterals;
        this.reflectionRegistration = reflectionRegistration;
        this.injectionPointAnnotationsPredicate = injectionPointAnnotationsPredicate;
        this.assignability = new Assignability(deployment.getBeanArchiveIndex());
    }

    Collection<ResourceOutput.Resource> generate(InvokerInfo invoker) {
        Function<String, ResourceOutput.Resource.SpecialType> specialTypeFunction = className -> {
            if (className.equals(invoker.className) || className.equals(invoker.wrapperClassName) || className.equals(invoker.lazyClassName)) {
                return ResourceOutput.Resource.SpecialType.INVOKER;
            }
            return null;
        };
        ResourceClassOutput classOutput = new ResourceClassOutput(this.applicationClassPredicate.test(invoker.targetBeanClass.name()), specialTypeFunction, this.generateSources);
        Gizmo gizmo = InvokerGenerator.gizmo(classOutput);
        this.createInvokerLazyClass(gizmo, invoker);
        this.createInvokerWrapperClass(gizmo, invoker);
        this.createInvokerClass(gizmo, invoker);
        return classOutput.getResources();
    }

    private void createInvokerLazyClass(Gizmo gizmo, InvokerInfo invoker) {
        if (!invoker.usesLookup) {
            return;
        }
        gizmo.class_(invoker.lazyClassName, cc -> {
            cc.implements_(Invoker.class);
            cc.defaultConstructor();
            cc.method("invoke", mc -> {
                mc.returning(Object.class);
                ParamVar instance = mc.parameter("instance", Object.class);
                ParamVar arguments = mc.parameter("arguments", Object[].class);
                mc.body(bc -> {
                    ClassDesc invokerClass = invoker.wrapperClassName != null ? ClassDesc.of(invoker.wrapperClassName) : ClassDesc.of(invoker.className);
                    Expr delegate = bc.invokeStatic((MethodDesc)ClassMethodDesc.of((ClassDesc)invokerClass, (String)"get", Invoker.class, (Class[])new Class[0]));
                    Expr result = bc.invokeInterface(MethodDesc.of(Invoker.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), delegate, (Expr)instance, (Expr)arguments);
                    bc.return_(result);
                });
            });
        });
    }

    private void createInvokerWrapperClass(Gizmo gizmo, InvokerInfo invoker) {
        if (invoker.wrapperClassName == null) {
            return;
        }
        gizmo.class_(invoker.wrapperClassName, cc -> {
            cc.implements_(Invoker.class);
            FieldDesc delegate = cc.field("delegate", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Invoker.class);
            });
            ConstructorDesc ctor = cc.constructor(mc -> mc.body(bc -> {
                bc.invokeSpecial(ConstructorDesc.of(Object.class, (Class[])new Class[0]), (Expr)cc.this_());
                bc.set((Assignable)cc.this_().field(delegate), bc.invokeStatic((MethodDesc)ClassMethodDesc.of((ClassDesc)ClassDesc.of(invoker.className), (String)"get", Invoker.class, (Class[])new Class[0])));
                bc.return_();
            }));
            cc.method("invoke", mc -> {
                mc.returning(Object.class);
                ParamVar instance = mc.parameter("instance", Object.class);
                ParamVar arguments = mc.parameter("arguments", Object[].class);
                mc.body(bc -> {
                    MethodInfo wrappingMethod = this.findWrapper(invoker);
                    Expr result = bc.invokeStatic(Jandex2Gizmo.methodDescOf((MethodInfo)wrappingMethod), new Expr[]{instance, arguments, cc.this_().field(delegate)});
                    if (wrappingMethod.returnType().kind() == Type.Kind.VOID) {
                        result = Const.ofNull(Object.class);
                    }
                    bc.return_(result);
                });
            });
            this.generateStaticGetMethod((ClassCreator)cc, ctor);
        });
    }

    private MethodInfo findWrapper(InvokerInfo invoker) {
        InvocationTransformer wrapper = invoker.invocationWrapper;
        ClassInfo clazz = this.beanArchiveIndex.getClassByName(wrapper.clazz);
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (MethodInfo method : clazz.methods()) {
            if (!Modifier.isStatic(method.flags()) || !wrapper.method.equals(method.name())) continue;
            methods.add(method);
        }
        ArrayList<MethodInfo> matching = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> notMatching = new ArrayList<MethodInfo>();
        for (MethodInfo method : methods) {
            if (method.parametersCount() == 3 && method.parameterType(1).kind() == Type.Kind.ARRAY && method.parameterType(1).asArrayType().deepDimensions() == 1 && method.parameterType(1).asArrayType().elementType().name().equals((Object)DotName.OBJECT_NAME) && method.parameterType(2).name().equals((Object)DotName.createSimple(Invoker.class))) {
                boolean invokerTargetInstanceOk;
                Type targetInstanceType = method.parameterType(0);
                boolean targetInstanceOk = InvokerGenerator.isAnyType(targetInstanceType) || this.assignability.isSupertype(targetInstanceType, (Type)ClassType.create((DotName)invoker.targetBeanClass.name()));
                boolean isInvokerRaw = method.parameterType(2).kind() == Type.Kind.CLASS;
                boolean isInvokerParameterized = method.parameterType(2).kind() == Type.Kind.PARAMETERIZED_TYPE && method.parameterType(2).asParameterizedType().arguments().size() == 2;
                boolean bl = invokerTargetInstanceOk = isInvokerRaw || isInvokerParameterized && targetInstanceType.equals(method.parameterType(2).asParameterizedType().arguments().get(0));
                if (targetInstanceOk && invokerTargetInstanceOk) {
                    matching.add(method);
                    continue;
                }
                notMatching.add(method);
                continue;
            }
            notMatching.add(method);
        }
        if (matching.size() == 1) {
            return (MethodInfo)matching.get(0);
        }
        if (matching.isEmpty()) {
            String expectation = "\tmatching methods must be `static` and take 3 parameters (instance, argument array, invoker)\n\tthe 1st parameter must be a supertype of " + String.valueOf(invoker.targetBeanClass.name()) + ", possibly Object\n\tthe 2nd parameter must be Object[]\n\tthe 3rd parameter must be Invoker<type of 1st parameter, some type>";
            if (notMatching.isEmpty()) {
                throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(invoker) + ":\n\tno matching method found for " + String.valueOf(wrapper) + "\n" + expectation);
            }
            throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(invoker) + ":\n\tno matching method found for " + String.valueOf(wrapper) + "\n\tfound methods that do not match:\n" + notMatching.stream().map(it -> "\t- " + String.valueOf(it)).collect(Collectors.joining("\n")) + "\n" + expectation);
        }
        throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(invoker) + ":\n\ttoo many matching methods for " + String.valueOf(wrapper) + ":\n" + matching.stream().map(it -> "\t- " + String.valueOf(it)).collect(Collectors.joining("\n")));
    }

    private void createInvokerClass(Gizmo gizmo, InvokerInfo invoker) {
        CodeGenInfo info = this.preprocess(invoker);
        gizmo.class_(invoker.className, cc -> {
            cc.implements_(Invoker.class);
            FieldDesc[] argumentSuppliers = new FieldDesc[invoker.method.parametersCount()];
            FieldDesc instanceSupplier = info.instanceLookup != null ? cc.field("instance", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Supplier.class);
            }) : null;
            for (int i = 0; i < info.argumentLookups.length; ++i) {
                if (info.argumentLookups[i] == null) continue;
                argumentSuppliers[i] = cc.field("arg" + i, fc -> {
                    fc.private_();
                    fc.final_();
                    fc.setType(Supplier.class);
                });
            }
            ConstructorDesc ctor = cc.constructor(mc -> mc.body(bc -> {
                bc.invokeSpecial(ConstructorDesc.of(Object.class, (Class[])new Class[0]), (Expr)cc.this_());
                if (info.usesLookup) {
                    LocalVar arc = bc.localVar("arc", bc.invokeStatic(MethodDescs.ARC_REQUIRE_CONTAINER));
                    if (instanceSupplier != null) {
                        Expr instanceBean = bc.invokeInterface(MethodDescs.ARC_CONTAINER_BEAN, (Expr)arc, (Expr)Const.of((String)info.instanceLookup.getUserBean().getIdentifier()));
                        bc.set((Assignable)cc.this_().field(instanceSupplier), instanceBean);
                    }
                    for (int i = 0; i < argumentSuppliers.length; ++i) {
                        if (argumentSuppliers[i] == null) continue;
                        ResolvedBean resolved = info.argumentLookups[i];
                        if (resolved.isUserBean()) {
                            Expr argumentBean = bc.invokeInterface(MethodDescs.ARC_CONTAINER_BEAN, (Expr)arc, (Expr)Const.of((String)resolved.getUserBean().getIdentifier()));
                            bc.set((Assignable)cc.this_().field(argumentSuppliers[i]), argumentBean);
                            continue;
                        }
                        BuiltinBean builtinBean = resolved.getBuiltinBean();
                        InjectionPointInfo injectionPoint = invoker.getInjectionPointForArgument(i);
                        builtinBean.getGenerator().generate(new BuiltinBean.GeneratorContext(this.beanDeployment, invoker, injectionPoint, (ClassCreator)cc, (BlockCreator)bc, argumentSuppliers[i], this.annotationLiterals, this.reflectionRegistration, this.injectionPointAnnotationsPredicate, null));
                    }
                }
                bc.return_();
            }));
            cc.method("invoke", mc -> {
                mc.returning(Object.class);
                ParamVar instanceParam = mc.parameter("instance", Object.class);
                ParamVar argumentsParam = mc.parameter("arguments", Object[].class);
                mc.body(b0 -> {
                    LocalVar cleanupTasks = info.usesCleanupTasks ? b0.localVar("cleanupTasks", b0.new_(InvokerCleanupTasks.class)) : null;
                    LocalVar rootCC = info.usesLookup ? b0.localVar("cc", b0.new_(CreationalContextImpl.class, (Expr)Const.ofNull(Contextual.class))) : null;
                    ParamVar instance = null;
                    if (!Modifier.isStatic(invoker.method.flags())) {
                        Object object = instance = info.instanceLookup != null ? b0.localVar("instance", this.generateLookup((ClassCreator)cc, (BlockCreator)b0, instanceSupplier, rootCC)) : instanceParam;
                        if (info.instanceTransformer != null) {
                            instance = b0.localVar("transformedInstance", this.generateTransformerCall((BlockCreator)b0, info.instanceTransformer, (Var)instance, cleanupTasks));
                        }
                    }
                    ParamVar instanceFinal = instance;
                    Var[] arguments = new Var[invoker.method.parametersCount()];
                    for (int i = 0; i < invoker.method.parametersCount(); ++i) {
                        Type parameterType = invoker.method.parameterType(i);
                        LocalVar localVar = arguments[i] = info.argumentLookups[i] != null ? b0.localVar("arg" + i, this.generateLookup((ClassCreator)cc, (BlockCreator)b0, argumentSuppliers[i], rootCC)) : b0.localVar("arg" + i, (Expr)argumentsParam.elem(i));
                        if (info.argumentTransformers[i] != null) {
                            arguments[i] = b0.localVar("transformedArg" + i, this.generateTransformerCall((BlockCreator)b0, info.argumentTransformers[i], arguments[i], cleanupTasks));
                            if (info.argumentTransformers[i].method.returnType().kind() == Type.Kind.PRIMITIVE) {
                                arguments[i] = b0.localVar("boxedArg" + i, b0.box((Expr)arguments[i]));
                            }
                        }
                        if (parameterType.kind() != Type.Kind.PRIMITIVE) continue;
                        LocalVar primitiveArg = b0.localVar("primitiveArg" + i, (Expr)Const.ofDefault((ClassDesc)Jandex2Gizmo.classDescOf((Type)parameterType)));
                        int finalI = i;
                        b0.ifElse(b0.isNotNull((Expr)arguments[i]), b1 -> InvokerGenerator.unboxAndWiden(b1, arguments[finalI], (Var)primitiveArg, invoker.method.parameterType(finalI).asPrimitiveType(), finalI), b1 -> b1.throw_(NullPointerException.class, "Argument " + finalI + " is null, " + String.valueOf(invoker.method.parameterType(finalI)) + " expected"));
                        arguments[i] = primitiveArg;
                    }
                    if (info.usesLookup && invoker.method.parametersCount() > 0) {
                        b0.get(argumentsParam.elem(invoker.method.parametersCount() - 1));
                    }
                    b0.try_(arg_0 -> this.lambda$createInvokerClass$20(invoker, arguments, (Var)instanceFinal, cleanupTasks, rootCC, info, arg_0));
                });
            });
            this.generateStaticGetMethod((ClassCreator)cc, ctor);
        });
    }

    private Expr generateLookup(ClassCreator cc, BlockCreator bc, FieldDesc supplierField, LocalVar rootCC) {
        LocalVar injectableReferenceProvider = bc.localVar("injectableReferenceProvider", bc.invokeInterface(MethodDescs.SUPPLIER_GET, (Expr)cc.this_().field(supplierField)));
        LocalVar creationalContext = bc.localVar("creationalContext", bc.invokeStatic(MethodDescs.CREATIONAL_CTX_CHILD_CONTEXTUAL, (Expr)injectableReferenceProvider, (Expr)rootCC));
        return bc.invokeInterface(MethodDescs.INJECTABLE_REF_PROVIDER_GET, (Expr)injectableReferenceProvider, (Expr)creationalContext);
    }

    private Expr generateTransformerCall(BlockCreator bc, TransformerMethod transformerMethod, Var value, LocalVar cleanupTasks) {
        assert (transformerMethod != null);
        MethodDesc methodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)transformerMethod.method);
        if (Modifier.isStatic(transformerMethod.method.flags())) {
            if (transformerMethod.usesCleanupTasks()) {
                return bc.invokeStatic(methodDesc, (Expr)value, (Expr)cleanupTasks);
            }
            return bc.invokeStatic(methodDesc, (Expr)value);
        }
        if (transformerMethod.method.declaringClass().isInterface()) {
            return bc.invokeInterface(methodDesc, (Expr)value);
        }
        return bc.invokeVirtual(methodDesc, (Expr)value);
    }

    private Expr generateCCRelease(BlockCreator bc, InvokerInfo invoker, LocalVar rootCC, LocalVar returnValue) {
        assert (rootCC != null);
        if (returnValue == null || !invoker.isAsynchronous()) {
            bc.invokeInterface(MethodDescs.CREATIONAL_CTX_RELEASE, (Expr)rootCC);
            return returnValue;
        }
        ClassDesc asyncType = Jandex2Gizmo.classDescOf((Type)invoker.method.returnType());
        return bc.invokeStatic((MethodDesc)ClassMethodDesc.of((ClassDesc)Reflection2Gizmo.classDescOf(InvokerCleanupTasks.class), (String)"deferRelease", (MethodTypeDesc)MethodTypeDesc.of(asyncType, Reflection2Gizmo.classDescOf(CreationalContext.class), asyncType)), (Expr)rootCC, (Expr)returnValue);
    }

    private void generateStaticGetMethod(ClassCreator cc, ConstructorDesc ctor) {
        StaticFieldVar instance = cc.staticField("INSTANCE", fc -> {
            fc.private_();
            fc.final_();
            fc.setType(AtomicReference.class);
            fc.setInitializer(bc -> bc.yield(bc.new_(AtomicReference.class)));
        });
        MethodDesc atomicReferenceGet = MethodDesc.of(AtomicReference.class, (String)"get", Object.class, (Class[])new Class[0]);
        MethodDesc atomicReferenceCAS = MethodDesc.of(AtomicReference.class, (String)"compareAndSet", Boolean.TYPE, (Class[])new Class[]{Object.class, Object.class});
        cc.staticMethod("get", mc -> {
            mc.returning(Invoker.class);
            mc.body(b0 -> {
                LocalVar result = b0.localVar("result", b0.invokeVirtual(atomicReferenceGet, (Expr)instance));
                b0.ifNull((Expr)result, b1 -> {
                    b1.invokeVirtual(atomicReferenceCAS, (Expr)instance, (Expr)Const.ofNull(Invoker.class), b1.new_(ctor));
                    b1.set((Assignable)result, b1.invokeVirtual(atomicReferenceGet, (Expr)instance));
                });
                b0.return_((Expr)result);
            });
        });
    }

    private static void unboxAndWiden(BlockCreator b0, Var value, Var target, PrimitiveType targetType, int argumentNumber) {
        LocalVar ok = b0.localVar("ok" + argumentNumber, (Expr)Const.of((boolean)false));
        b0.ifInstanceOf((Expr)value, Jandex2Gizmo.classDescOf((Type)PrimitiveType.box((PrimitiveType)targetType)), (b1, cast) -> {
            b1.set((Assignable)target, (Expr)cast);
            b1.set((Assignable)ok, Const.of((boolean)true));
        });
        for (ClassType possibleType : WIDENING_CONVERSIONS_TO.get(targetType.primitive())) {
            b0.ifInstanceOf((Expr)value, Jandex2Gizmo.classDescOf((Type)possibleType), (b1, cast) -> {
                b1.set((Assignable)target, (Expr)cast);
                b1.set((Assignable)ok, Const.of((boolean)true));
            });
        }
        b0.ifNot((Expr)ok, b1 -> b1.throw_(ClassCastException.class, StringBuilderGen.ofNew((BlockCreator)b1).append("No method invocation conversion to ").append(targetType.name().toString()).append(" exists for argument ").append("" + argumentNumber).append(": ").append(b1.withObject((Expr)value).getClass_()).append(", value ").append((Expr)value).toString_()));
    }

    private CodeGenInfo preprocess(InvokerInfo invoker) {
        boolean usesLookup = false;
        ResolvedBean instanceLookup = null;
        if (invoker.instanceLookup) {
            instanceLookup = ResolvedBean.of(invoker.targetBean);
            usesLookup = true;
        }
        ResolvedBean[] argumentLookups = new ResolvedBean[invoker.argumentLookups.length];
        for (int i = 0; i < invoker.argumentLookups.length; ++i) {
            if (!invoker.argumentLookups[i]) continue;
            InjectionPointInfo injectionPoint = invoker.getInjectionPointForArgument(i);
            if (injectionPoint == null) {
                throw new IllegalStateException("No injection point for argument " + i + " of " + String.valueOf(invoker));
            }
            argumentLookups[i] = ResolvedBean.of(injectionPoint);
            usesLookup = true;
        }
        boolean usesCleanupTasks = false;
        TransformerMethod instanceTransformer = null;
        if (invoker.instanceTransformer != null) {
            ClassType instanceType = ClassType.create((DotName)invoker.targetBeanClass.name());
            instanceTransformer = this.findCandidates(invoker.instanceTransformer, (Type)instanceType, invoker).resolve();
            usesCleanupTasks |= instanceTransformer.usesCleanupTasks();
        }
        TransformerMethod[] argumentTransfomers = new TransformerMethod[invoker.argumentTransformers.length];
        for (int i = 0; i < invoker.argumentTransformers.length; ++i) {
            if (invoker.argumentTransformers[i] == null) continue;
            Type parameterType = invoker.method.parameterType(i);
            argumentTransfomers[i] = this.findCandidates(invoker.argumentTransformers[i], parameterType, invoker).resolve();
            usesCleanupTasks |= argumentTransfomers[i].usesCleanupTasks();
        }
        TransformerMethod returnValueTransformer = null;
        if (invoker.returnValueTransformer != null) {
            Type returnType = invoker.method.returnType();
            returnValueTransformer = this.findCandidates(invoker.returnValueTransformer, returnType, invoker).resolve();
            usesCleanupTasks |= returnValueTransformer.usesCleanupTasks();
        }
        TransformerMethod exceptionTransformer = null;
        if (invoker.exceptionTransformer != null) {
            ClassType throwableType = ClassType.create(Throwable.class);
            exceptionTransformer = this.findCandidates(invoker.exceptionTransformer, (Type)throwableType, invoker).resolve();
            usesCleanupTasks |= exceptionTransformer.usesCleanupTasks();
        }
        return new CodeGenInfo(instanceLookup, argumentLookups, instanceTransformer, argumentTransfomers, returnValueTransformer, exceptionTransformer, usesLookup, usesCleanupTasks);
    }

    private TransformerMethodCandidates findCandidates(InvocationTransformer transformer, Type expectedType, InvokerInfo invoker) {
        assert (transformer.kind != InvocationTransformerKind.WRAPPER);
        ClassInfo clazz = this.beanArchiveIndex.getClassByName(transformer.clazz);
        ArrayDeque<ClassInfo> worklist = new ArrayDeque<ClassInfo>();
        while (clazz != null) {
            worklist.addLast(clazz);
            clazz = clazz.superName() == null ? null : this.beanArchiveIndex.getClassByName(clazz.superName());
        }
        boolean originalClass = true;
        HashSet<Methods.MethodKey> seenMethods = new HashSet<Methods.MethodKey>();
        while (!worklist.isEmpty()) {
            ClassInfo current = (ClassInfo)worklist.removeFirst();
            for (MethodInfo method : current.methods()) {
                if (!transformer.method.equals(method.name())) continue;
                Methods.MethodKey key = new Methods.MethodKey(method);
                if (Modifier.isStatic(method.flags()) && originalClass) {
                    seenMethods.add(key);
                    continue;
                }
                if (Methods.isOverriden(key, seenMethods)) continue;
                seenMethods.add(key);
            }
            for (DotName iface : current.interfaceNames()) {
                worklist.addLast(this.beanArchiveIndex.getClassByName(iface));
            }
            originalClass = false;
        }
        ArrayList<TransformerMethod> matching = new ArrayList<TransformerMethod>();
        ArrayList<TransformerMethod> notMatching = new ArrayList<TransformerMethod>();
        for (Methods.MethodKey seenMethod : seenMethods) {
            TransformerMethod candidate = new TransformerMethod(seenMethod.method, this.assignability);
            if (candidate.matches(transformer, expectedType)) {
                matching.add(candidate);
                continue;
            }
            notMatching.add(candidate);
        }
        return new TransformerMethodCandidates(transformer, expectedType, matching, notMatching, invoker);
    }

    static boolean isAnyType(Type t) {
        if (ClassType.OBJECT_TYPE.equals((Object)t)) {
            return true;
        }
        if (t.kind() == Type.Kind.TYPE_VARIABLE) {
            TypeVariable typeVar = t.asTypeVariable();
            return typeVar.bounds().isEmpty() || typeVar.hasImplicitObjectBound() || InvokerGenerator.isAnyType((Type)typeVar.bounds().get(0));
        }
        return false;
    }

    private /* synthetic */ void lambda$createInvokerClass$20(InvokerInfo invoker, Var[] arguments, Var instanceFinal, LocalVar cleanupTasks, LocalVar rootCC, CodeGenInfo info, TryCreator tc) {
        tc.body(b1 -> {
            MethodDesc methodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)invoker.method);
            Expr result = Modifier.isStatic(invoker.method.flags()) ? b1.invokeStatic(methodDesc, (Expr[])arguments) : (invoker.method.declaringClass().isInterface() ? b1.invokeInterface(methodDesc, (Expr)instanceFinal, (Expr[])arguments) : b1.invokeVirtual(methodDesc, (Expr)instanceFinal, (Expr[])arguments));
            boolean isVoid = invoker.method.returnType().kind() == Type.Kind.VOID;
            LocalVar resultVar = b1.localVar("result", (Expr)(isVoid ? Const.ofNull(Object.class) : result));
            if (cleanupTasks != null) {
                b1.invokeVirtual(MethodDesc.of(InvokerCleanupTasks.class, (String)"finish", Void.TYPE, (Class[])new Class[0]), (Expr)cleanupTasks);
            }
            if (rootCC != null) {
                b1.set((Assignable)resultVar, this.generateCCRelease((BlockCreator)b1, invoker, rootCC, resultVar));
            }
            if (info.returnValueTransformer != null) {
                b1.set((Assignable)resultVar, this.generateTransformerCall((BlockCreator)b1, info.returnValueTransformer, (Var)resultVar, cleanupTasks));
            }
            b1.return_((Expr)resultVar);
        });
        tc.catch_(Throwable.class, "e", (b1, e) -> {
            if (cleanupTasks != null) {
                b1.invokeVirtual(MethodDesc.of(InvokerCleanupTasks.class, (String)"finish", Void.TYPE, (Class[])new Class[0]), (Expr)cleanupTasks);
            }
            if (rootCC != null) {
                this.generateCCRelease((BlockCreator)b1, invoker, rootCC, null);
            }
            if (invoker.exceptionTransformer != null) {
                b1.return_(this.generateTransformerCall((BlockCreator)b1, info.exceptionTransformer, (Var)e, null));
            } else {
                b1.throw_((Expr)e);
            }
        });
    }

    static class Assignability {
        private final AssignabilityCheck assignabilityCheck;

        Assignability(IndexView index) {
            this.assignabilityCheck = new AssignabilityCheck(index, null);
        }

        boolean isSubtype(Type a, Type b) {
            Objects.requireNonNull(a);
            Objects.requireNonNull(b);
            switch (a.kind()) {
                case VOID: {
                    return b.kind() == Type.Kind.VOID || b.kind() == Type.Kind.CLASS && b.asClassType().name().equals((Object)DotName.createSimple(Void.class));
                }
                case PRIMITIVE: {
                    return b.kind() == Type.Kind.PRIMITIVE && a.asPrimitiveType().primitive() == b.asPrimitiveType().primitive();
                }
                case ARRAY: {
                    return b.kind() == Type.Kind.ARRAY && a.asArrayType().deepDimensions() == b.asArrayType().deepDimensions() && this.isSubtype(a.asArrayType().elementType(), b.asArrayType().elementType());
                }
                case CLASS: {
                    if (b.kind() == Type.Kind.VOID) {
                        return a.asClassType().name().equals((Object)DotName.createSimple(Void.class));
                    }
                    if (b.kind() == Type.Kind.CLASS) {
                        return this.isClassSubtype(a.asClassType(), b.asClassType());
                    }
                    if (b.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        return this.isClassSubtype(a.asClassType(), ClassType.create((DotName)b.name()));
                    }
                    if (b.kind() == Type.Kind.TYPE_VARIABLE) {
                        ClassType firstBound = b.asTypeVariable().bounds().isEmpty() ? ClassType.OBJECT_TYPE : (Type)b.asTypeVariable().bounds().get(0);
                        return this.isSubtype(a, (Type)firstBound);
                    }
                    return false;
                }
                case PARAMETERIZED_TYPE: {
                    if (b.kind() == Type.Kind.CLASS) {
                        return this.isClassSubtype(ClassType.create((DotName)a.name()), b.asClassType());
                    }
                    if (b.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        return this.isClassSubtype(ClassType.create((DotName)a.name()), ClassType.create((DotName)b.name()));
                    }
                    if (b.kind() == Type.Kind.TYPE_VARIABLE) {
                        ClassType firstBound = b.asTypeVariable().bounds().isEmpty() ? ClassType.OBJECT_TYPE : (Type)b.asTypeVariable().bounds().get(0);
                        return this.isSubtype(a, (Type)firstBound);
                    }
                    return false;
                }
                case TYPE_VARIABLE: {
                    if (b.kind() == Type.Kind.CLASS || b.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                        ClassType firstBound = a.asTypeVariable().bounds().isEmpty() ? ClassType.OBJECT_TYPE : (Type)a.asTypeVariable().bounds().get(0);
                        return this.isSubtype((Type)firstBound, b);
                    }
                    return false;
                }
            }
            throw new IllegalArgumentException("Cannot determine assignability between " + String.valueOf(a) + " and " + String.valueOf(b));
        }

        boolean isSupertype(Type a, Type b) {
            return this.isSubtype(b, a);
        }

        private boolean isClassSubtype(ClassType a, ClassType b) {
            return this.assignabilityCheck.isAssignableFrom((Type)b, (Type)a);
        }
    }

    private record CodeGenInfo(ResolvedBean instanceLookup, ResolvedBean[] argumentLookups, TransformerMethod instanceTransformer, TransformerMethod[] argumentTransformers, TransformerMethod returnValueTransformer, TransformerMethod exceptionTransformer, boolean usesLookup, boolean usesCleanupTasks) {
    }

    static class TransformerMethod {
        final MethodInfo method;
        private final Assignability assignability;

        TransformerMethod(MethodInfo method, Assignability assignability) {
            this.method = method;
            this.assignability = assignability;
        }

        boolean matches(InvocationTransformer transformer, Type expectedType) {
            if (transformer.isInputTransformer()) {
                boolean returnTypeOk;
                boolean bl = returnTypeOk = InvokerGenerator.isAnyType(this.method.returnType()) || this.isSubtype(this.method.returnType(), expectedType);
                if (Modifier.isStatic(this.method.flags())) {
                    return this.method.parametersCount() == 1 && returnTypeOk || this.method.parametersCount() == 2 && returnTypeOk && this.isConsumerOfRunnable(this.method.parameterType(1));
                }
                return this.method.parametersCount() == 0 && returnTypeOk;
            }
            if (transformer.isOutputTransformer()) {
                if (Modifier.isStatic(this.method.flags())) {
                    return this.method.parametersCount() == 1 && (InvokerGenerator.isAnyType(this.method.parameterType(0)) || this.isSupertype(this.method.parameterType(0), expectedType));
                }
                return this.method.parametersCount() == 0 && this.isSupertype((Type)ClassType.create((DotName)this.method.declaringClass().name()), expectedType);
            }
            throw new IllegalArgumentException(transformer.toString());
        }

        boolean usesCleanupTasks() {
            return Modifier.isStatic(this.method.flags()) && this.method.parametersCount() == 2 && this.isConsumerOfRunnable(this.method.parameterType(1));
        }

        private boolean isConsumerOfRunnable(Type type) {
            return type.kind() == Type.Kind.PARAMETERIZED_TYPE && type.name().equals((Object)DotName.createSimple(Consumer.class)) && type.asParameterizedType().arguments().size() == 1 && ((Type)type.asParameterizedType().arguments().get(0)).kind() == Type.Kind.CLASS && ((Type)type.asParameterizedType().arguments().get(0)).name().equals((Object)DotName.createSimple(Runnable.class));
        }

        private boolean isSubtype(Type a, Type b) {
            return this.assignability.isSubtype(a, b);
        }

        private boolean isSupertype(Type a, Type b) {
            return this.assignability.isSupertype(a, b);
        }

        public String toString() {
            return this.method.toString() + " declared on " + String.valueOf(this.method.declaringClass());
        }
    }

    static class ResolvedBean {
        private final BeanInfo userBean;
        private final BuiltinBean builtinBean;

        static ResolvedBean of(BeanInfo userBean) {
            return new ResolvedBean(userBean, null);
        }

        static ResolvedBean of(InjectionPointInfo injectionPoint) {
            BeanInfo userBean = injectionPoint.getResolvedBean();
            if (userBean != null) {
                return new ResolvedBean(userBean, null);
            }
            BuiltinBean builtinBean = BuiltinBean.resolve(injectionPoint);
            if (builtinBean != null) {
                return new ResolvedBean(null, builtinBean);
            }
            throw new IllegalStateException("Injection point not resolved: " + String.valueOf(injectionPoint));
        }

        private ResolvedBean(BeanInfo userBean, BuiltinBean builtinBean) {
            this.userBean = userBean;
            this.builtinBean = builtinBean;
        }

        boolean isUserBean() {
            return this.userBean != null;
        }

        boolean isBuiltinBean() {
            return this.builtinBean != null;
        }

        BeanInfo getUserBean() {
            assert (this.isUserBean());
            return this.userBean;
        }

        BuiltinBean getBuiltinBean() {
            assert (this.isBuiltinBean());
            return this.builtinBean;
        }

        boolean requiresDestruction() {
            return this.userBean != null && BuiltinScope.DEPENDENT.is(this.userBean.getScope());
        }
    }

    static class TransformerMethodCandidates {
        final InvocationTransformer transformer;
        final Type expectedType;
        final List<TransformerMethod> matching;
        final List<TransformerMethod> notMatching;
        final InvokerInfo invoker;

        TransformerMethodCandidates(InvocationTransformer transformer, Type expectedType, List<TransformerMethod> matching, List<TransformerMethod> notMatching, InvokerInfo invoker) {
            this.transformer = transformer;
            this.expectedType = expectedType;
            this.matching = matching;
            this.notMatching = notMatching;
            this.invoker = invoker;
        }

        @SuppressForbidden(reason="Using Type.toString() to build an informative message")
        TransformerMethod resolve() {
            if (this.matching.size() == 1) {
                return this.matching.get(0);
            }
            if (this.matching.isEmpty()) {
                String expectedType = this.expectedType.toString();
                Object expectation = "";
                if (this.transformer.isInputTransformer()) {
                    expectation = "\n\tmatching `static` methods must take 1 or 2 parameters and return " + expectedType + " (or subtype)\n\t(if the `static` method takes 2 parameters, the 2nd must be `Consumer<Runnable>`)\n\tmatching instance methods must take no parameter and return " + expectedType + " (or subtype)";
                } else if (this.transformer.isOutputTransformer()) {
                    expectation = "\n\tmatching `static` method must take 1 parameter of type " + expectedType + " (or supertype)\n\tmatching instance methods must be declared on " + expectedType + " (or supertype) and take no parameter";
                }
                if (this.notMatching.isEmpty()) {
                    throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(this.invoker) + ":\n\tno matching method found for " + String.valueOf(this.transformer) + (String)expectation);
                }
                throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(this.invoker) + ":\n\tno matching method found for " + String.valueOf(this.transformer) + "\n\tfound methods that do not match:\n" + this.notMatching.stream().map(it -> "\t- " + String.valueOf(it)).collect(Collectors.joining("\n")) + (String)expectation);
            }
            throw new IllegalArgumentException("Error creating invoker for method " + String.valueOf(this.invoker) + ":\n\ttoo many matching methods for " + String.valueOf(this.transformer) + ":\n" + this.matching.stream().map(it -> "\t- " + String.valueOf(it)).collect(Collectors.joining("\n")));
        }
    }
}

