/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.Arc;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.gizmo2.ClassHierarchyLocator;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Gizmo;
import java.lang.constant.ClassDesc;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

abstract class AbstractGenerator {
    static final String DEFAULT_PACKAGE = Arc.class.getPackage().getName() + ".generator";
    static final String UNDERSCORE = "_";
    static final String SYNTHETIC_SUFFIX = "Synthetic";
    private static final Map<ClassDesc, ClassHierarchyLocator.Result> classHierarchyCache = new ConcurrentHashMap<ClassDesc, ClassHierarchyLocator.Result>();
    protected final boolean generateSources;
    protected final ReflectionRegistration reflectionRegistration;

    public AbstractGenerator(boolean generateSources, ReflectionRegistration reflectionRegistration) {
        this.generateSources = generateSources;
        this.reflectionRegistration = reflectionRegistration;
    }

    public AbstractGenerator(boolean generateSources) {
        this(generateSources, null);
    }

    static Gizmo gizmo(ClassOutput classOutput) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl == null) {
            throw new IllegalStateException("No TCCL available");
        }
        ClassHierarchyLocator locator = ClassHierarchyLocator.forClassParsing((ClassLoader)tccl).cached(() -> classHierarchyCache);
        return Gizmo.create((ClassOutput)classOutput).withClassHierarchyLocator(locator).withDebugInfo(false).withParameters(false).withLambdasAsAnonymousClasses(true);
    }

    static String generatedNameFromTarget(String targetPackage, String baseName, String suffix) {
        if (targetPackage == null || targetPackage.isEmpty()) {
            return baseName + suffix;
        }
        return targetPackage + "." + baseName + suffix;
    }

    protected final String getBeanBaseName(String beanClassName) {
        String simpleName = beanClassName.contains(".") ? beanClassName.substring(beanClassName.lastIndexOf(".") + 1) : beanClassName;
        return simpleName.substring(0, simpleName.lastIndexOf("_Bean"));
    }

    protected final boolean isReflectionFallbackNeeded(MethodInfo method, String targetPackage) {
        if (Modifier.isPublic(method.flags())) {
            return false;
        }
        if (Modifier.isPrivate(method.flags())) {
            return true;
        }
        return !DotNames.packagePrefix(method.declaringClass().name()).equals(targetPackage);
    }

    protected final boolean isReflectionFallbackNeeded(FieldInfo field, String targetPackage, BeanInfo bean) {
        if (Modifier.isPublic(field.flags())) {
            return false;
        }
        if (!(!Modifier.isPrivate(field.flags()) || bean.getDeployment().transformPrivateInjectedFields && field.declaringClass().name().equals((Object)bean.getBeanClass()))) {
            return true;
        }
        return !DotNames.packagePrefix(field.declaringClass().name()).equals(targetPackage);
    }
}

